/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.ResolvableTrade;
import com.opengamma.strata.product.SecuritizedProductTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.TradedPrice;
import com.opengamma.strata.product.common.SummarizerUtils;
import com.opengamma.strata.product.index.OvernightFuture;
import com.opengamma.strata.product.index.ResolvedOvernightFuture;
import com.opengamma.strata.product.index.ResolvedOvernightFutureTrade;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class OvernightFutureTrade
implements SecuritizedProductTrade<OvernightFuture>,
ResolvableTrade<ResolvedOvernightFutureTrade>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TradeInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final OvernightFuture product;
    @PropertyDefinition(overrideGet=true)
    private final double quantity;
    @PropertyDefinition(validate="ArgChecker.notNegative", overrideGet=true)
    private final double price;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((this.price < 2.0 ? 1 : 0) != 0, (String)"Price must be in decimal form, such as 0.993 for a 0.7% rate, but was: {}", (double)this.price);
    }

    @Override
    public OvernightFutureTrade withInfo(PortfolioItemInfo info) {
        return new OvernightFutureTrade(TradeInfo.from(info), this.product, this.quantity, this.price);
    }

    @Override
    public OvernightFutureTrade withQuantity(double quantity) {
        return new OvernightFutureTrade(this.info, this.product, quantity, this.price);
    }

    @Override
    public OvernightFutureTrade withPrice(double price) {
        return new OvernightFutureTrade(this.info, this.product, this.quantity, price);
    }

    @Override
    public PortfolioItemSummary summarize() {
        String description = this.getSecurityId().getStandardId().getValue() + " x " + SummarizerUtils.value(this.getQuantity());
        return SummarizerUtils.summary(this, ProductType.OVERNIGHT_FUTURE, description, this.getCurrency());
    }

    @Override
    public ResolvedOvernightFutureTrade resolve(ReferenceData refData) {
        if (!this.info.getTradeDate().isPresent()) {
            throw new IllegalArgumentException("Trade date on TradeInfo must be present");
        }
        ResolvedOvernightFuture resolved = this.getProduct().resolve(refData);
        TradedPrice tradedPrice = TradedPrice.of(this.info.getTradeDate().get(), this.price);
        return new ResolvedOvernightFutureTrade(this.info, resolved, this.quantity, tradedPrice);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    OvernightFutureTrade(TradeInfo info, OvernightFuture product, double quantity, double price) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        ArgChecker.notNegative((double)price, (String)"price");
        this.info = info;
        this.product = product;
        this.quantity = quantity;
        this.price = price;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public TradeInfo getInfo() {
        return this.info;
    }

    @Override
    public OvernightFuture getProduct() {
        return this.product;
    }

    @Override
    public double getQuantity() {
        return this.quantity;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightFutureTrade other = (OvernightFutureTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product) && JodaBeanUtils.equal((double)this.quantity, (double)other.quantity) && JodaBeanUtils.equal((double)this.price, (double)other.price);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.quantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.price);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("OvernightFutureTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
        buf.append("price").append('=').append(JodaBeanUtils.toString((Object)this.price));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<OvernightFutureTrade> {
        private TradeInfo info;
        private OvernightFuture product;
        private double quantity;
        private double price;

        private Builder() {
            OvernightFutureTrade.applyDefaults(this);
        }

        private Builder(OvernightFutureTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
            this.quantity = beanToCopy.getQuantity();
            this.price = beanToCopy.getPrice();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 106934601: {
                    return this.price;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (TradeInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (OvernightFuture)newValue;
                    break;
                }
                case -1285004149: {
                    this.quantity = (Double)newValue;
                    break;
                }
                case 106934601: {
                    this.price = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public OvernightFutureTrade build() {
            return new OvernightFutureTrade(this.info, this.product, this.quantity, this.price);
        }

        public Builder info(TradeInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(OvernightFuture product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public Builder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder price(double price) {
            ArgChecker.notNegative((double)price, (String)"price");
            this.price = price;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("OvernightFutureTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
            buf.append("price").append('=').append(JodaBeanUtils.toString((Object)this.price));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<TradeInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", OvernightFutureTrade.class, TradeInfo.class);
        private final MetaProperty<OvernightFuture> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", OvernightFutureTrade.class, OvernightFuture.class);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quantity", OvernightFutureTrade.class, Double.TYPE);
        private final MetaProperty<Double> price = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"price", OvernightFutureTrade.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product", "quantity", "price"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 106934601: {
                    return this.price;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends OvernightFutureTrade> beanType() {
            return OvernightFutureTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<TradeInfo> info() {
            return this.info;
        }

        public MetaProperty<OvernightFuture> product() {
            return this.product;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        public MetaProperty<Double> price() {
            return this.price;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((OvernightFutureTrade)bean).getInfo();
                }
                case -309474065: {
                    return ((OvernightFutureTrade)bean).getProduct();
                }
                case -1285004149: {
                    return ((OvernightFutureTrade)bean).getQuantity();
                }
                case 106934601: {
                    return ((OvernightFutureTrade)bean).getPrice();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

