/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.rate.IborRateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class ResolvedIborFuture
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SecurityId securityId;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double accrualFactor;
    @PropertyDefinition(validate="notNull")
    private final IborRateComputation iborRate;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.rounding(Rounding.none());
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.iborRate != null) {
            if (builder.accrualFactor == 0.0 && builder.iborRate.getIndex().getTenor().isMonthBased()) {
                builder.accrualFactor((double)builder.iborRate.getIndex().getTenor().getPeriod().toTotalMonths() / 12.0);
            }
            if (builder.currency == null) {
                builder.currency = builder.iborRate.getIndex().getCurrency();
            }
        }
    }

    public IborIndex getIndex() {
        return this.iborRate.getIndex();
    }

    public LocalDate getLastTradeDate() {
        return this.iborRate.getFixingDate();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    ResolvedIborFuture(SecurityId securityId, Currency currency, double notional, double accrualFactor, IborRateComputation iborRate, Rounding rounding) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        ArgChecker.notNegativeOrZero((double)accrualFactor, (String)"accrualFactor");
        JodaBeanUtils.notNull((Object)iborRate, (String)"iborRate");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        this.securityId = securityId;
        this.currency = currency;
        this.notional = notional;
        this.accrualFactor = accrualFactor;
        this.iborRate = iborRate;
        this.rounding = rounding;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public double getAccrualFactor() {
        return this.accrualFactor;
    }

    public IborRateComputation getIborRate() {
        return this.iborRate;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedIborFuture other = (ResolvedIborFuture)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((double)this.accrualFactor, (double)other.accrualFactor) && JodaBeanUtils.equal((Object)this.iborRate, (Object)other.iborRate) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.accrualFactor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.iborRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("ResolvedIborFuture{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor)).append(',').append(' ');
        buf.append("iborRate").append('=').append(JodaBeanUtils.toString((Object)this.iborRate)).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedIborFuture> {
        private SecurityId securityId;
        private Currency currency;
        private double notional;
        private double accrualFactor;
        private IborRateComputation iborRate;
        private Rounding rounding;

        private Builder() {
            ResolvedIborFuture.applyDefaults(this);
        }

        private Builder(ResolvedIborFuture beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.accrualFactor = beanToCopy.getAccrualFactor();
            this.iborRate = beanToCopy.getIborRate();
            this.rounding = beanToCopy.getRounding();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
                case -1621804100: {
                    return this.iborRate;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1540322338: {
                    this.accrualFactor = (Double)newValue;
                    break;
                }
                case -1621804100: {
                    this.iborRate = (IborRateComputation)newValue;
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedIborFuture build() {
            ResolvedIborFuture.preBuild(this);
            return new ResolvedIborFuture(this.securityId, this.currency, this.notional, this.accrualFactor, this.iborRate, this.rounding);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder accrualFactor(double accrualFactor) {
            ArgChecker.notNegativeOrZero((double)accrualFactor, (String)"accrualFactor");
            this.accrualFactor = accrualFactor;
            return this;
        }

        public Builder iborRate(IborRateComputation iborRate) {
            JodaBeanUtils.notNull((Object)iborRate, (String)"iborRate");
            this.iborRate = iborRate;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("ResolvedIborFuture.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor)).append(',').append(' ');
            buf.append("iborRate").append('=').append(JodaBeanUtils.toString((Object)this.iborRate)).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", ResolvedIborFuture.class, SecurityId.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ResolvedIborFuture.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", ResolvedIborFuture.class, Double.TYPE);
        private final MetaProperty<Double> accrualFactor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualFactor", ResolvedIborFuture.class, Double.TYPE);
        private final MetaProperty<IborRateComputation> iborRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"iborRate", ResolvedIborFuture.class, IborRateComputation.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", ResolvedIborFuture.class, Rounding.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "currency", "notional", "accrualFactor", "iborRate", "rounding"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
                case -1621804100: {
                    return this.iborRate;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedIborFuture> beanType() {
            return ResolvedIborFuture.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<Double> accrualFactor() {
            return this.accrualFactor;
        }

        public MetaProperty<IborRateComputation> iborRate() {
            return this.iborRate;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((ResolvedIborFuture)bean).getSecurityId();
                }
                case 575402001: {
                    return ((ResolvedIborFuture)bean).getCurrency();
                }
                case 1585636160: {
                    return ((ResolvedIborFuture)bean).getNotional();
                }
                case -1540322338: {
                    return ((ResolvedIborFuture)bean).getAccrualFactor();
                }
                case -1621804100: {
                    return ((ResolvedIborFuture)bean).getIborRate();
                }
                case -142444: {
                    return ((ResolvedIborFuture)bean).getRounding();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

