/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.index.ResolvedIborFuture;
import com.opengamma.strata.product.option.FutureOptionPremiumStyle;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class ResolvedIborFutureOption
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SecurityId securityId;
    @PropertyDefinition
    private final PutCall putCall;
    @PropertyDefinition
    private final double strikePrice;
    @PropertyDefinition(validate="notNull")
    private final ZonedDateTime expiry;
    @PropertyDefinition(validate="notNull")
    private final FutureOptionPremiumStyle premiumStyle;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    @PropertyDefinition(validate="notNull")
    private final ResolvedIborFuture underlyingFuture;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.rounding(Rounding.none());
    }

    @ImmutableValidator
    private void validate() {
        LocalDate lastTradeDate = this.underlyingFuture.getLastTradeDate();
        ArgChecker.inOrderOrEqual((Comparable)this.expiry.toLocalDate(), (Object)lastTradeDate, (String)"expiry.date", (String)"underlying.lastTradeDate");
        ArgChecker.isTrue((this.strikePrice < 2.0 ? 1 : 0) != 0, (String)"Strike price must be in decimal form, such as 0.993 for a 0.7% rate, but was: {}", (double)this.strikePrice);
    }

    public LocalDate getExpiryDate() {
        return this.expiry.toLocalDate();
    }

    public IborIndex getIndex() {
        return this.underlyingFuture.getIndex();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    ResolvedIborFutureOption(SecurityId securityId, PutCall putCall, double strikePrice, ZonedDateTime expiry, FutureOptionPremiumStyle premiumStyle, Rounding rounding, ResolvedIborFuture underlyingFuture) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)((Object)premiumStyle), (String)"premiumStyle");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        JodaBeanUtils.notNull((Object)underlyingFuture, (String)"underlyingFuture");
        this.securityId = securityId;
        this.putCall = putCall;
        this.strikePrice = strikePrice;
        this.expiry = expiry;
        this.premiumStyle = premiumStyle;
        this.rounding = rounding;
        this.underlyingFuture = underlyingFuture;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public PutCall getPutCall() {
        return this.putCall;
    }

    public double getStrikePrice() {
        return this.strikePrice;
    }

    public ZonedDateTime getExpiry() {
        return this.expiry;
    }

    public FutureOptionPremiumStyle getPremiumStyle() {
        return this.premiumStyle;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public ResolvedIborFuture getUnderlyingFuture() {
        return this.underlyingFuture;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedIborFutureOption other = (ResolvedIborFutureOption)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)((Object)this.putCall), (Object)((Object)other.putCall)) && JodaBeanUtils.equal((double)this.strikePrice, (double)other.strikePrice) && JodaBeanUtils.equal((Object)this.expiry, (Object)other.expiry) && JodaBeanUtils.equal((Object)((Object)this.premiumStyle), (Object)((Object)other.premiumStyle)) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding) && JodaBeanUtils.equal((Object)this.underlyingFuture, (Object)other.underlyingFuture);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.putCall));
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strikePrice);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.premiumStyle));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingFuture);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("ResolvedIborFutureOption{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
        buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("premiumStyle").append('=').append(JodaBeanUtils.toString((Object)((Object)this.premiumStyle))).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
        buf.append("underlyingFuture").append('=').append(JodaBeanUtils.toString((Object)this.underlyingFuture));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedIborFutureOption> {
        private SecurityId securityId;
        private PutCall putCall;
        private double strikePrice;
        private ZonedDateTime expiry;
        private FutureOptionPremiumStyle premiumStyle;
        private Rounding rounding;
        private ResolvedIborFuture underlyingFuture;

        private Builder() {
            ResolvedIborFutureOption.applyDefaults(this);
        }

        private Builder(ResolvedIborFutureOption beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.putCall = beanToCopy.getPutCall();
            this.strikePrice = beanToCopy.getStrikePrice();
            this.expiry = beanToCopy.getExpiry();
            this.premiumStyle = beanToCopy.getPremiumStyle();
            this.rounding = beanToCopy.getRounding();
            this.underlyingFuture = beanToCopy.getUnderlyingFuture();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case -219971059: {
                    return this.putCall;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1257652838: {
                    return this.premiumStyle;
                }
                case -142444: {
                    return this.rounding;
                }
                case -165476480: {
                    return this.underlyingFuture;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case -219971059: {
                    this.putCall = (PutCall)((Object)newValue);
                    break;
                }
                case 50946231: {
                    this.strikePrice = (Double)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (ZonedDateTime)newValue;
                    break;
                }
                case -1257652838: {
                    this.premiumStyle = (FutureOptionPremiumStyle)((Object)newValue);
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                case -165476480: {
                    this.underlyingFuture = (ResolvedIborFuture)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedIborFutureOption build() {
            return new ResolvedIborFutureOption(this.securityId, this.putCall, this.strikePrice, this.expiry, this.premiumStyle, this.rounding, this.underlyingFuture);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder putCall(PutCall putCall) {
            this.putCall = putCall;
            return this;
        }

        public Builder strikePrice(double strikePrice) {
            this.strikePrice = strikePrice;
            return this;
        }

        public Builder expiry(ZonedDateTime expiry) {
            JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
            this.expiry = expiry;
            return this;
        }

        public Builder premiumStyle(FutureOptionPremiumStyle premiumStyle) {
            JodaBeanUtils.notNull((Object)((Object)premiumStyle), (String)"premiumStyle");
            this.premiumStyle = premiumStyle;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public Builder underlyingFuture(ResolvedIborFuture underlyingFuture) {
            JodaBeanUtils.notNull((Object)underlyingFuture, (String)"underlyingFuture");
            this.underlyingFuture = underlyingFuture;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("ResolvedIborFutureOption.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
            buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("premiumStyle").append('=').append(JodaBeanUtils.toString((Object)((Object)this.premiumStyle))).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
            buf.append("underlyingFuture").append('=').append(JodaBeanUtils.toString((Object)this.underlyingFuture));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", ResolvedIborFutureOption.class, SecurityId.class);
        private final MetaProperty<PutCall> putCall = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"putCall", ResolvedIborFutureOption.class, PutCall.class);
        private final MetaProperty<Double> strikePrice = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikePrice", ResolvedIborFutureOption.class, Double.TYPE);
        private final MetaProperty<ZonedDateTime> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", ResolvedIborFutureOption.class, ZonedDateTime.class);
        private final MetaProperty<FutureOptionPremiumStyle> premiumStyle = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"premiumStyle", ResolvedIborFutureOption.class, FutureOptionPremiumStyle.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", ResolvedIborFutureOption.class, Rounding.class);
        private final MetaProperty<ResolvedIborFuture> underlyingFuture = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingFuture", ResolvedIborFutureOption.class, ResolvedIborFuture.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "putCall", "strikePrice", "expiry", "premiumStyle", "rounding", "underlyingFuture"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case -219971059: {
                    return this.putCall;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1257652838: {
                    return this.premiumStyle;
                }
                case -142444: {
                    return this.rounding;
                }
                case -165476480: {
                    return this.underlyingFuture;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedIborFutureOption> beanType() {
            return ResolvedIborFutureOption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<PutCall> putCall() {
            return this.putCall;
        }

        public MetaProperty<Double> strikePrice() {
            return this.strikePrice;
        }

        public MetaProperty<ZonedDateTime> expiry() {
            return this.expiry;
        }

        public MetaProperty<FutureOptionPremiumStyle> premiumStyle() {
            return this.premiumStyle;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        public MetaProperty<ResolvedIborFuture> underlyingFuture() {
            return this.underlyingFuture;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((ResolvedIborFutureOption)bean).getSecurityId();
                }
                case -219971059: {
                    return ((ResolvedIborFutureOption)bean).getPutCall();
                }
                case 50946231: {
                    return ((ResolvedIborFutureOption)bean).getStrikePrice();
                }
                case -1289159373: {
                    return ((ResolvedIborFutureOption)bean).getExpiry();
                }
                case -1257652838: {
                    return ((ResolvedIborFutureOption)bean).getPremiumStyle();
                }
                case -142444: {
                    return ((ResolvedIborFutureOption)bean).getRounding();
                }
                case -165476480: {
                    return ((ResolvedIborFutureOption)bean).getUnderlyingFuture();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

