/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.rate.OvernightRateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class ResolvedOvernightFuture
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SecurityId securityId;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double accrualFactor;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastTradeDate;
    @PropertyDefinition(validate="notNull")
    private final OvernightRateComputation overnightRate;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.rounding(Rounding.none());
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.overnightRate != null && builder.currency == null) {
            builder.currency = builder.overnightRate.getIndex().getCurrency();
        }
    }

    public OvernightIndex getIndex() {
        return this.overnightRate.getIndex();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    ResolvedOvernightFuture(SecurityId securityId, Currency currency, double notional, double accrualFactor, LocalDate lastTradeDate, OvernightRateComputation overnightRate, Rounding rounding) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        ArgChecker.notNegativeOrZero((double)accrualFactor, (String)"accrualFactor");
        JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
        JodaBeanUtils.notNull((Object)overnightRate, (String)"overnightRate");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        this.securityId = securityId;
        this.currency = currency;
        this.notional = notional;
        this.accrualFactor = accrualFactor;
        this.lastTradeDate = lastTradeDate;
        this.overnightRate = overnightRate;
        this.rounding = rounding;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public double getAccrualFactor() {
        return this.accrualFactor;
    }

    public LocalDate getLastTradeDate() {
        return this.lastTradeDate;
    }

    public OvernightRateComputation getOvernightRate() {
        return this.overnightRate;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedOvernightFuture other = (ResolvedOvernightFuture)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((double)this.accrualFactor, (double)other.accrualFactor) && JodaBeanUtils.equal((Object)this.lastTradeDate, (Object)other.lastTradeDate) && JodaBeanUtils.equal((Object)this.overnightRate, (Object)other.overnightRate) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.accrualFactor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.overnightRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("ResolvedOvernightFuture{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor)).append(',').append(' ');
        buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
        buf.append("overnightRate").append('=').append(JodaBeanUtils.toString((Object)this.overnightRate)).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedOvernightFuture> {
        private SecurityId securityId;
        private Currency currency;
        private double notional;
        private double accrualFactor;
        private LocalDate lastTradeDate;
        private OvernightRateComputation overnightRate;
        private Rounding rounding;

        private Builder() {
            ResolvedOvernightFuture.applyDefaults(this);
        }

        private Builder(ResolvedOvernightFuture beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.accrualFactor = beanToCopy.getAccrualFactor();
            this.lastTradeDate = beanToCopy.getLastTradeDate();
            this.overnightRate = beanToCopy.getOvernightRate();
            this.rounding = beanToCopy.getRounding();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case -821605692: {
                    return this.overnightRate;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1540322338: {
                    this.accrualFactor = (Double)newValue;
                    break;
                }
                case -1041950404: {
                    this.lastTradeDate = (LocalDate)newValue;
                    break;
                }
                case -821605692: {
                    this.overnightRate = (OvernightRateComputation)newValue;
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedOvernightFuture build() {
            ResolvedOvernightFuture.preBuild(this);
            return new ResolvedOvernightFuture(this.securityId, this.currency, this.notional, this.accrualFactor, this.lastTradeDate, this.overnightRate, this.rounding);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder accrualFactor(double accrualFactor) {
            ArgChecker.notNegativeOrZero((double)accrualFactor, (String)"accrualFactor");
            this.accrualFactor = accrualFactor;
            return this;
        }

        public Builder lastTradeDate(LocalDate lastTradeDate) {
            JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        public Builder overnightRate(OvernightRateComputation overnightRate) {
            JodaBeanUtils.notNull((Object)overnightRate, (String)"overnightRate");
            this.overnightRate = overnightRate;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("ResolvedOvernightFuture.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor)).append(',').append(' ');
            buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
            buf.append("overnightRate").append('=').append(JodaBeanUtils.toString((Object)this.overnightRate)).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", ResolvedOvernightFuture.class, SecurityId.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ResolvedOvernightFuture.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", ResolvedOvernightFuture.class, Double.TYPE);
        private final MetaProperty<Double> accrualFactor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualFactor", ResolvedOvernightFuture.class, Double.TYPE);
        private final MetaProperty<LocalDate> lastTradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastTradeDate", ResolvedOvernightFuture.class, LocalDate.class);
        private final MetaProperty<OvernightRateComputation> overnightRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"overnightRate", ResolvedOvernightFuture.class, OvernightRateComputation.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", ResolvedOvernightFuture.class, Rounding.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "currency", "notional", "accrualFactor", "lastTradeDate", "overnightRate", "rounding"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case -821605692: {
                    return this.overnightRate;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedOvernightFuture> beanType() {
            return ResolvedOvernightFuture.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<Double> accrualFactor() {
            return this.accrualFactor;
        }

        public MetaProperty<LocalDate> lastTradeDate() {
            return this.lastTradeDate;
        }

        public MetaProperty<OvernightRateComputation> overnightRate() {
            return this.overnightRate;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((ResolvedOvernightFuture)bean).getSecurityId();
                }
                case 575402001: {
                    return ((ResolvedOvernightFuture)bean).getCurrency();
                }
                case 1585636160: {
                    return ((ResolvedOvernightFuture)bean).getNotional();
                }
                case -1540322338: {
                    return ((ResolvedOvernightFuture)bean).getAccrualFactor();
                }
                case -1041950404: {
                    return ((ResolvedOvernightFuture)bean).getLastTradeDate();
                }
                case -821605692: {
                    return ((ResolvedOvernightFuture)bean).getOvernightRate();
                }
                case -142444: {
                    return ((ResolvedOvernightFuture)bean).getRounding();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

