/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.SequenceDate;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.index.IborFuturePosition;
import com.opengamma.strata.product.index.IborFutureTrade;
import com.opengamma.strata.product.index.type.IborFutureContractSpecs;
import java.time.LocalDate;
import java.time.YearMonth;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface IborFutureContractSpec
extends Named {
    @FromString
    public static IborFutureContractSpec of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (IborFutureContractSpec)IborFutureContractSpec.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<IborFutureContractSpec> extendedEnum() {
        return IborFutureContractSpecs.ENUM_LOOKUP;
    }

    public IborIndex getIndex();

    public double getNotional();

    public IborFutureTrade createTrade(LocalDate var1, SecurityId var2, SequenceDate var3, double var4, double var6, ReferenceData var8);

    public IborFuturePosition createPosition(SecurityId var1, YearMonth var2, double var3, ReferenceData var5);

    public LocalDate calculateReferenceDate(LocalDate var1, SequenceDate var2, ReferenceData var3);

    @ToString
    public String getName();
}

