/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.SequenceDate;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.TradeTemplate;
import com.opengamma.strata.product.index.IborFutureTrade;
import com.opengamma.strata.product.index.type.IborFutureContractSpec;
import com.opengamma.strata.product.index.type.IborFutureConvention;
import com.opengamma.strata.product.index.type.ImmutableIborFutureContractSpec;
import com.opengamma.strata.product.index.type.ImmutableIborFutureConvention;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.Period;
import java.time.YearMonth;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class IborFutureTemplate
implements TradeTemplate,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SequenceDate sequenceDate;
    @PropertyDefinition(validate="notNull")
    private final IborFutureContractSpec contractSpec;
    private static final TypedMetaBean<IborFutureTemplate> META_BEAN = LightMetaBean.of(IborFutureTemplate.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"sequenceDate", "contractSpec"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static IborFutureTemplate of(SequenceDate sequenceDate, IborFutureContractSpec contractSpec) {
        return new IborFutureTemplate(sequenceDate, contractSpec);
    }

    @Deprecated
    public static IborFutureTemplate of(Period minimumPeriod, int sequenceNumber, IborFutureConvention convention) {
        IborFutureContractSpec contractSpec = IborFutureContractSpec.of(convention.getName());
        return IborFutureTemplate.of(SequenceDate.base((Period)minimumPeriod, (int)sequenceNumber), contractSpec);
    }

    @Deprecated
    public static IborFutureTemplate of(YearMonth yearMonth, IborFutureConvention convention) {
        IborFutureContractSpec contractSpec = IborFutureContractSpec.of(convention.getName());
        return IborFutureTemplate.of(SequenceDate.base((YearMonth)yearMonth), contractSpec);
    }

    public IborIndex getIndex() {
        return this.contractSpec.getIndex();
    }

    @Deprecated
    public IborFutureConvention getConvention() {
        ImmutableIborFutureContractSpec spec = (ImmutableIborFutureContractSpec)this.getContractSpec();
        return ImmutableIborFutureConvention.builder().name(spec.getName()).index(spec.getIndex()).dateSequence(spec.getDateSequence()).businessDayAdjustment(spec.getBusinessDayAdjustment()).build();
    }

    public IborFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, double quantity, double price, ReferenceData refData) {
        return this.contractSpec.createTrade(tradeDate, securityId, this.sequenceDate, quantity, price, refData);
    }

    @Deprecated
    public IborFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, double quantity, double notional, double price, ReferenceData refData) {
        return this.createTrade(tradeDate, securityId, quantity, price, refData);
    }

    public LocalDate calculateReferenceDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.contractSpec.calculateReferenceDate(tradeDate, this.sequenceDate, refData);
    }

    public static TypedMetaBean<IborFutureTemplate> meta() {
        return META_BEAN;
    }

    private IborFutureTemplate(SequenceDate sequenceDate, IborFutureContractSpec contractSpec) {
        JodaBeanUtils.notNull((Object)sequenceDate, (String)"sequenceDate");
        JodaBeanUtils.notNull((Object)contractSpec, (String)"contractSpec");
        this.sequenceDate = sequenceDate;
        this.contractSpec = contractSpec;
    }

    public TypedMetaBean<IborFutureTemplate> metaBean() {
        return META_BEAN;
    }

    public SequenceDate getSequenceDate() {
        return this.sequenceDate;
    }

    public IborFutureContractSpec getContractSpec() {
        return this.contractSpec;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborFutureTemplate other = (IborFutureTemplate)obj;
            return JodaBeanUtils.equal((Object)this.sequenceDate, (Object)other.sequenceDate) && JodaBeanUtils.equal((Object)this.contractSpec, (Object)other.contractSpec);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sequenceDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.contractSpec);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("IborFutureTemplate{");
        buf.append("sequenceDate").append('=').append(JodaBeanUtils.toString((Object)this.sequenceDate)).append(',').append(' ');
        buf.append("contractSpec").append('=').append(JodaBeanUtils.toString((Object)this.contractSpec));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

