/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DateSequence;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.SequenceDate;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.index.IborFuture;
import com.opengamma.strata.product.index.IborFuturePosition;
import com.opengamma.strata.product.index.IborFutureTrade;
import com.opengamma.strata.product.index.type.IborFutureContractSpec;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;

@BeanDefinition(style="minimal")
public final class ImmutableIborFutureContractSpec
implements IborFutureContractSpec,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notBlank", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull")
    private final DateSequence dateSequence;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero", overrideGet=true)
    private final double notional;
    private static final TypedMetaBean<ImmutableIborFutureContractSpec> META_BEAN = MinimalMetaBean.of(ImmutableIborFutureContractSpec.class, (String[])new String[]{"name", "index", "dateSequence", "businessDayAdjustment", "notional"}, () -> new Builder(), (Function[])new Function[]{b -> b.getName(), b -> b.getIndex(), b -> b.getDateSequence(), b -> b.getBusinessDayAdjustment(), b -> b.getNotional()});
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null && builder.businessDayAdjustment == null) {
            builder.businessDayAdjustment = BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)builder.index.getEffectiveDateOffset().getCalendar());
        }
    }

    @Override
    public IborFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, SequenceDate sequenceDate, double quantity, double price, ReferenceData refData) {
        LocalDate referenceDate = this.calculateReferenceDate(tradeDate, sequenceDate, refData);
        LocalDate lastTradeDate = this.index.calculateFixingFromEffective(referenceDate, refData);
        return this.createTrade(tradeDate, securityId, quantity, price, lastTradeDate);
    }

    private IborFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, double quantity, double price, LocalDate lastTradeDate) {
        double accrualFactor = (double)this.index.getTenor().get((TemporalUnit)ChronoUnit.MONTHS) / 12.0;
        IborFuture product = IborFuture.builder().securityId(securityId).index(this.index).accrualFactor(accrualFactor).lastTradeDate(lastTradeDate).notional(this.notional).build();
        TradeInfo info = TradeInfo.of(tradeDate);
        return IborFutureTrade.builder().info(info).product(product).quantity(quantity).price(price).build();
    }

    @Override
    public LocalDate calculateReferenceDate(LocalDate tradeDate, SequenceDate sequenceDate, ReferenceData refData) {
        LocalDate referenceDate = this.dateSequence.selectDate(tradeDate, sequenceDate);
        return this.businessDayAdjustment.adjust(referenceDate, refData);
    }

    @Override
    public IborFuturePosition createPosition(SecurityId securityId, YearMonth expiry, double quantity, ReferenceData refData) {
        LocalDate effectiveDate = this.dateSequence.dateMatching(expiry);
        LocalDate lastTradeDate = this.index.calculateFixingFromEffective(effectiveDate, refData);
        return this.createPosition(securityId, quantity, lastTradeDate);
    }

    private IborFuturePosition createPosition(SecurityId securityId, double quantity, LocalDate lastTradeDate) {
        double accrualFactor = (double)this.index.getTenor().get((TemporalUnit)ChronoUnit.MONTHS) / 12.0;
        IborFuture product = IborFuture.builder().securityId(securityId).index(this.index).accrualFactor(accrualFactor).lastTradeDate(lastTradeDate).notional(this.notional).build();
        return IborFuturePosition.ofNet(PositionInfo.empty(), product, quantity);
    }

    public String toString() {
        return this.name;
    }

    public static TypedMetaBean<ImmutableIborFutureContractSpec> meta() {
        return META_BEAN;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableIborFutureContractSpec(String name, IborIndex index, DateSequence dateSequence, BusinessDayAdjustment businessDayAdjustment, double notional) {
        JodaBeanUtils.notBlank((String)name, (String)"name");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)dateSequence, (String)"dateSequence");
        JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        this.name = name;
        this.index = index;
        this.dateSequence = dateSequence;
        this.businessDayAdjustment = businessDayAdjustment;
        this.notional = notional;
    }

    public TypedMetaBean<ImmutableIborFutureContractSpec> metaBean() {
        return META_BEAN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    public DateSequence getDateSequence() {
        return this.dateSequence;
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment;
    }

    @Override
    public double getNotional() {
        return this.notional;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableIborFutureContractSpec other = (ImmutableIborFutureContractSpec)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.dateSequence, (Object)other.dateSequence) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((double)this.notional, (double)other.notional);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateSequence);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableIborFutureContractSpec> {
        private String name;
        private IborIndex index;
        private DateSequence dateSequence;
        private BusinessDayAdjustment businessDayAdjustment;
        private double notional;

        private Builder() {
        }

        private Builder(ImmutableIborFutureContractSpec beanToCopy) {
            this.name = beanToCopy.getName();
            this.index = beanToCopy.getIndex();
            this.dateSequence = beanToCopy.getDateSequence();
            this.businessDayAdjustment = beanToCopy.getBusinessDayAdjustment();
            this.notional = beanToCopy.getNotional();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case -258065009: {
                    return this.dateSequence;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 1585636160: {
                    return this.notional;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -258065009: {
                    this.dateSequence = (DateSequence)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableIborFutureContractSpec build() {
            ImmutableIborFutureContractSpec.preBuild(this);
            return new ImmutableIborFutureContractSpec(this.name, this.index, this.dateSequence, this.businessDayAdjustment, this.notional);
        }

        public Builder name(String name) {
            JodaBeanUtils.notBlank((String)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder dateSequence(DateSequence dateSequence) {
            JodaBeanUtils.notNull((Object)dateSequence, (String)"dateSequence");
            this.dateSequence = dateSequence;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ImmutableIborFutureContractSpec.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("dateSequence").append('=').append(JodaBeanUtils.toString((Object)this.dateSequence)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional));
            buf.append('}');
            return buf.toString();
        }
    }
}

