/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DateSequence;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.index.IborFuture;
import com.opengamma.strata.product.index.IborFutureTrade;
import com.opengamma.strata.product.index.type.IborFutureConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@Deprecated
@BeanDefinition
public final class ImmutableIborFutureConvention
implements IborFutureConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull")
    private final DateSequence dateSequence;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment businessDayAdjustment;
    private static final long serialVersionUID = 1L;

    public static ImmutableIborFutureConvention of(IborIndex index, DateSequence dateSequence) {
        return ImmutableIborFutureConvention.builder().index(index).dateSequence(dateSequence).build();
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null) {
            if (builder.name == null && builder.dateSequence != null) {
                builder.name = builder.index.getName() + "-" + builder.dateSequence.getName();
            }
            if (builder.businessDayAdjustment == null) {
                builder.businessDayAdjustment = BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)builder.index.getEffectiveDateOffset().getCalendar());
            }
        }
    }

    @Override
    public IborFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, Period minimumPeriod, int sequenceNumber, double quantity, double notional, double price, ReferenceData refData) {
        LocalDate referenceDate = this.calculateReferenceDateFromTradeDate(tradeDate, minimumPeriod, sequenceNumber, refData);
        LocalDate lastTradeDate = this.index.calculateFixingFromEffective(referenceDate, refData);
        YearMonth yearMonth = YearMonth.from(lastTradeDate);
        return this.createTrade(tradeDate, securityId, quantity, notional, price, yearMonth, lastTradeDate, referenceDate);
    }

    @Override
    public IborFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, YearMonth yearMonth, double quantity, double notional, double price, ReferenceData refData) {
        LocalDate referenceDate = this.calculateReferenceDateFromTradeDate(tradeDate, yearMonth, refData);
        LocalDate lastTradeDate = this.index.calculateFixingFromEffective(referenceDate, refData);
        return this.createTrade(tradeDate, securityId, quantity, notional, price, yearMonth, lastTradeDate, referenceDate);
    }

    private IborFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, double quantity, double notional, double price, YearMonth yearMonth, LocalDate lastTradeDate, LocalDate referenceDate) {
        double accrualFactor = (double)this.index.getTenor().get((TemporalUnit)ChronoUnit.MONTHS) / 12.0;
        IborFuture product = IborFuture.builder().securityId(securityId).index(this.index).accrualFactor(accrualFactor).lastTradeDate(lastTradeDate).notional(notional).build();
        TradeInfo info = TradeInfo.of(tradeDate);
        return IborFutureTrade.builder().info(info).product(product).quantity(quantity).price(price).build();
    }

    @Override
    public LocalDate calculateReferenceDateFromTradeDate(LocalDate tradeDate, Period minimumPeriod, int sequenceNumber, ReferenceData refData) {
        LocalDate earliestDate = tradeDate.plus(minimumPeriod);
        LocalDate referenceDate = this.dateSequence.nthOrSame(earliestDate, sequenceNumber);
        return this.businessDayAdjustment.adjust(referenceDate, refData);
    }

    @Override
    public LocalDate calculateReferenceDateFromTradeDate(LocalDate tradeDate, YearMonth yearMonth, ReferenceData refData) {
        LocalDate referenceDate = this.dateSequence.dateMatching(yearMonth);
        return this.businessDayAdjustment.adjust(referenceDate, refData);
    }

    public String toString() {
        return this.name;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableIborFutureConvention(IborIndex index, String name, DateSequence dateSequence, BusinessDayAdjustment businessDayAdjustment) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)dateSequence, (String)"dateSequence");
        JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        this.index = index;
        this.name = name;
        this.dateSequence = dateSequence;
        this.businessDayAdjustment = businessDayAdjustment;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DateSequence getDateSequence() {
        return this.dateSequence;
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableIborFutureConvention other = (ImmutableIborFutureConvention)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.dateSequence, (Object)other.dateSequence) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateSequence);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableIborFutureConvention> {
        private IborIndex index;
        private String name;
        private DateSequence dateSequence;
        private BusinessDayAdjustment businessDayAdjustment;

        private Builder() {
        }

        private Builder(ImmutableIborFutureConvention beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.name = beanToCopy.getName();
            this.dateSequence = beanToCopy.getDateSequence();
            this.businessDayAdjustment = beanToCopy.getBusinessDayAdjustment();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 3373707: {
                    return this.name;
                }
                case -258065009: {
                    return this.dateSequence;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case -258065009: {
                    this.dateSequence = (DateSequence)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableIborFutureConvention build() {
            ImmutableIborFutureConvention.preBuild(this);
            return new ImmutableIborFutureConvention(this.index, this.name, this.dateSequence, this.businessDayAdjustment);
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder dateSequence(DateSequence dateSequence) {
            JodaBeanUtils.notNull((Object)dateSequence, (String)"dateSequence");
            this.dateSequence = dateSequence;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableIborFutureConvention.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("dateSequence").append('=').append(JodaBeanUtils.toString((Object)this.dateSequence)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", ImmutableIborFutureConvention.class, IborIndex.class);
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableIborFutureConvention.class, String.class);
        private final MetaProperty<DateSequence> dateSequence = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dateSequence", ImmutableIborFutureConvention.class, DateSequence.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", ImmutableIborFutureConvention.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "name", "dateSequence", "businessDayAdjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 3373707: {
                    return this.name;
                }
                case -258065009: {
                    return this.dateSequence;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableIborFutureConvention> beanType() {
            return ImmutableIborFutureConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<DateSequence> dateSequence() {
            return this.dateSequence;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((ImmutableIborFutureConvention)bean).getIndex();
                }
                case 3373707: {
                    return ((ImmutableIborFutureConvention)bean).getName();
                }
                case -258065009: {
                    return ((ImmutableIborFutureConvention)bean).getDateSequence();
                }
                case -1065319863: {
                    return ((ImmutableIborFutureConvention)bean).getBusinessDayAdjustment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

