/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DateSequence;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.SequenceDate;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.index.OvernightFuture;
import com.opengamma.strata.product.index.OvernightFuturePosition;
import com.opengamma.strata.product.index.OvernightFutureTrade;
import com.opengamma.strata.product.index.type.OvernightFutureContractSpec;
import com.opengamma.strata.product.swap.OvernightAccrualMethod;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;

@BeanDefinition(style="minimal")
public final class ImmutableOvernightFutureContractSpec
implements OvernightFutureContractSpec,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notBlank", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final OvernightIndex index;
    @PropertyDefinition(validate="notNull")
    private final DateSequence dateSequence;
    @PropertyDefinition(validate="notNull")
    private final OvernightAccrualMethod accrualMethod;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment startDateAdjustment;
    @PropertyDefinition
    private final DaysAdjustment endDateAdjustment;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment lastTradeDateAdjustment;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero", overrideGet=true)
    private final double notional;
    private static final TypedMetaBean<ImmutableOvernightFutureContractSpec> META_BEAN = MinimalMetaBean.of(ImmutableOvernightFutureContractSpec.class, (String[])new String[]{"name", "index", "dateSequence", "accrualMethod", "startDateAdjustment", "endDateAdjustment", "lastTradeDateAdjustment", "notional"}, () -> new Builder(), (Function[])new Function[]{b -> b.getName(), b -> b.getIndex(), b -> b.getDateSequence(), b -> b.getAccrualMethod(), b -> b.getStartDateAdjustment(), b -> b.getEndDateAdjustment(), b -> b.getLastTradeDateAdjustment(), b -> b.getNotional()});
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null && builder.lastTradeDateAdjustment == null) {
            BusinessDayAdjustment bda = BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.PRECEDING, (HolidayCalendarId)builder.index.getFixingCalendar());
            builder.lastTradeDateAdjustment = DaysAdjustment.ofCalendarDays((int)-1, (BusinessDayAdjustment)bda);
        }
        if (builder.startDateAdjustment == null) {
            builder.startDateAdjustment = BusinessDayAdjustment.NONE;
        }
        if (builder.endDateAdjustment == null) {
            builder.endDateAdjustment = DaysAdjustment.ofCalendarDays((int)-1);
        }
    }

    @Override
    public OvernightFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, SequenceDate sequenceDate, double quantity, double price, ReferenceData refData) {
        LocalDate startDate = this.calculateReferenceDate(tradeDate, sequenceDate, refData);
        return this.createTrade(tradeDate, securityId, quantity, price, startDate, refData);
    }

    private OvernightFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, double quantity, double price, LocalDate startDate, ReferenceData refData) {
        LocalDate nextReferenceDate = this.dateSequence.baseSequence().next(startDate);
        double accrualFactor = (double)startDate.withDayOfMonth(1).until(nextReferenceDate.withDayOfMonth(1), ChronoUnit.MONTHS) / 12.0;
        LocalDate endDate = this.endDateAdjustment.adjust(nextReferenceDate, refData);
        LocalDate lastTradeDate = this.lastTradeDateAdjustment.adjust(nextReferenceDate, refData);
        OvernightFuture product = OvernightFuture.builder().securityId(securityId).index(this.index).accrualMethod(this.accrualMethod).accrualFactor(accrualFactor).startDate(startDate).endDate(endDate).lastTradeDate(lastTradeDate).notional(this.notional).build();
        TradeInfo info = TradeInfo.of(tradeDate);
        return OvernightFutureTrade.builder().info(info).product(product).quantity(quantity).price(price).build();
    }

    @Override
    public OvernightFuturePosition createPosition(SecurityId securityId, YearMonth expiry, double quantity, ReferenceData refData) {
        LocalDate startDate = this.dateSequence.dateMatching(expiry);
        return this.createPosition(securityId, quantity, startDate, refData);
    }

    private OvernightFuturePosition createPosition(SecurityId securityId, double quantity, LocalDate startDate, ReferenceData refData) {
        LocalDate nextReferenceDate = this.dateSequence.baseSequence().next(startDate);
        double accrualFactor = (double)startDate.withDayOfMonth(1).until(nextReferenceDate.withDayOfMonth(1), ChronoUnit.MONTHS) / 12.0;
        LocalDate endDate = this.endDateAdjustment.adjust(nextReferenceDate, refData);
        LocalDate lastTradeDate = this.lastTradeDateAdjustment.adjust(nextReferenceDate, refData);
        OvernightFuture product = OvernightFuture.builder().securityId(securityId).index(this.index).accrualMethod(this.accrualMethod).accrualFactor(accrualFactor).startDate(startDate).endDate(endDate).lastTradeDate(lastTradeDate).notional(this.notional).build();
        return OvernightFuturePosition.ofNet(PositionInfo.empty(), product, quantity);
    }

    @Override
    public LocalDate calculateReferenceDate(LocalDate tradeDate, SequenceDate sequenceDate, ReferenceData refData) {
        LocalDate referenceDate = this.dateSequence.selectDate(tradeDate, sequenceDate);
        return this.startDateAdjustment.adjust(referenceDate, refData);
    }

    @Override
    public LocalDate calculateLastFixingDate(LocalDate referenceDate, ReferenceData refData) {
        LocalDate nextReferenceDate = this.dateSequence.baseSequence().next(referenceDate);
        return this.endDateAdjustment.adjust(nextReferenceDate, refData);
    }

    public String toString() {
        return this.name;
    }

    public static TypedMetaBean<ImmutableOvernightFutureContractSpec> meta() {
        return META_BEAN;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableOvernightFutureContractSpec(String name, OvernightIndex index, DateSequence dateSequence, OvernightAccrualMethod accrualMethod, BusinessDayAdjustment startDateAdjustment, DaysAdjustment endDateAdjustment, DaysAdjustment lastTradeDateAdjustment, double notional) {
        JodaBeanUtils.notBlank((String)name, (String)"name");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)dateSequence, (String)"dateSequence");
        JodaBeanUtils.notNull((Object)((Object)accrualMethod), (String)"accrualMethod");
        JodaBeanUtils.notNull((Object)startDateAdjustment, (String)"startDateAdjustment");
        JodaBeanUtils.notNull((Object)lastTradeDateAdjustment, (String)"lastTradeDateAdjustment");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        this.name = name;
        this.index = index;
        this.dateSequence = dateSequence;
        this.accrualMethod = accrualMethod;
        this.startDateAdjustment = startDateAdjustment;
        this.endDateAdjustment = endDateAdjustment;
        this.lastTradeDateAdjustment = lastTradeDateAdjustment;
        this.notional = notional;
    }

    public TypedMetaBean<ImmutableOvernightFutureContractSpec> metaBean() {
        return META_BEAN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OvernightIndex getIndex() {
        return this.index;
    }

    public DateSequence getDateSequence() {
        return this.dateSequence;
    }

    public OvernightAccrualMethod getAccrualMethod() {
        return this.accrualMethod;
    }

    public BusinessDayAdjustment getStartDateAdjustment() {
        return this.startDateAdjustment;
    }

    public DaysAdjustment getEndDateAdjustment() {
        return this.endDateAdjustment;
    }

    public DaysAdjustment getLastTradeDateAdjustment() {
        return this.lastTradeDateAdjustment;
    }

    @Override
    public double getNotional() {
        return this.notional;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableOvernightFutureContractSpec other = (ImmutableOvernightFutureContractSpec)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.dateSequence, (Object)other.dateSequence) && JodaBeanUtils.equal((Object)((Object)this.accrualMethod), (Object)((Object)other.accrualMethod)) && JodaBeanUtils.equal((Object)this.startDateAdjustment, (Object)other.startDateAdjustment) && JodaBeanUtils.equal((Object)this.endDateAdjustment, (Object)other.endDateAdjustment) && JodaBeanUtils.equal((Object)this.lastTradeDateAdjustment, (Object)other.lastTradeDateAdjustment) && JodaBeanUtils.equal((double)this.notional, (double)other.notional);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateSequence);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.accrualMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDateAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDateAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDateAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableOvernightFutureContractSpec> {
        private String name;
        private OvernightIndex index;
        private DateSequence dateSequence;
        private OvernightAccrualMethod accrualMethod;
        private BusinessDayAdjustment startDateAdjustment;
        private DaysAdjustment endDateAdjustment;
        private DaysAdjustment lastTradeDateAdjustment;
        private double notional;

        private Builder() {
        }

        private Builder(ImmutableOvernightFutureContractSpec beanToCopy) {
            this.name = beanToCopy.getName();
            this.index = beanToCopy.getIndex();
            this.dateSequence = beanToCopy.getDateSequence();
            this.accrualMethod = beanToCopy.getAccrualMethod();
            this.startDateAdjustment = beanToCopy.getStartDateAdjustment();
            this.endDateAdjustment = beanToCopy.getEndDateAdjustment();
            this.lastTradeDateAdjustment = beanToCopy.getLastTradeDateAdjustment();
            this.notional = beanToCopy.getNotional();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case -258065009: {
                    return this.dateSequence;
                }
                case -1335729296: {
                    return this.accrualMethod;
                }
                case -1235962691: {
                    return this.startDateAdjustment;
                }
                case 1599713654: {
                    return this.endDateAdjustment;
                }
                case -1889695799: {
                    return this.lastTradeDateAdjustment;
                }
                case 1585636160: {
                    return this.notional;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (OvernightIndex)newValue;
                    break;
                }
                case -258065009: {
                    this.dateSequence = (DateSequence)newValue;
                    break;
                }
                case -1335729296: {
                    this.accrualMethod = (OvernightAccrualMethod)((Object)newValue);
                    break;
                }
                case -1235962691: {
                    this.startDateAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 1599713654: {
                    this.endDateAdjustment = (DaysAdjustment)newValue;
                    break;
                }
                case -1889695799: {
                    this.lastTradeDateAdjustment = (DaysAdjustment)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableOvernightFutureContractSpec build() {
            ImmutableOvernightFutureContractSpec.preBuild(this);
            return new ImmutableOvernightFutureContractSpec(this.name, this.index, this.dateSequence, this.accrualMethod, this.startDateAdjustment, this.endDateAdjustment, this.lastTradeDateAdjustment, this.notional);
        }

        public Builder name(String name) {
            JodaBeanUtils.notBlank((String)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder index(OvernightIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder dateSequence(DateSequence dateSequence) {
            JodaBeanUtils.notNull((Object)dateSequence, (String)"dateSequence");
            this.dateSequence = dateSequence;
            return this;
        }

        public Builder accrualMethod(OvernightAccrualMethod accrualMethod) {
            JodaBeanUtils.notNull((Object)((Object)accrualMethod), (String)"accrualMethod");
            this.accrualMethod = accrualMethod;
            return this;
        }

        public Builder startDateAdjustment(BusinessDayAdjustment startDateAdjustment) {
            JodaBeanUtils.notNull((Object)startDateAdjustment, (String)"startDateAdjustment");
            this.startDateAdjustment = startDateAdjustment;
            return this;
        }

        public Builder endDateAdjustment(DaysAdjustment endDateAdjustment) {
            this.endDateAdjustment = endDateAdjustment;
            return this;
        }

        public Builder lastTradeDateAdjustment(DaysAdjustment lastTradeDateAdjustment) {
            JodaBeanUtils.notNull((Object)lastTradeDateAdjustment, (String)"lastTradeDateAdjustment");
            this.lastTradeDateAdjustment = lastTradeDateAdjustment;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("ImmutableOvernightFutureContractSpec.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("dateSequence").append('=').append(JodaBeanUtils.toString((Object)this.dateSequence)).append(',').append(' ');
            buf.append("accrualMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualMethod))).append(',').append(' ');
            buf.append("startDateAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.startDateAdjustment)).append(',').append(' ');
            buf.append("endDateAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.endDateAdjustment)).append(',').append(' ');
            buf.append("lastTradeDateAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDateAdjustment)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional));
            buf.append('}');
            return buf.toString();
        }
    }
}

