/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.SequenceDate;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.index.OvernightFuturePosition;
import com.opengamma.strata.product.index.OvernightFutureTrade;
import com.opengamma.strata.product.index.type.OvernightFutureContractSpecs;
import java.time.LocalDate;
import java.time.YearMonth;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface OvernightFutureContractSpec
extends Named {
    @FromString
    public static OvernightFutureContractSpec of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (OvernightFutureContractSpec)OvernightFutureContractSpec.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<OvernightFutureContractSpec> extendedEnum() {
        return OvernightFutureContractSpecs.ENUM_LOOKUP;
    }

    public OvernightIndex getIndex();

    public double getNotional();

    public OvernightFutureTrade createTrade(LocalDate var1, SecurityId var2, SequenceDate var3, double var4, double var6, ReferenceData var8);

    public OvernightFuturePosition createPosition(SecurityId var1, YearMonth var2, double var3, ReferenceData var5);

    public LocalDate calculateReferenceDate(LocalDate var1, SequenceDate var2, ReferenceData var3);

    public LocalDate calculateLastFixingDate(LocalDate var1, ReferenceData var2);

    @ToString
    public String getName();
}

