/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.SequenceDate;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.TradeTemplate;
import com.opengamma.strata.product.index.OvernightFutureTrade;
import com.opengamma.strata.product.index.type.OvernightFutureContractSpec;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class OvernightFutureTemplate
implements TradeTemplate,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SequenceDate sequenceDate;
    @PropertyDefinition(validate="notNull")
    private final OvernightFutureContractSpec contractSpec;
    private static final TypedMetaBean<OvernightFutureTemplate> META_BEAN = LightMetaBean.of(OvernightFutureTemplate.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"sequenceDate", "contractSpec"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static OvernightFutureTemplate of(SequenceDate sequenceDate, OvernightFutureContractSpec contractSpec) {
        return new OvernightFutureTemplate(sequenceDate, contractSpec);
    }

    public OvernightIndex getIndex() {
        return this.contractSpec.getIndex();
    }

    public OvernightFutureTrade createTrade(LocalDate tradeDate, SecurityId securityId, double quantity, double price, ReferenceData refData) {
        return this.contractSpec.createTrade(tradeDate, securityId, this.sequenceDate, quantity, price, refData);
    }

    public LocalDate calculateReferenceDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.contractSpec.calculateReferenceDate(tradeDate, this.sequenceDate, refData);
    }

    public LocalDate calculateLastFixingDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        LocalDate referenceDate = this.calculateReferenceDateFromTradeDate(tradeDate, refData);
        return this.contractSpec.calculateLastFixingDate(referenceDate, refData);
    }

    public static TypedMetaBean<OvernightFutureTemplate> meta() {
        return META_BEAN;
    }

    private OvernightFutureTemplate(SequenceDate sequenceDate, OvernightFutureContractSpec contractSpec) {
        JodaBeanUtils.notNull((Object)sequenceDate, (String)"sequenceDate");
        JodaBeanUtils.notNull((Object)contractSpec, (String)"contractSpec");
        this.sequenceDate = sequenceDate;
        this.contractSpec = contractSpec;
    }

    public TypedMetaBean<OvernightFutureTemplate> metaBean() {
        return META_BEAN;
    }

    public SequenceDate getSequenceDate() {
        return this.sequenceDate;
    }

    public OvernightFutureContractSpec getContractSpec() {
        return this.contractSpec;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightFutureTemplate other = (OvernightFutureTemplate)obj;
            return JodaBeanUtils.equal((Object)this.sequenceDate, (Object)other.sequenceDate) && JodaBeanUtils.equal((Object)this.contractSpec, (Object)other.contractSpec);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sequenceDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.contractSpec);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("OvernightFutureTemplate{");
        buf.append("sequenceDate").append('=').append(JodaBeanUtils.toString((Object)this.sequenceDate)).append(',').append(' ');
        buf.append("contractSpec").append('=').append(JodaBeanUtils.toString((Object)this.contractSpec));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

