/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.option;

import com.opengamma.strata.product.option.Barrier;
import com.opengamma.strata.product.option.BarrierType;
import com.opengamma.strata.product.option.KnockType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SimpleConstantContinuousBarrier
implements Barrier,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final BarrierType barrierType;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final KnockType knockType;
    @PropertyDefinition
    private final double barrierLevel;
    private static final long serialVersionUID = 1L;

    public static SimpleConstantContinuousBarrier of(BarrierType barrierType, KnockType knockType, double barrierLevel) {
        return new SimpleConstantContinuousBarrier(barrierType, knockType, barrierLevel);
    }

    @Override
    public double getBarrierLevel(LocalDate date) {
        return this.barrierLevel;
    }

    @Override
    public SimpleConstantContinuousBarrier inverseKnockType() {
        KnockType inverse = this.knockType.equals((Object)KnockType.KNOCK_IN) ? KnockType.KNOCK_OUT : KnockType.KNOCK_IN;
        return SimpleConstantContinuousBarrier.of(this.barrierType, inverse, this.barrierLevel);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private SimpleConstantContinuousBarrier(BarrierType barrierType, KnockType knockType, double barrierLevel) {
        JodaBeanUtils.notNull((Object)((Object)barrierType), (String)"barrierType");
        JodaBeanUtils.notNull((Object)((Object)knockType), (String)"knockType");
        this.barrierType = barrierType;
        this.knockType = knockType;
        this.barrierLevel = barrierLevel;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public BarrierType getBarrierType() {
        return this.barrierType;
    }

    @Override
    public KnockType getKnockType() {
        return this.knockType;
    }

    public double getBarrierLevel() {
        return this.barrierLevel;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SimpleConstantContinuousBarrier other = (SimpleConstantContinuousBarrier)obj;
            return JodaBeanUtils.equal((Object)((Object)this.barrierType), (Object)((Object)other.barrierType)) && JodaBeanUtils.equal((Object)((Object)this.knockType), (Object)((Object)other.knockType)) && JodaBeanUtils.equal((double)this.barrierLevel, (double)other.barrierLevel);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.barrierType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.knockType));
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.barrierLevel);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("SimpleConstantContinuousBarrier{");
        buf.append("barrierType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.barrierType))).append(',').append(' ');
        buf.append("knockType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.knockType))).append(',').append(' ');
        buf.append("barrierLevel").append('=').append(JodaBeanUtils.toString((Object)this.barrierLevel));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SimpleConstantContinuousBarrier> {
        private BarrierType barrierType;
        private KnockType knockType;
        private double barrierLevel;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1029043089: {
                    return this.barrierType;
                }
                case 975895086: {
                    return this.knockType;
                }
                case 1827586573: {
                    return this.barrierLevel;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1029043089: {
                    this.barrierType = (BarrierType)((Object)newValue);
                    break;
                }
                case 975895086: {
                    this.knockType = (KnockType)((Object)newValue);
                    break;
                }
                case 1827586573: {
                    this.barrierLevel = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SimpleConstantContinuousBarrier build() {
            return new SimpleConstantContinuousBarrier(this.barrierType, this.knockType, this.barrierLevel);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("SimpleConstantContinuousBarrier.Builder{");
            buf.append("barrierType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.barrierType))).append(',').append(' ');
            buf.append("knockType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.knockType))).append(',').append(' ');
            buf.append("barrierLevel").append('=').append(JodaBeanUtils.toString((Object)this.barrierLevel));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BarrierType> barrierType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"barrierType", SimpleConstantContinuousBarrier.class, BarrierType.class);
        private final MetaProperty<KnockType> knockType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"knockType", SimpleConstantContinuousBarrier.class, KnockType.class);
        private final MetaProperty<Double> barrierLevel = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"barrierLevel", SimpleConstantContinuousBarrier.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"barrierType", "knockType", "barrierLevel"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1029043089: {
                    return this.barrierType;
                }
                case 975895086: {
                    return this.knockType;
                }
                case 1827586573: {
                    return this.barrierLevel;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SimpleConstantContinuousBarrier> builder() {
            return new Builder();
        }

        public Class<? extends SimpleConstantContinuousBarrier> beanType() {
            return SimpleConstantContinuousBarrier.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BarrierType> barrierType() {
            return this.barrierType;
        }

        public MetaProperty<KnockType> knockType() {
            return this.knockType;
        }

        public MetaProperty<Double> barrierLevel() {
            return this.barrierLevel;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1029043089: {
                    return ((SimpleConstantContinuousBarrier)bean).getBarrierType();
                }
                case 975895086: {
                    return ((SimpleConstantContinuousBarrier)bean).getKnockType();
                }
                case 1827586573: {
                    return ((SimpleConstantContinuousBarrier)bean).getBarrierLevel();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

