/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.payment;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.payment.ResolvedBulletPayment;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BulletPayment
implements Product,
Resolvable<ResolvedBulletPayment>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmount value;
    @PropertyDefinition(validate="notNull")
    private final AdjustableDate date;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        if (this.value.getAmount() < 0.0) {
            throw new IllegalArgumentException("Amount must be unsigned");
        }
    }

    public Currency getCurrency() {
        return this.value.getCurrency();
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        return ImmutableSet.of((Object)this.value.getCurrency());
    }

    public ResolvedBulletPayment resolve(ReferenceData refData) {
        CurrencyAmount signed = this.payReceive == PayReceive.PAY ? this.value.negated() : this.value;
        Payment payment = Payment.of((CurrencyAmount)signed, (LocalDate)this.date.adjusted(refData));
        return ResolvedBulletPayment.of(payment);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BulletPayment(PayReceive payReceive, CurrencyAmount value, AdjustableDate date) {
        JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
        JodaBeanUtils.notNull((Object)value, (String)"value");
        JodaBeanUtils.notNull((Object)date, (String)"date");
        this.payReceive = payReceive;
        this.value = value;
        this.date = date;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    public CurrencyAmount getValue() {
        return this.value;
    }

    public AdjustableDate getDate() {
        return this.date;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BulletPayment other = (BulletPayment)obj;
            return JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal((Object)this.value, (Object)other.value) && JodaBeanUtils.equal((Object)this.date, (Object)other.date);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("BulletPayment{");
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BulletPayment> {
        private PayReceive payReceive;
        private CurrencyAmount value;
        private AdjustableDate date;

        private Builder() {
        }

        private Builder(BulletPayment beanToCopy) {
            this.payReceive = beanToCopy.getPayReceive();
            this.value = beanToCopy.getValue();
            this.date = beanToCopy.getDate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 111972721: {
                    return this.value;
                }
                case 3076014: {
                    return this.date;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case 111972721: {
                    this.value = (CurrencyAmount)newValue;
                    break;
                }
                case 3076014: {
                    this.date = (AdjustableDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BulletPayment build() {
            return new BulletPayment(this.payReceive, this.value, this.date);
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder value(CurrencyAmount value) {
            JodaBeanUtils.notNull((Object)value, (String)"value");
            this.value = value;
            return this;
        }

        public Builder date(AdjustableDate date) {
            JodaBeanUtils.notNull((Object)date, (String)"date");
            this.date = date;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("BulletPayment.Builder{");
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", BulletPayment.class, PayReceive.class);
        private final MetaProperty<CurrencyAmount> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", BulletPayment.class, CurrencyAmount.class);
        private final MetaProperty<AdjustableDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", BulletPayment.class, AdjustableDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payReceive", "value", "date"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 111972721: {
                    return this.value;
                }
                case 3076014: {
                    return this.date;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BulletPayment> beanType() {
            return BulletPayment.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<CurrencyAmount> value() {
            return this.value;
        }

        public MetaProperty<AdjustableDate> date() {
            return this.date;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return ((BulletPayment)bean).getPayReceive();
                }
                case 111972721: {
                    return ((BulletPayment)bean).getValue();
                }
                case 3076014: {
                    return ((BulletPayment)bean).getDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

