/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FixedOvernightCompoundedAnnualRateComputation
implements RateComputation,
ImmutableBean,
Serializable {
    @PropertyDefinition
    private final double rate;
    @PropertyDefinition
    private final double accrualFactor;
    private final double simpleRate;
    private static final long serialVersionUID = 1L;

    public static FixedOvernightCompoundedAnnualRateComputation of(double rate, double accrualFactor) {
        return new FixedOvernightCompoundedAnnualRateComputation(rate, accrualFactor);
    }

    @ImmutableConstructor
    private FixedOvernightCompoundedAnnualRateComputation(double rate, double accrualFactor) {
        this.rate = rate;
        this.accrualFactor = accrualFactor;
        this.simpleRate = (Math.pow(1.0 + rate, accrualFactor) - 1.0) / accrualFactor;
    }

    public double getSimpleRate() {
        return this.simpleRate;
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getRate() {
        return this.rate;
    }

    public double getAccrualFactor() {
        return this.accrualFactor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FixedOvernightCompoundedAnnualRateComputation other = (FixedOvernightCompoundedAnnualRateComputation)obj;
            return JodaBeanUtils.equal((double)this.rate, (double)other.rate) && JodaBeanUtils.equal((double)this.accrualFactor, (double)other.accrualFactor);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.rate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.accrualFactor);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("FixedOvernightCompoundedAnnualRateComputation{");
        buf.append("rate").append('=').append(JodaBeanUtils.toString((Object)this.rate)).append(',').append(' ');
        buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FixedOvernightCompoundedAnnualRateComputation> {
        private double rate;
        private double accrualFactor;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3493088: {
                    return this.rate;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3493088: {
                    this.rate = (Double)newValue;
                    break;
                }
                case -1540322338: {
                    this.accrualFactor = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FixedOvernightCompoundedAnnualRateComputation build() {
            return new FixedOvernightCompoundedAnnualRateComputation(this.rate, this.accrualFactor);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("FixedOvernightCompoundedAnnualRateComputation.Builder{");
            buf.append("rate").append('=').append(JodaBeanUtils.toString((Object)this.rate)).append(',').append(' ');
            buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> rate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rate", FixedOvernightCompoundedAnnualRateComputation.class, Double.TYPE);
        private final MetaProperty<Double> accrualFactor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualFactor", FixedOvernightCompoundedAnnualRateComputation.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"rate", "accrualFactor"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3493088: {
                    return this.rate;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FixedOvernightCompoundedAnnualRateComputation> builder() {
            return new Builder();
        }

        public Class<? extends FixedOvernightCompoundedAnnualRateComputation> beanType() {
            return FixedOvernightCompoundedAnnualRateComputation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> rate() {
            return this.rate;
        }

        public MetaProperty<Double> accrualFactor() {
            return this.accrualFactor;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3493088: {
                    return ((FixedOvernightCompoundedAnnualRateComputation)bean).getRate();
                }
                case -1540322338: {
                    return ((FixedOvernightCompoundedAnnualRateComputation)bean).getAccrualFactor();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

