/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborAveragedFixing
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final IborIndexObservation observation;
    @PropertyDefinition(get="optional")
    private final Double fixedRate;
    @PropertyDefinition
    private final double weight;
    private static final long serialVersionUID = 1L;

    public static IborAveragedFixing of(IborIndexObservation observation) {
        return IborAveragedFixing.of(observation, null);
    }

    public static IborAveragedFixing of(IborIndexObservation observation, Double fixedRate) {
        return IborAveragedFixing.builder().observation(observation).fixedRate(fixedRate).build();
    }

    public static IborAveragedFixing ofDaysInResetPeriod(IborIndexObservation observation, LocalDate startDate, LocalDate endDate) {
        return IborAveragedFixing.ofDaysInResetPeriod(observation, startDate, endDate, null);
    }

    public static IborAveragedFixing ofDaysInResetPeriod(IborIndexObservation observation, LocalDate startDate, LocalDate endDate, Double fixedRate) {
        ArgChecker.notNull((Object)observation, (String)"observation");
        ArgChecker.notNull((Object)startDate, (String)"startDate");
        ArgChecker.notNull((Object)endDate, (String)"endDate");
        return IborAveragedFixing.builder().observation(observation).fixedRate(fixedRate).weight(endDate.toEpochDay() - startDate.toEpochDay()).build();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.weight(1.0);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IborAveragedFixing(IborIndexObservation observation, Double fixedRate, double weight) {
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        this.observation = observation;
        this.fixedRate = fixedRate;
        this.weight = weight;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public IborIndexObservation getObservation() {
        return this.observation;
    }

    public OptionalDouble getFixedRate() {
        return this.fixedRate != null ? OptionalDouble.of(this.fixedRate) : OptionalDouble.empty();
    }

    public double getWeight() {
        return this.weight;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborAveragedFixing other = (IborAveragedFixing)obj;
            return JodaBeanUtils.equal((Object)this.observation, (Object)other.observation) && JodaBeanUtils.equal((Object)this.fixedRate, (Object)other.fixedRate) && JodaBeanUtils.equal((double)this.weight, (double)other.weight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.weight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("IborAveragedFixing{");
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("weight").append('=').append(JodaBeanUtils.toString((Object)this.weight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborAveragedFixing> {
        private IborIndexObservation observation;
        private Double fixedRate;
        private double weight;

        private Builder() {
            IborAveragedFixing.applyDefaults(this);
        }

        private Builder(IborAveragedFixing beanToCopy) {
            this.observation = beanToCopy.getObservation();
            this.fixedRate = beanToCopy.fixedRate;
            this.weight = beanToCopy.getWeight();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case -791592328: {
                    return this.weight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    this.observation = (IborIndexObservation)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case -791592328: {
                    this.weight = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborAveragedFixing build() {
            return new IborAveragedFixing(this.observation, this.fixedRate, this.weight);
        }

        public Builder observation(IborIndexObservation observation) {
            JodaBeanUtils.notNull((Object)observation, (String)"observation");
            this.observation = observation;
            return this;
        }

        public Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder weight(double weight) {
            this.weight = weight;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("IborAveragedFixing.Builder{");
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("weight").append('=').append(JodaBeanUtils.toString((Object)this.weight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", IborAveragedFixing.class, IborIndexObservation.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", IborAveragedFixing.class, Double.class);
        private final MetaProperty<Double> weight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"weight", IborAveragedFixing.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observation", "fixedRate", "weight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case -791592328: {
                    return this.weight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborAveragedFixing> beanType() {
            return IborAveragedFixing.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndexObservation> observation() {
            return this.observation;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<Double> weight() {
            return this.weight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return ((IborAveragedFixing)bean).getObservation();
                }
                case 747425396: {
                    return ((IborAveragedFixing)bean).fixedRate;
                }
                case -791592328: {
                    return ((IborAveragedFixing)bean).getWeight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

