/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.rate.IborAveragedFixing;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IborAveragedRateComputation
implements RateComputation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<IborAveragedFixing> fixings;
    private final transient double totalWeight;
    private static final long serialVersionUID = 1L;

    public static IborAveragedRateComputation of(List<IborAveragedFixing> fixings) {
        return new IborAveragedRateComputation(fixings);
    }

    @ImmutableConstructor
    private IborAveragedRateComputation(List<IborAveragedFixing> fixings) {
        fixings.stream().map(f -> f.getObservation().getIndex()).distinct().reduce(Guavate.ensureOnlyOne());
        this.fixings = ImmutableList.copyOf(fixings);
        this.totalWeight = fixings.stream().mapToDouble(f -> f.getWeight()).sum();
    }

    private Object readResolve() {
        return new IborAveragedRateComputation((List<IborAveragedFixing>)this.fixings);
    }

    public IborIndex getIndex() {
        return ((IborAveragedFixing)this.fixings.get(0)).getObservation().getIndex();
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.getIndex());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<IborAveragedFixing> getFixings() {
        return this.fixings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborAveragedRateComputation other = (IborAveragedRateComputation)obj;
            return JodaBeanUtils.equal(this.fixings, other.fixings);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.fixings);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("IborAveragedRateComputation{");
        buf.append("fixings").append('=').append(JodaBeanUtils.toString(this.fixings));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IborAveragedRateComputation> {
        private List<IborAveragedFixing> fixings = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -843784602: {
                    return this.fixings;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -843784602: {
                    this.fixings = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IborAveragedRateComputation build() {
            return new IborAveragedRateComputation(this.fixings);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("IborAveragedRateComputation.Builder{");
            buf.append("fixings").append('=').append(JodaBeanUtils.toString(this.fixings));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<IborAveragedFixing>> fixings = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixings", IborAveragedRateComputation.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"fixings"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -843784602: {
                    return this.fixings;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IborAveragedRateComputation> builder() {
            return new Builder();
        }

        public Class<? extends IborAveragedRateComputation> beanType() {
            return IborAveragedRateComputation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<IborAveragedFixing>> fixings() {
            return this.fixings;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -843784602: {
                    return ((IborAveragedRateComputation)bean).getFixings();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

