/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IborInterpolatedRateComputation
implements RateComputation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final IborIndexObservation shortObservation;
    @PropertyDefinition(validate="notNull")
    private final IborIndexObservation longObservation;
    private static final long serialVersionUID = 1L;

    public static IborInterpolatedRateComputation of(IborIndex index1, IborIndex index2, LocalDate fixingDate, ReferenceData refData) {
        boolean inOrder = IborInterpolatedRateComputation.indicesInOrder(index1, index2, fixingDate);
        IborIndexObservation obs1 = IborIndexObservation.of((IborIndex)index1, (LocalDate)fixingDate, (ReferenceData)refData);
        IborIndexObservation obs2 = IborIndexObservation.of((IborIndex)index2, (LocalDate)fixingDate, (ReferenceData)refData);
        return new IborInterpolatedRateComputation(inOrder ? obs1 : obs2, inOrder ? obs2 : obs1);
    }

    public static IborInterpolatedRateComputation of(IborIndexObservation shortObservation, IborIndexObservation longObservation) {
        return new IborInterpolatedRateComputation(shortObservation, longObservation);
    }

    @ImmutableValidator
    private void validate() {
        IborIndex shortIndex = this.shortObservation.getIndex();
        IborIndex longIndex = this.longObservation.getIndex();
        if (!shortIndex.getCurrency().equals((Object)longIndex.getCurrency())) {
            throw new IllegalArgumentException("Interpolation requires two indices in the same currency");
        }
        if (shortIndex.equals(longIndex)) {
            throw new IllegalArgumentException("Interpolation requires two different indices");
        }
        if (!this.shortObservation.getFixingDate().equals(this.longObservation.getFixingDate())) {
            throw new IllegalArgumentException("Interpolation requires observations with same fixing date");
        }
        if (!IborInterpolatedRateComputation.indicesInOrder(shortIndex, longIndex, this.shortObservation.getFixingDate())) {
            throw new IllegalArgumentException(Messages.format((String)"Interpolation indices passed in wrong order: {} {}", (Object[])new Object[]{shortIndex, longIndex}));
        }
    }

    private static boolean indicesInOrder(IborIndex index1, IborIndex index2, LocalDate fixingDate) {
        return fixingDate.plus((TemporalAmount)index1.getTenor()).isBefore(fixingDate.plus((TemporalAmount)index2.getTenor()));
    }

    public LocalDate getFixingDate() {
        return this.shortObservation.getFixingDate();
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.shortObservation.getIndex());
        builder.add((Object)this.longObservation.getIndex());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IborInterpolatedRateComputation(IborIndexObservation shortObservation, IborIndexObservation longObservation) {
        JodaBeanUtils.notNull((Object)shortObservation, (String)"shortObservation");
        JodaBeanUtils.notNull((Object)longObservation, (String)"longObservation");
        this.shortObservation = shortObservation;
        this.longObservation = longObservation;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public IborIndexObservation getShortObservation() {
        return this.shortObservation;
    }

    public IborIndexObservation getLongObservation() {
        return this.longObservation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborInterpolatedRateComputation other = (IborInterpolatedRateComputation)obj;
            return JodaBeanUtils.equal((Object)this.shortObservation, (Object)other.shortObservation) && JodaBeanUtils.equal((Object)this.longObservation, (Object)other.longObservation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shortObservation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.longObservation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("IborInterpolatedRateComputation{");
        buf.append("shortObservation").append('=').append(JodaBeanUtils.toString((Object)this.shortObservation)).append(',').append(' ');
        buf.append("longObservation").append('=').append(JodaBeanUtils.toString((Object)this.longObservation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IborInterpolatedRateComputation> {
        private IborIndexObservation shortObservation;
        private IborIndexObservation longObservation;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -496986608: {
                    return this.shortObservation;
                }
                case -684321776: {
                    return this.longObservation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -496986608: {
                    this.shortObservation = (IborIndexObservation)newValue;
                    break;
                }
                case -684321776: {
                    this.longObservation = (IborIndexObservation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IborInterpolatedRateComputation build() {
            return new IborInterpolatedRateComputation(this.shortObservation, this.longObservation);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("IborInterpolatedRateComputation.Builder{");
            buf.append("shortObservation").append('=').append(JodaBeanUtils.toString((Object)this.shortObservation)).append(',').append(' ');
            buf.append("longObservation").append('=').append(JodaBeanUtils.toString((Object)this.longObservation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndexObservation> shortObservation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shortObservation", IborInterpolatedRateComputation.class, IborIndexObservation.class);
        private final MetaProperty<IborIndexObservation> longObservation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longObservation", IborInterpolatedRateComputation.class, IborIndexObservation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"shortObservation", "longObservation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -496986608: {
                    return this.shortObservation;
                }
                case -684321776: {
                    return this.longObservation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IborInterpolatedRateComputation> builder() {
            return new Builder();
        }

        public Class<? extends IborInterpolatedRateComputation> beanType() {
            return IborInterpolatedRateComputation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndexObservation> shortObservation() {
            return this.shortObservation;
        }

        public MetaProperty<IborIndexObservation> longObservation() {
            return this.longObservation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -496986608: {
                    return ((IborInterpolatedRateComputation)bean).getShortObservation();
                }
                case -684321776: {
                    return ((IborInterpolatedRateComputation)bean).getLongObservation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

