/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IborRateComputation
implements RateComputation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final IborIndexObservation observation;
    private static final long serialVersionUID = 1L;

    public static IborRateComputation of(IborIndex index, LocalDate fixingDate, ReferenceData refData) {
        return new IborRateComputation(IborIndexObservation.of((IborIndex)index, (LocalDate)fixingDate, (ReferenceData)refData));
    }

    public static IborRateComputation of(IborIndexObservation underlyingObservation) {
        return new IborRateComputation(underlyingObservation);
    }

    public IborIndex getIndex() {
        return this.observation.getIndex();
    }

    public Currency getCurrency() {
        return this.getIndex().getCurrency();
    }

    public LocalDate getFixingDate() {
        return this.observation.getFixingDate();
    }

    public LocalDate getEffectiveDate() {
        return this.observation.getEffectiveDate();
    }

    public LocalDate getMaturityDate() {
        return this.observation.getMaturityDate();
    }

    public double getYearFraction() {
        return this.observation.getYearFraction();
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.getIndex());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IborRateComputation(IborIndexObservation observation) {
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        this.observation = observation;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public IborIndexObservation getObservation() {
        return this.observation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborRateComputation other = (IborRateComputation)obj;
            return JodaBeanUtils.equal((Object)this.observation, (Object)other.observation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("IborRateComputation{");
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IborRateComputation> {
        private IborIndexObservation observation;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    this.observation = (IborIndexObservation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IborRateComputation build() {
            return new IborRateComputation(this.observation);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("IborRateComputation.Builder{");
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", IborRateComputation.class, IborIndexObservation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IborRateComputation> builder() {
            return new Builder();
        }

        public Class<? extends IborRateComputation> beanType() {
            return IborRateComputation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndexObservation> observation() {
            return this.observation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return ((IborRateComputation)bean).getObservation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

