/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.index.PriceIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class InflationEndInterpolatedRateComputation
implements RateComputation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double startIndexValue;
    @PropertyDefinition(validate="notNull")
    private final PriceIndexObservation endObservation;
    @PropertyDefinition(validate="notNull")
    private final PriceIndexObservation endSecondObservation;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double weight;
    private static final long serialVersionUID = 1L;

    public static InflationEndInterpolatedRateComputation of(PriceIndex index, double startIndexValue, YearMonth referenceEndMonth, double weight) {
        return new InflationEndInterpolatedRateComputation(startIndexValue, PriceIndexObservation.of((PriceIndex)index, (YearMonth)referenceEndMonth), PriceIndexObservation.of((PriceIndex)index, (YearMonth)referenceEndMonth.plusMonths(1L)), weight);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.endObservation.getIndex().equals(this.endSecondObservation.getIndex()), (String)"Both observations must be for the same index");
        ArgChecker.inOrderNotEqual((Comparable)this.endObservation.getFixingMonth(), (Object)this.endSecondObservation.getFixingMonth(), (String)"endObservation", (String)"endSecondObservation");
    }

    public PriceIndex getIndex() {
        return this.endObservation.getIndex();
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.getIndex());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private InflationEndInterpolatedRateComputation(double startIndexValue, PriceIndexObservation endObservation, PriceIndexObservation endSecondObservation, double weight) {
        ArgChecker.notNegativeOrZero((double)startIndexValue, (String)"startIndexValue");
        JodaBeanUtils.notNull((Object)endObservation, (String)"endObservation");
        JodaBeanUtils.notNull((Object)endSecondObservation, (String)"endSecondObservation");
        ArgChecker.notNegative((double)weight, (String)"weight");
        this.startIndexValue = startIndexValue;
        this.endObservation = endObservation;
        this.endSecondObservation = endSecondObservation;
        this.weight = weight;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getStartIndexValue() {
        return this.startIndexValue;
    }

    public PriceIndexObservation getEndObservation() {
        return this.endObservation;
    }

    public PriceIndexObservation getEndSecondObservation() {
        return this.endSecondObservation;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InflationEndInterpolatedRateComputation other = (InflationEndInterpolatedRateComputation)obj;
            return JodaBeanUtils.equal((double)this.startIndexValue, (double)other.startIndexValue) && JodaBeanUtils.equal((Object)this.endObservation, (Object)other.endObservation) && JodaBeanUtils.equal((Object)this.endSecondObservation, (Object)other.endSecondObservation) && JodaBeanUtils.equal((double)this.weight, (double)other.weight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.startIndexValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endObservation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endSecondObservation);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.weight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("InflationEndInterpolatedRateComputation{");
        buf.append("startIndexValue").append('=').append(JodaBeanUtils.toString((Object)this.startIndexValue)).append(',').append(' ');
        buf.append("endObservation").append('=').append(JodaBeanUtils.toString((Object)this.endObservation)).append(',').append(' ');
        buf.append("endSecondObservation").append('=').append(JodaBeanUtils.toString((Object)this.endSecondObservation)).append(',').append(' ');
        buf.append("weight").append('=').append(JodaBeanUtils.toString((Object)this.weight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<InflationEndInterpolatedRateComputation> {
        private double startIndexValue;
        private PriceIndexObservation endObservation;
        private PriceIndexObservation endSecondObservation;
        private double weight;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1656407615: {
                    return this.startIndexValue;
                }
                case 82210897: {
                    return this.endObservation;
                }
                case 1209389949: {
                    return this.endSecondObservation;
                }
                case -791592328: {
                    return this.weight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1656407615: {
                    this.startIndexValue = (Double)newValue;
                    break;
                }
                case 82210897: {
                    this.endObservation = (PriceIndexObservation)newValue;
                    break;
                }
                case 1209389949: {
                    this.endSecondObservation = (PriceIndexObservation)newValue;
                    break;
                }
                case -791592328: {
                    this.weight = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public InflationEndInterpolatedRateComputation build() {
            return new InflationEndInterpolatedRateComputation(this.startIndexValue, this.endObservation, this.endSecondObservation, this.weight);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("InflationEndInterpolatedRateComputation.Builder{");
            buf.append("startIndexValue").append('=').append(JodaBeanUtils.toString((Object)this.startIndexValue)).append(',').append(' ');
            buf.append("endObservation").append('=').append(JodaBeanUtils.toString((Object)this.endObservation)).append(',').append(' ');
            buf.append("endSecondObservation").append('=').append(JodaBeanUtils.toString((Object)this.endSecondObservation)).append(',').append(' ');
            buf.append("weight").append('=').append(JodaBeanUtils.toString((Object)this.weight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> startIndexValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startIndexValue", InflationEndInterpolatedRateComputation.class, Double.TYPE);
        private final MetaProperty<PriceIndexObservation> endObservation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endObservation", InflationEndInterpolatedRateComputation.class, PriceIndexObservation.class);
        private final MetaProperty<PriceIndexObservation> endSecondObservation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endSecondObservation", InflationEndInterpolatedRateComputation.class, PriceIndexObservation.class);
        private final MetaProperty<Double> weight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"weight", InflationEndInterpolatedRateComputation.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"startIndexValue", "endObservation", "endSecondObservation", "weight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1656407615: {
                    return this.startIndexValue;
                }
                case 82210897: {
                    return this.endObservation;
                }
                case 1209389949: {
                    return this.endSecondObservation;
                }
                case -791592328: {
                    return this.weight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends InflationEndInterpolatedRateComputation> builder() {
            return new Builder();
        }

        public Class<? extends InflationEndInterpolatedRateComputation> beanType() {
            return InflationEndInterpolatedRateComputation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> startIndexValue() {
            return this.startIndexValue;
        }

        public MetaProperty<PriceIndexObservation> endObservation() {
            return this.endObservation;
        }

        public MetaProperty<PriceIndexObservation> endSecondObservation() {
            return this.endSecondObservation;
        }

        public MetaProperty<Double> weight() {
            return this.weight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1656407615: {
                    return ((InflationEndInterpolatedRateComputation)bean).getStartIndexValue();
                }
                case 82210897: {
                    return ((InflationEndInterpolatedRateComputation)bean).getEndObservation();
                }
                case 1209389949: {
                    return ((InflationEndInterpolatedRateComputation)bean).getEndSecondObservation();
                }
                case -791592328: {
                    return ((InflationEndInterpolatedRateComputation)bean).getWeight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

