/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.index.PriceIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class InflationEndMonthRateComputation
implements RateComputation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double startIndexValue;
    @PropertyDefinition(validate="notNull")
    private final PriceIndexObservation endObservation;
    private static final long serialVersionUID = 1L;

    public static InflationEndMonthRateComputation of(PriceIndex index, double startIndexValue, YearMonth referenceEndMonth) {
        return new InflationEndMonthRateComputation(startIndexValue, PriceIndexObservation.of((PriceIndex)index, (YearMonth)referenceEndMonth));
    }

    public PriceIndex getIndex() {
        return this.endObservation.getIndex();
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.getIndex());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private InflationEndMonthRateComputation(double startIndexValue, PriceIndexObservation endObservation) {
        ArgChecker.notNegativeOrZero((double)startIndexValue, (String)"startIndexValue");
        JodaBeanUtils.notNull((Object)endObservation, (String)"endObservation");
        this.startIndexValue = startIndexValue;
        this.endObservation = endObservation;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getStartIndexValue() {
        return this.startIndexValue;
    }

    public PriceIndexObservation getEndObservation() {
        return this.endObservation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InflationEndMonthRateComputation other = (InflationEndMonthRateComputation)obj;
            return JodaBeanUtils.equal((double)this.startIndexValue, (double)other.startIndexValue) && JodaBeanUtils.equal((Object)this.endObservation, (Object)other.endObservation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.startIndexValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endObservation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("InflationEndMonthRateComputation{");
        buf.append("startIndexValue").append('=').append(JodaBeanUtils.toString((Object)this.startIndexValue)).append(',').append(' ');
        buf.append("endObservation").append('=').append(JodaBeanUtils.toString((Object)this.endObservation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<InflationEndMonthRateComputation> {
        private double startIndexValue;
        private PriceIndexObservation endObservation;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1656407615: {
                    return this.startIndexValue;
                }
                case 82210897: {
                    return this.endObservation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1656407615: {
                    this.startIndexValue = (Double)newValue;
                    break;
                }
                case 82210897: {
                    this.endObservation = (PriceIndexObservation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public InflationEndMonthRateComputation build() {
            return new InflationEndMonthRateComputation(this.startIndexValue, this.endObservation);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("InflationEndMonthRateComputation.Builder{");
            buf.append("startIndexValue").append('=').append(JodaBeanUtils.toString((Object)this.startIndexValue)).append(',').append(' ');
            buf.append("endObservation").append('=').append(JodaBeanUtils.toString((Object)this.endObservation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> startIndexValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startIndexValue", InflationEndMonthRateComputation.class, Double.TYPE);
        private final MetaProperty<PriceIndexObservation> endObservation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endObservation", InflationEndMonthRateComputation.class, PriceIndexObservation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"startIndexValue", "endObservation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1656407615: {
                    return this.startIndexValue;
                }
                case 82210897: {
                    return this.endObservation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends InflationEndMonthRateComputation> builder() {
            return new Builder();
        }

        public Class<? extends InflationEndMonthRateComputation> beanType() {
            return InflationEndMonthRateComputation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> startIndexValue() {
            return this.startIndexValue;
        }

        public MetaProperty<PriceIndexObservation> endObservation() {
            return this.endObservation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1656407615: {
                    return ((InflationEndMonthRateComputation)bean).getStartIndexValue();
                }
                case 82210897: {
                    return ((InflationEndMonthRateComputation)bean).getEndObservation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

