/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.index.PriceIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class InflationMonthlyRateComputation
implements RateComputation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PriceIndexObservation startObservation;
    @PropertyDefinition(validate="notNull")
    private final PriceIndexObservation endObservation;
    private static final long serialVersionUID = 1L;

    public static InflationMonthlyRateComputation of(PriceIndex index, YearMonth referenceStartMonth, YearMonth referenceEndMonth) {
        return new InflationMonthlyRateComputation(PriceIndexObservation.of((PriceIndex)index, (YearMonth)referenceStartMonth), PriceIndexObservation.of((PriceIndex)index, (YearMonth)referenceEndMonth));
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.startObservation.getIndex().equals(this.endObservation.getIndex()), (String)"Both observations must be for the same index");
        ArgChecker.inOrderNotEqual((Comparable)this.startObservation.getFixingMonth(), (Object)this.endObservation.getFixingMonth(), (String)"referenceStartMonth", (String)"referenceEndMonth");
    }

    public PriceIndex getIndex() {
        return this.startObservation.getIndex();
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.getIndex());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private InflationMonthlyRateComputation(PriceIndexObservation startObservation, PriceIndexObservation endObservation) {
        JodaBeanUtils.notNull((Object)startObservation, (String)"startObservation");
        JodaBeanUtils.notNull((Object)endObservation, (String)"endObservation");
        this.startObservation = startObservation;
        this.endObservation = endObservation;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PriceIndexObservation getStartObservation() {
        return this.startObservation;
    }

    public PriceIndexObservation getEndObservation() {
        return this.endObservation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InflationMonthlyRateComputation other = (InflationMonthlyRateComputation)obj;
            return JodaBeanUtils.equal((Object)this.startObservation, (Object)other.startObservation) && JodaBeanUtils.equal((Object)this.endObservation, (Object)other.endObservation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startObservation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endObservation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("InflationMonthlyRateComputation{");
        buf.append("startObservation").append('=').append(JodaBeanUtils.toString((Object)this.startObservation)).append(',').append(' ');
        buf.append("endObservation").append('=').append(JodaBeanUtils.toString((Object)this.endObservation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<InflationMonthlyRateComputation> {
        private PriceIndexObservation startObservation;
        private PriceIndexObservation endObservation;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1098347926: {
                    return this.startObservation;
                }
                case 82210897: {
                    return this.endObservation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1098347926: {
                    this.startObservation = (PriceIndexObservation)newValue;
                    break;
                }
                case 82210897: {
                    this.endObservation = (PriceIndexObservation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public InflationMonthlyRateComputation build() {
            return new InflationMonthlyRateComputation(this.startObservation, this.endObservation);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("InflationMonthlyRateComputation.Builder{");
            buf.append("startObservation").append('=').append(JodaBeanUtils.toString((Object)this.startObservation)).append(',').append(' ');
            buf.append("endObservation").append('=').append(JodaBeanUtils.toString((Object)this.endObservation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PriceIndexObservation> startObservation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startObservation", InflationMonthlyRateComputation.class, PriceIndexObservation.class);
        private final MetaProperty<PriceIndexObservation> endObservation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endObservation", InflationMonthlyRateComputation.class, PriceIndexObservation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"startObservation", "endObservation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1098347926: {
                    return this.startObservation;
                }
                case 82210897: {
                    return this.endObservation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends InflationMonthlyRateComputation> builder() {
            return new Builder();
        }

        public Class<? extends InflationMonthlyRateComputation> beanType() {
            return InflationMonthlyRateComputation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PriceIndexObservation> startObservation() {
            return this.startObservation;
        }

        public MetaProperty<PriceIndexObservation> endObservation() {
            return this.endObservation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1098347926: {
                    return ((InflationMonthlyRateComputation)bean).getStartObservation();
                }
                case 82210897: {
                    return ((InflationMonthlyRateComputation)bean).getEndObservation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

