/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.rate.OvernightRateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class OvernightAveragedRateComputation
implements OvernightRateComputation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final OvernightIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final HolidayCalendar fixingCalendar;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate endDate;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final int rateCutOffDays;
    private static final long serialVersionUID = 1L;

    public static OvernightAveragedRateComputation of(OvernightIndex index, LocalDate startDate, LocalDate endDate, ReferenceData refData) {
        return OvernightAveragedRateComputation.of(index, startDate, endDate, 0, refData);
    }

    public static OvernightAveragedRateComputation of(OvernightIndex index, LocalDate startDate, LocalDate endDate, int rateCutOffDays, ReferenceData refData) {
        return OvernightAveragedRateComputation.builder().index(index).fixingCalendar(index.getFixingCalendar().resolve(refData)).startDate(index.calculateFixingFromEffective(startDate, refData)).endDate(index.calculateFixingFromEffective(endDate, refData)).rateCutOffDays(rateCutOffDays).build();
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OvernightAveragedRateComputation(OvernightIndex index, HolidayCalendar fixingCalendar, LocalDate startDate, LocalDate endDate, int rateCutOffDays) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fixingCalendar, (String)"fixingCalendar");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        ArgChecker.notNegative((int)rateCutOffDays, (String)"rateCutOffDays");
        this.index = index;
        this.fixingCalendar = fixingCalendar;
        this.startDate = startDate;
        this.endDate = endDate;
        this.rateCutOffDays = rateCutOffDays;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public OvernightIndex getIndex() {
        return this.index;
    }

    @Override
    public HolidayCalendar getFixingCalendar() {
        return this.fixingCalendar;
    }

    @Override
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Override
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public int getRateCutOffDays() {
        return this.rateCutOffDays;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightAveragedRateComputation other = (OvernightAveragedRateComputation)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.fixingCalendar, (Object)other.fixingCalendar) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && this.rateCutOffDays == other.rateCutOffDays;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingCalendar);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.rateCutOffDays);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("OvernightAveragedRateComputation{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("fixingCalendar").append('=').append(JodaBeanUtils.toString((Object)this.fixingCalendar)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("rateCutOffDays").append('=').append(JodaBeanUtils.toString((Object)this.rateCutOffDays));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<OvernightAveragedRateComputation> {
        private OvernightIndex index;
        private HolidayCalendar fixingCalendar;
        private LocalDate startDate;
        private LocalDate endDate;
        private int rateCutOffDays;

        private Builder() {
        }

        private Builder(OvernightAveragedRateComputation beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.fixingCalendar = beanToCopy.getFixingCalendar();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.rateCutOffDays = beanToCopy.getRateCutOffDays();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 394230283: {
                    return this.fixingCalendar;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -92095804: {
                    return this.rateCutOffDays;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (OvernightIndex)newValue;
                    break;
                }
                case 394230283: {
                    this.fixingCalendar = (HolidayCalendar)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case -92095804: {
                    this.rateCutOffDays = (Integer)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public OvernightAveragedRateComputation build() {
            return new OvernightAveragedRateComputation(this.index, this.fixingCalendar, this.startDate, this.endDate, this.rateCutOffDays);
        }

        public Builder index(OvernightIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder fixingCalendar(HolidayCalendar fixingCalendar) {
            JodaBeanUtils.notNull((Object)fixingCalendar, (String)"fixingCalendar");
            this.fixingCalendar = fixingCalendar;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder rateCutOffDays(int rateCutOffDays) {
            ArgChecker.notNegative((int)rateCutOffDays, (String)"rateCutOffDays");
            this.rateCutOffDays = rateCutOffDays;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("OvernightAveragedRateComputation.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("fixingCalendar").append('=').append(JodaBeanUtils.toString((Object)this.fixingCalendar)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("rateCutOffDays").append('=').append(JodaBeanUtils.toString((Object)this.rateCutOffDays));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<OvernightIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", OvernightAveragedRateComputation.class, OvernightIndex.class);
        private final MetaProperty<HolidayCalendar> fixingCalendar = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingCalendar", OvernightAveragedRateComputation.class, HolidayCalendar.class);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", OvernightAveragedRateComputation.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", OvernightAveragedRateComputation.class, LocalDate.class);
        private final MetaProperty<Integer> rateCutOffDays = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rateCutOffDays", OvernightAveragedRateComputation.class, Integer.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "fixingCalendar", "startDate", "endDate", "rateCutOffDays"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 394230283: {
                    return this.fixingCalendar;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -92095804: {
                    return this.rateCutOffDays;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends OvernightAveragedRateComputation> beanType() {
            return OvernightAveragedRateComputation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<OvernightIndex> index() {
            return this.index;
        }

        public MetaProperty<HolidayCalendar> fixingCalendar() {
            return this.fixingCalendar;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<Integer> rateCutOffDays() {
            return this.rateCutOffDays;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((OvernightAveragedRateComputation)bean).getIndex();
                }
                case 394230283: {
                    return ((OvernightAveragedRateComputation)bean).getFixingCalendar();
                }
                case -2129778896: {
                    return ((OvernightAveragedRateComputation)bean).getStartDate();
                }
                case -1607727319: {
                    return ((OvernightAveragedRateComputation)bean).getEndDate();
                }
                case -92095804: {
                    return ((OvernightAveragedRateComputation)bean).getRateCutOffDays();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

