/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.rate;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.rate.OvernightAveragedDailyRateComputation;
import com.opengamma.strata.product.rate.OvernightAveragedRateComputation;
import com.opengamma.strata.product.rate.OvernightCompoundedAnnualRateComputation;
import com.opengamma.strata.product.rate.OvernightCompoundedRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.OvernightAccrualMethod;
import java.time.LocalDate;

public interface OvernightRateComputation
extends RateComputation {
    public static OvernightRateComputation of(OvernightIndex index, LocalDate startDate, LocalDate endDate, int rateCutOffDays, OvernightAccrualMethod accrualMethod, ReferenceData referenceData) {
        switch (accrualMethod) {
            case COMPOUNDED: {
                return OvernightCompoundedRateComputation.of(index, startDate, endDate, rateCutOffDays, referenceData);
            }
            case OVERNIGHT_COMPOUNDED_ANNUAL_RATE: {
                return OvernightCompoundedAnnualRateComputation.of(index, startDate, endDate, referenceData);
            }
            case AVERAGED: {
                return OvernightAveragedRateComputation.of(index, startDate, endDate, rateCutOffDays, referenceData);
            }
            case AVERAGED_DAILY: {
                return OvernightAveragedDailyRateComputation.of(index, startDate, endDate, referenceData);
            }
        }
        throw new IllegalArgumentException(Messages.format((String)"unsupported Overnight accrual method, {}", (Object)((Object)accrualMethod)));
    }

    public OvernightIndex getIndex();

    public HolidayCalendar getFixingCalendar();

    public LocalDate getStartDate();

    public LocalDate getEndDate();

    default public LocalDate calculatePublicationFromFixing(LocalDate fixingDate) {
        return this.getFixingCalendar().shift(this.getFixingCalendar().nextOrSame(fixingDate), this.getIndex().getPublicationDateOffset());
    }

    default public LocalDate calculateEffectiveFromFixing(LocalDate fixingDate) {
        return this.getFixingCalendar().shift(this.getFixingCalendar().nextOrSame(fixingDate), this.getIndex().getEffectiveDateOffset());
    }

    default public LocalDate calculateMaturityFromFixing(LocalDate fixingDate) {
        return this.getFixingCalendar().shift(this.getFixingCalendar().nextOrSame(fixingDate), this.getIndex().getEffectiveDateOffset() + 1);
    }

    default public LocalDate calculateFixingFromEffective(LocalDate effectiveDate) {
        return this.getFixingCalendar().shift(this.getFixingCalendar().nextOrSame(effectiveDate), -this.getIndex().getEffectiveDateOffset());
    }

    default public LocalDate calculateMaturityFromEffective(LocalDate effectiveDate) {
        return this.getFixingCalendar().shift(this.getFixingCalendar().nextOrSame(effectiveDate), 1);
    }

    default public OvernightIndexObservation observeOn(LocalDate fixingDate) {
        LocalDate publicationDate = this.calculatePublicationFromFixing(fixingDate);
        LocalDate effectiveDate = this.calculateEffectiveFromFixing(fixingDate);
        LocalDate maturityDate = this.calculateMaturityFromEffective(effectiveDate);
        return OvernightIndexObservation.builder().index(this.getIndex()).fixingDate(fixingDate).publicationDate(publicationDate).effectiveDate(effectiveDate).maturityDate(maturityDate).yearFraction(this.getIndex().getDayCount().yearFraction(effectiveDate, maturityDate)).build();
    }

    @Override
    default public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.getIndex());
    }
}

