/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.product.rate.FixedOvernightCompoundedAnnualRateComputation;
import com.opengamma.strata.product.rate.FixedRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.FixedRateStubCalculation;
import com.opengamma.strata.product.swap.FutureValueNotional;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RateCalculation;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FixedRateCalculation
implements RateCalculation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final ValueSchedule rate;
    @PropertyDefinition(get="optional")
    private final FixedRateStubCalculation initialStub;
    @PropertyDefinition(get="optional")
    private final FixedRateStubCalculation finalStub;
    @PropertyDefinition(get="optional")
    private final FutureValueNotional futureValueNotional;
    private static final long serialVersionUID = 1L;

    public static FixedRateCalculation of(double rate, DayCount dayCount) {
        return FixedRateCalculation.builder().dayCount(dayCount).rate(ValueSchedule.of((double)rate)).build();
    }

    @Override
    public SwapLegType getType() {
        return SwapLegType.FIXED;
    }

    @Override
    public void collectCurrencies(ImmutableSet.Builder<Currency> builder) {
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
    }

    @Override
    public ImmutableList<RateAccrualPeriod> createAccrualPeriods(Schedule accrualSchedule, Schedule paymentSchedule, ReferenceData refData) {
        FixedRateStubCalculation initialStub = (FixedRateStubCalculation)MoreObjects.firstNonNull((Object)this.initialStub, (Object)FixedRateStubCalculation.NONE);
        FixedRateStubCalculation finalStub = (FixedRateStubCalculation)MoreObjects.firstNonNull((Object)this.finalStub, (Object)FixedRateStubCalculation.NONE);
        DoubleArray resolvedRates = this.rate.resolveValues(accrualSchedule);
        if (this.getFutureValueNotional().isPresent()) {
            if (accrualSchedule.size() != 1) {
                throw new IllegalArgumentException("Invalid swap, only one accrual period allowed when future value notional is present");
            }
            SchedulePeriod period = accrualSchedule.getPeriod(0);
            double yearFraction = period.yearFraction(this.dayCount, accrualSchedule);
            double resolvedRate = resolvedRates.get(0);
            FixedOvernightCompoundedAnnualRateComputation rateComputation = FixedOvernightCompoundedAnnualRateComputation.of(resolvedRate, yearFraction);
            RateAccrualPeriod accrualPeriod = new RateAccrualPeriod(period, yearFraction, rateComputation);
            return ImmutableList.of((Object)accrualPeriod);
        }
        Pair scheduleStubs = accrualSchedule.getStubs(this.initialStub == null && this.finalStub != null);
        Optional scheduleInitialStub = (Optional)scheduleStubs.getFirst();
        Optional scheduleFinalStub = (Optional)scheduleStubs.getSecond();
        ImmutableList.Builder accrualPeriods = ImmutableList.builder();
        for (int i = 0; i < accrualSchedule.size(); ++i) {
            SchedulePeriod period = accrualSchedule.getPeriod(i);
            double yearFraction = period.yearFraction(this.dayCount, accrualSchedule);
            RateComputation rateComputation = scheduleInitialStub.isPresent() && scheduleInitialStub.get() == period ? initialStub.createRateComputation(resolvedRates.get(i)) : (scheduleFinalStub.isPresent() && scheduleFinalStub.get() == period ? finalStub.createRateComputation(resolvedRates.get(i)) : FixedRateComputation.of(resolvedRates.get(i)));
            accrualPeriods.add((Object)new RateAccrualPeriod(period, yearFraction, rateComputation));
        }
        return accrualPeriods.build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FixedRateCalculation(DayCount dayCount, ValueSchedule rate, FixedRateStubCalculation initialStub, FixedRateStubCalculation finalStub, FutureValueNotional futureValueNotional) {
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)rate, (String)"rate");
        this.dayCount = dayCount;
        this.rate = rate;
        this.initialStub = initialStub;
        this.finalStub = finalStub;
        this.futureValueNotional = futureValueNotional;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public ValueSchedule getRate() {
        return this.rate;
    }

    public Optional<FixedRateStubCalculation> getInitialStub() {
        return Optional.ofNullable(this.initialStub);
    }

    public Optional<FixedRateStubCalculation> getFinalStub() {
        return Optional.ofNullable(this.finalStub);
    }

    public Optional<FutureValueNotional> getFutureValueNotional() {
        return Optional.ofNullable(this.futureValueNotional);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FixedRateCalculation other = (FixedRateCalculation)obj;
            return JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.rate, (Object)other.rate) && JodaBeanUtils.equal((Object)this.initialStub, (Object)other.initialStub) && JodaBeanUtils.equal((Object)this.finalStub, (Object)other.finalStub) && JodaBeanUtils.equal((Object)this.futureValueNotional, (Object)other.futureValueNotional);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.initialStub);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.finalStub);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.futureValueNotional);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("FixedRateCalculation{");
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("rate").append('=').append(JodaBeanUtils.toString((Object)this.rate)).append(',').append(' ');
        buf.append("initialStub").append('=').append(JodaBeanUtils.toString((Object)this.initialStub)).append(',').append(' ');
        buf.append("finalStub").append('=').append(JodaBeanUtils.toString((Object)this.finalStub)).append(',').append(' ');
        buf.append("futureValueNotional").append('=').append(JodaBeanUtils.toString((Object)this.futureValueNotional));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FixedRateCalculation> {
        private DayCount dayCount;
        private ValueSchedule rate;
        private FixedRateStubCalculation initialStub;
        private FixedRateStubCalculation finalStub;
        private FutureValueNotional futureValueNotional;

        private Builder() {
        }

        private Builder(FixedRateCalculation beanToCopy) {
            this.dayCount = beanToCopy.getDayCount();
            this.rate = beanToCopy.getRate();
            this.initialStub = beanToCopy.initialStub;
            this.finalStub = beanToCopy.finalStub;
            this.futureValueNotional = beanToCopy.futureValueNotional;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return this.dayCount;
                }
                case 3493088: {
                    return this.rate;
                }
                case 1233359378: {
                    return this.initialStub;
                }
                case 355242820: {
                    return this.finalStub;
                }
                case -282775858: {
                    return this.futureValueNotional;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 3493088: {
                    this.rate = (ValueSchedule)newValue;
                    break;
                }
                case 1233359378: {
                    this.initialStub = (FixedRateStubCalculation)newValue;
                    break;
                }
                case 355242820: {
                    this.finalStub = (FixedRateStubCalculation)newValue;
                    break;
                }
                case -282775858: {
                    this.futureValueNotional = (FutureValueNotional)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FixedRateCalculation build() {
            return new FixedRateCalculation(this.dayCount, this.rate, this.initialStub, this.finalStub, this.futureValueNotional);
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder rate(ValueSchedule rate) {
            JodaBeanUtils.notNull((Object)rate, (String)"rate");
            this.rate = rate;
            return this;
        }

        public Builder initialStub(FixedRateStubCalculation initialStub) {
            this.initialStub = initialStub;
            return this;
        }

        public Builder finalStub(FixedRateStubCalculation finalStub) {
            this.finalStub = finalStub;
            return this;
        }

        public Builder futureValueNotional(FutureValueNotional futureValueNotional) {
            this.futureValueNotional = futureValueNotional;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("FixedRateCalculation.Builder{");
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("rate").append('=').append(JodaBeanUtils.toString((Object)this.rate)).append(',').append(' ');
            buf.append("initialStub").append('=').append(JodaBeanUtils.toString((Object)this.initialStub)).append(',').append(' ');
            buf.append("finalStub").append('=').append(JodaBeanUtils.toString((Object)this.finalStub)).append(',').append(' ');
            buf.append("futureValueNotional").append('=').append(JodaBeanUtils.toString((Object)this.futureValueNotional));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", FixedRateCalculation.class, DayCount.class);
        private final MetaProperty<ValueSchedule> rate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rate", FixedRateCalculation.class, ValueSchedule.class);
        private final MetaProperty<FixedRateStubCalculation> initialStub = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"initialStub", FixedRateCalculation.class, FixedRateStubCalculation.class);
        private final MetaProperty<FixedRateStubCalculation> finalStub = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"finalStub", FixedRateCalculation.class, FixedRateStubCalculation.class);
        private final MetaProperty<FutureValueNotional> futureValueNotional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"futureValueNotional", FixedRateCalculation.class, FutureValueNotional.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"dayCount", "rate", "initialStub", "finalStub", "futureValueNotional"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return this.dayCount;
                }
                case 3493088: {
                    return this.rate;
                }
                case 1233359378: {
                    return this.initialStub;
                }
                case 355242820: {
                    return this.finalStub;
                }
                case -282775858: {
                    return this.futureValueNotional;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FixedRateCalculation> beanType() {
            return FixedRateCalculation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<ValueSchedule> rate() {
            return this.rate;
        }

        public MetaProperty<FixedRateStubCalculation> initialStub() {
            return this.initialStub;
        }

        public MetaProperty<FixedRateStubCalculation> finalStub() {
            return this.finalStub;
        }

        public MetaProperty<FutureValueNotional> futureValueNotional() {
            return this.futureValueNotional;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return ((FixedRateCalculation)bean).getDayCount();
                }
                case 3493088: {
                    return ((FixedRateCalculation)bean).getRate();
                }
                case 1233359378: {
                    return ((FixedRateCalculation)bean).initialStub;
                }
                case 355242820: {
                    return ((FixedRateCalculation)bean).finalStub;
                }
                case -282775858: {
                    return ((FixedRateCalculation)bean).futureValueNotional;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

