/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.rate.FixedRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.KnownAmountRateComputation;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FixedRateStubCalculation
implements ImmutableBean,
Serializable {
    public static final FixedRateStubCalculation NONE = new FixedRateStubCalculation(null, null);
    @PropertyDefinition(get="optional")
    private final Double fixedRate;
    @PropertyDefinition(get="optional")
    private final CurrencyAmount knownAmount;
    private static final long serialVersionUID = 1L;

    public static FixedRateStubCalculation ofFixedRate(double fixedRate) {
        return new FixedRateStubCalculation(fixedRate, null);
    }

    public static FixedRateStubCalculation ofKnownAmount(CurrencyAmount knownAmount) {
        ArgChecker.notNull((Object)knownAmount, (String)"knownAmount");
        return new FixedRateStubCalculation(null, knownAmount);
    }

    @ImmutableValidator
    private void validate() {
        if (this.fixedRate != null && this.knownAmount != null) {
            throw new IllegalArgumentException("Either rate or amount may be specified, not both");
        }
    }

    RateComputation createRateComputation(double defaultRate) {
        if (this.isFixedRate()) {
            return FixedRateComputation.of(this.fixedRate);
        }
        if (this.isKnownAmount()) {
            return KnownAmountRateComputation.of(this.knownAmount);
        }
        return FixedRateComputation.of(defaultRate);
    }

    public boolean isFixedRate() {
        return this.fixedRate != null;
    }

    public boolean isKnownAmount() {
        return this.knownAmount != null;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FixedRateStubCalculation(Double fixedRate, CurrencyAmount knownAmount) {
        this.fixedRate = fixedRate;
        this.knownAmount = knownAmount;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public OptionalDouble getFixedRate() {
        return this.fixedRate != null ? OptionalDouble.of(this.fixedRate) : OptionalDouble.empty();
    }

    public Optional<CurrencyAmount> getKnownAmount() {
        return Optional.ofNullable(this.knownAmount);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FixedRateStubCalculation other = (FixedRateStubCalculation)obj;
            return JodaBeanUtils.equal((Object)this.fixedRate, (Object)other.fixedRate) && JodaBeanUtils.equal((Object)this.knownAmount, (Object)other.knownAmount);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.knownAmount);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("FixedRateStubCalculation{");
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("knownAmount").append('=').append(JodaBeanUtils.toString((Object)this.knownAmount));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FixedRateStubCalculation> {
        private Double fixedRate;
        private CurrencyAmount knownAmount;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 747425396: {
                    return this.fixedRate;
                }
                case -158727813: {
                    return this.knownAmount;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case -158727813: {
                    this.knownAmount = (CurrencyAmount)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FixedRateStubCalculation build() {
            return new FixedRateStubCalculation(this.fixedRate, this.knownAmount);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("FixedRateStubCalculation.Builder{");
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("knownAmount").append('=').append(JodaBeanUtils.toString((Object)this.knownAmount));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", FixedRateStubCalculation.class, Double.class);
        private final MetaProperty<CurrencyAmount> knownAmount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"knownAmount", FixedRateStubCalculation.class, CurrencyAmount.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"fixedRate", "knownAmount"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 747425396: {
                    return this.fixedRate;
                }
                case -158727813: {
                    return this.knownAmount;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FixedRateStubCalculation> builder() {
            return new Builder();
        }

        public Class<? extends FixedRateStubCalculation> beanType() {
            return FixedRateStubCalculation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<CurrencyAmount> knownAmount() {
            return this.knownAmount;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 747425396: {
                    return ((FixedRateStubCalculation)bean).fixedRate;
                }
                case -158727813: {
                    return ((FixedRateStubCalculation)bean).knownAmount;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

