/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FutureValueNotional
implements ImmutableBean,
Serializable {
    private static final FutureValueNotional AUTO = FutureValueNotional.builder().build();
    @PropertyDefinition(get="optional")
    private final Double value;
    @PropertyDefinition(get="optional")
    private final LocalDate valueDate;
    @PropertyDefinition(get="optional")
    private final Integer dayCountDays;
    private static final long serialVersionUID = 1L;

    public static FutureValueNotional autoCalculate() {
        return AUTO;
    }

    public static FutureValueNotional of(double value, LocalDate valueDate, int dayCountDays) {
        ArgChecker.isTrue((valueDate != null ? 1 : 0) != 0);
        return new FutureValueNotional(value, valueDate, dayCountDays);
    }

    public static FutureValueNotional of(double value) {
        return new FutureValueNotional(value, null, null);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FutureValueNotional(Double value, LocalDate valueDate, Integer dayCountDays) {
        this.value = value;
        this.valueDate = valueDate;
        this.dayCountDays = dayCountDays;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public OptionalDouble getValue() {
        return this.value != null ? OptionalDouble.of(this.value) : OptionalDouble.empty();
    }

    public Optional<LocalDate> getValueDate() {
        return Optional.ofNullable(this.valueDate);
    }

    public OptionalInt getDayCountDays() {
        return this.dayCountDays != null ? OptionalInt.of(this.dayCountDays) : OptionalInt.empty();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FutureValueNotional other = (FutureValueNotional)obj;
            return JodaBeanUtils.equal((Object)this.value, (Object)other.value) && JodaBeanUtils.equal((Object)this.valueDate, (Object)other.valueDate) && JodaBeanUtils.equal((Object)this.dayCountDays, (Object)other.dayCountDays);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valueDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCountDays);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("FutureValueNotional{");
        buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
        buf.append("valueDate").append('=').append(JodaBeanUtils.toString((Object)this.valueDate)).append(',').append(' ');
        buf.append("dayCountDays").append('=').append(JodaBeanUtils.toString((Object)this.dayCountDays));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FutureValueNotional> {
        private Double value;
        private LocalDate valueDate;
        private Integer dayCountDays;

        private Builder() {
        }

        private Builder(FutureValueNotional beanToCopy) {
            this.value = beanToCopy.value;
            this.valueDate = beanToCopy.valueDate;
            this.dayCountDays = beanToCopy.dayCountDays;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case -766192449: {
                    return this.valueDate;
                }
                case -1430289974: {
                    return this.dayCountDays;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = (Double)newValue;
                    break;
                }
                case -766192449: {
                    this.valueDate = (LocalDate)newValue;
                    break;
                }
                case -1430289974: {
                    this.dayCountDays = (Integer)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FutureValueNotional build() {
            return new FutureValueNotional(this.value, this.valueDate, this.dayCountDays);
        }

        public Builder value(Double value) {
            this.value = value;
            return this;
        }

        public Builder valueDate(LocalDate valueDate) {
            this.valueDate = valueDate;
            return this;
        }

        public Builder dayCountDays(Integer dayCountDays) {
            this.dayCountDays = dayCountDays;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("FutureValueNotional.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
            buf.append("valueDate").append('=').append(JodaBeanUtils.toString((Object)this.valueDate)).append(',').append(' ');
            buf.append("dayCountDays").append('=').append(JodaBeanUtils.toString((Object)this.dayCountDays));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", FutureValueNotional.class, Double.class);
        private final MetaProperty<LocalDate> valueDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valueDate", FutureValueNotional.class, LocalDate.class);
        private final MetaProperty<Integer> dayCountDays = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCountDays", FutureValueNotional.class, Integer.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value", "valueDate", "dayCountDays"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case -766192449: {
                    return this.valueDate;
                }
                case -1430289974: {
                    return this.dayCountDays;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FutureValueNotional> beanType() {
            return FutureValueNotional.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> value() {
            return this.value;
        }

        public MetaProperty<LocalDate> valueDate() {
            return this.valueDate;
        }

        public MetaProperty<Integer> dayCountDays() {
            return this.dayCountDays;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((FutureValueNotional)bean).value;
                }
                case -766192449: {
                    return ((FutureValueNotional)bean).valueDate;
                }
                case -1430289974: {
                    return ((FutureValueNotional)bean).dayCountDays;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

