/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxReset
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final FxIndexObservation observation;
    @PropertyDefinition(validate="notNull")
    private final Currency referenceCurrency;
    private static final long serialVersionUID = 1L;

    public static FxReset of(FxIndexObservation observation, Currency referenceCurrency) {
        return new FxReset(observation, referenceCurrency);
    }

    @ImmutableValidator
    private void validate() {
        FxIndex index = this.observation.getIndex();
        if (!index.getCurrencyPair().contains(this.referenceCurrency)) {
            throw new IllegalArgumentException(Messages.format((String)"Reference currency {} must be one of those in the FxIndex {}", (Object[])new Object[]{this.referenceCurrency, index}));
        }
    }

    public FxIndex getIndex() {
        return this.observation.getIndex();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxReset(FxIndexObservation observation, Currency referenceCurrency) {
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        JodaBeanUtils.notNull((Object)referenceCurrency, (String)"referenceCurrency");
        this.observation = observation;
        this.referenceCurrency = referenceCurrency;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FxIndexObservation getObservation() {
        return this.observation;
    }

    public Currency getReferenceCurrency() {
        return this.referenceCurrency;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxReset other = (FxReset)obj;
            return JodaBeanUtils.equal((Object)this.observation, (Object)other.observation) && JodaBeanUtils.equal((Object)this.referenceCurrency, (Object)other.referenceCurrency);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.referenceCurrency);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("FxReset{");
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
        buf.append("referenceCurrency").append('=').append(JodaBeanUtils.toString((Object)this.referenceCurrency));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxReset> {
        private FxIndexObservation observation;
        private Currency referenceCurrency;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 727652476: {
                    return this.referenceCurrency;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    this.observation = (FxIndexObservation)newValue;
                    break;
                }
                case 727652476: {
                    this.referenceCurrency = (Currency)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxReset build() {
            return new FxReset(this.observation, this.referenceCurrency);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("FxReset.Builder{");
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
            buf.append("referenceCurrency").append('=').append(JodaBeanUtils.toString((Object)this.referenceCurrency));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", FxReset.class, FxIndexObservation.class);
        private final MetaProperty<Currency> referenceCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"referenceCurrency", FxReset.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observation", "referenceCurrency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 727652476: {
                    return this.referenceCurrency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxReset> builder() {
            return new Builder();
        }

        public Class<? extends FxReset> beanType() {
            return FxReset.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxIndexObservation> observation() {
            return this.observation;
        }

        public MetaProperty<Currency> referenceCurrency() {
            return this.referenceCurrency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return ((FxReset)bean).getObservation();
                }
                case 727652476: {
                    return ((FxReset)bean).getReferenceCurrency();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

