/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.swap.FxReset;
import com.opengamma.strata.product.swap.FxResetFixingRelativeTo;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FxResetCalculation
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final FxIndex index;
    @PropertyDefinition(validate="notNull")
    private final Currency referenceCurrency;
    @PropertyDefinition(validate="notNull")
    private final FxResetFixingRelativeTo fixingRelativeTo;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment fixingDateOffset;
    @PropertyDefinition(get="optional")
    private final Double initialNotionalValue;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.fixingRelativeTo(FxResetFixingRelativeTo.PERIOD_START);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.fixingDateOffset == null && builder.index != null) {
            builder.fixingDateOffset = builder.index.getFixingDateOffset();
        }
    }

    @ImmutableValidator
    private void validate() {
        if (!this.index.getCurrencyPair().contains(this.referenceCurrency)) {
            throw new IllegalArgumentException(Messages.format((String)"Reference currency {} must be one of those in the FxIndex {}", (Object[])new Object[]{this.referenceCurrency, this.index}));
        }
    }

    public BiFunction<Integer, SchedulePeriod, Optional<FxReset>> resolve(ReferenceData refData) {
        DateAdjuster fixingDateAdjuster = this.fixingDateOffset.resolve(refData);
        Function obsFn = this.index.resolve(refData);
        return (periodIndex, period) -> this.buildFxReset((int)periodIndex, (SchedulePeriod)period, fixingDateAdjuster, obsFn);
    }

    private Optional<FxReset> buildFxReset(int periodIndex, SchedulePeriod period, DateAdjuster fixingDateAdjuster, Function<LocalDate, FxIndexObservation> obsFn) {
        if (periodIndex == 0 && this.initialNotionalValue != null) {
            return Optional.empty();
        }
        LocalDate fixingDate = fixingDateAdjuster.adjust(this.fixingRelativeTo.selectBaseDate(period));
        return Optional.of(FxReset.of(obsFn.apply(fixingDate), this.referenceCurrency));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FxResetCalculation(FxIndex index, Currency referenceCurrency, FxResetFixingRelativeTo fixingRelativeTo, DaysAdjustment fixingDateOffset, Double initialNotionalValue) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)referenceCurrency, (String)"referenceCurrency");
        JodaBeanUtils.notNull((Object)((Object)fixingRelativeTo), (String)"fixingRelativeTo");
        JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
        this.index = index;
        this.referenceCurrency = referenceCurrency;
        this.fixingRelativeTo = fixingRelativeTo;
        this.fixingDateOffset = fixingDateOffset;
        this.initialNotionalValue = initialNotionalValue;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FxIndex getIndex() {
        return this.index;
    }

    public Currency getReferenceCurrency() {
        return this.referenceCurrency;
    }

    public FxResetFixingRelativeTo getFixingRelativeTo() {
        return this.fixingRelativeTo;
    }

    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset;
    }

    public OptionalDouble getInitialNotionalValue() {
        return this.initialNotionalValue != null ? OptionalDouble.of(this.initialNotionalValue) : OptionalDouble.empty();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxResetCalculation other = (FxResetCalculation)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.referenceCurrency, (Object)other.referenceCurrency) && JodaBeanUtils.equal((Object)((Object)this.fixingRelativeTo), (Object)((Object)other.fixingRelativeTo)) && JodaBeanUtils.equal((Object)this.fixingDateOffset, (Object)other.fixingDateOffset) && JodaBeanUtils.equal((Object)this.initialNotionalValue, (Object)other.initialNotionalValue);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.referenceCurrency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.fixingRelativeTo));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.initialNotionalValue);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("FxResetCalculation{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("referenceCurrency").append('=').append(JodaBeanUtils.toString((Object)this.referenceCurrency)).append(',').append(' ');
        buf.append("fixingRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fixingRelativeTo))).append(',').append(' ');
        buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
        buf.append("initialNotionalValue").append('=').append(JodaBeanUtils.toString((Object)this.initialNotionalValue));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FxResetCalculation> {
        private FxIndex index;
        private Currency referenceCurrency;
        private FxResetFixingRelativeTo fixingRelativeTo;
        private DaysAdjustment fixingDateOffset;
        private Double initialNotionalValue;

        private Builder() {
            FxResetCalculation.applyDefaults(this);
        }

        private Builder(FxResetCalculation beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.referenceCurrency = beanToCopy.getReferenceCurrency();
            this.fixingRelativeTo = beanToCopy.getFixingRelativeTo();
            this.fixingDateOffset = beanToCopy.getFixingDateOffset();
            this.initialNotionalValue = beanToCopy.initialNotionalValue;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 727652476: {
                    return this.referenceCurrency;
                }
                case 232554996: {
                    return this.fixingRelativeTo;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case -931164883: {
                    return this.initialNotionalValue;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (FxIndex)newValue;
                    break;
                }
                case 727652476: {
                    this.referenceCurrency = (Currency)newValue;
                    break;
                }
                case 232554996: {
                    this.fixingRelativeTo = (FxResetFixingRelativeTo)((Object)newValue);
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -931164883: {
                    this.initialNotionalValue = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FxResetCalculation build() {
            FxResetCalculation.preBuild(this);
            return new FxResetCalculation(this.index, this.referenceCurrency, this.fixingRelativeTo, this.fixingDateOffset, this.initialNotionalValue);
        }

        public Builder index(FxIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder referenceCurrency(Currency referenceCurrency) {
            JodaBeanUtils.notNull((Object)referenceCurrency, (String)"referenceCurrency");
            this.referenceCurrency = referenceCurrency;
            return this;
        }

        public Builder fixingRelativeTo(FxResetFixingRelativeTo fixingRelativeTo) {
            JodaBeanUtils.notNull((Object)((Object)fixingRelativeTo), (String)"fixingRelativeTo");
            this.fixingRelativeTo = fixingRelativeTo;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public Builder initialNotionalValue(Double initialNotionalValue) {
            this.initialNotionalValue = initialNotionalValue;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("FxResetCalculation.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("referenceCurrency").append('=').append(JodaBeanUtils.toString((Object)this.referenceCurrency)).append(',').append(' ');
            buf.append("fixingRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fixingRelativeTo))).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
            buf.append("initialNotionalValue").append('=').append(JodaBeanUtils.toString((Object)this.initialNotionalValue));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", FxResetCalculation.class, FxIndex.class);
        private final MetaProperty<Currency> referenceCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"referenceCurrency", FxResetCalculation.class, Currency.class);
        private final MetaProperty<FxResetFixingRelativeTo> fixingRelativeTo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingRelativeTo", FxResetCalculation.class, FxResetFixingRelativeTo.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", FxResetCalculation.class, DaysAdjustment.class);
        private final MetaProperty<Double> initialNotionalValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"initialNotionalValue", FxResetCalculation.class, Double.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "referenceCurrency", "fixingRelativeTo", "fixingDateOffset", "initialNotionalValue"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 727652476: {
                    return this.referenceCurrency;
                }
                case 232554996: {
                    return this.fixingRelativeTo;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case -931164883: {
                    return this.initialNotionalValue;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FxResetCalculation> beanType() {
            return FxResetCalculation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxIndex> index() {
            return this.index;
        }

        public MetaProperty<Currency> referenceCurrency() {
            return this.referenceCurrency;
        }

        public MetaProperty<FxResetFixingRelativeTo> fixingRelativeTo() {
            return this.fixingRelativeTo;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        public MetaProperty<Double> initialNotionalValue() {
            return this.initialNotionalValue;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((FxResetCalculation)bean).getIndex();
                }
                case 727652476: {
                    return ((FxResetCalculation)bean).getReferenceCurrency();
                }
                case 232554996: {
                    return ((FxResetCalculation)bean).getFixingRelativeTo();
                }
                case 873743726: {
                    return ((FxResetCalculation)bean).getFixingDateOffset();
                }
                case -931164883: {
                    return ((FxResetCalculation)bean).initialNotionalValue;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

