/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxResetNotionalExchange
implements SwapPaymentEvent,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmount notionalAmount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate paymentDate;
    @PropertyDefinition(validate="notNull")
    private final FxIndexObservation observation;
    private static final long serialVersionUID = 1L;

    public static FxResetNotionalExchange of(CurrencyAmount notionalAmount, LocalDate paymentDate, FxIndexObservation observation) {
        return new FxResetNotionalExchange(notionalAmount, paymentDate, observation);
    }

    @ImmutableValidator
    private void validate() {
        FxIndex index = this.observation.getIndex();
        if (!index.getCurrencyPair().contains(this.notionalAmount.getCurrency())) {
            throw new IllegalArgumentException(Messages.format((String)"Reference currency {} must be one of those in the FxIndex {}", (Object[])new Object[]{this.notionalAmount.getCurrency(), index}));
        }
    }

    @Override
    public Currency getCurrency() {
        FxIndex index = this.observation.getIndex();
        Currency indexBase = index.getCurrencyPair().getBase();
        Currency indexCounter = index.getCurrencyPair().getCounter();
        return this.getReferenceCurrency().equals((Object)indexBase) ? indexCounter : indexBase;
    }

    public Currency getReferenceCurrency() {
        return this.notionalAmount.getCurrency();
    }

    public double getNotional() {
        return this.getNotionalAmount().getAmount();
    }

    @Override
    public FxResetNotionalExchange adjustPaymentDate(TemporalAdjuster adjuster) {
        LocalDate adjusted = this.paymentDate.with(adjuster);
        return adjusted.equals(this.paymentDate) ? this : new FxResetNotionalExchange(this.notionalAmount, adjusted, this.observation);
    }

    @Override
    public boolean isKnownAmountAt(LocalDate date) {
        return !this.observation.getFixingDate().isAfter(date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxResetNotionalExchange(CurrencyAmount notionalAmount, LocalDate paymentDate, FxIndexObservation observation) {
        JodaBeanUtils.notNull((Object)notionalAmount, (String)"notionalAmount");
        JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        this.notionalAmount = notionalAmount;
        this.paymentDate = paymentDate;
        this.observation = observation;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyAmount getNotionalAmount() {
        return this.notionalAmount;
    }

    @Override
    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public FxIndexObservation getObservation() {
        return this.observation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxResetNotionalExchange other = (FxResetNotionalExchange)obj;
            return JodaBeanUtils.equal((Object)this.notionalAmount, (Object)other.notionalAmount) && JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate) && JodaBeanUtils.equal((Object)this.observation, (Object)other.observation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.notionalAmount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("FxResetNotionalExchange{");
        buf.append("notionalAmount").append('=').append(JodaBeanUtils.toString((Object)this.notionalAmount)).append(',').append(' ');
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxResetNotionalExchange> {
        private CurrencyAmount notionalAmount;
        private LocalDate paymentDate;
        private FxIndexObservation observation;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -902123592: {
                    return this.notionalAmount;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case 122345516: {
                    return this.observation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -902123592: {
                    this.notionalAmount = (CurrencyAmount)newValue;
                    break;
                }
                case -1540873516: {
                    this.paymentDate = (LocalDate)newValue;
                    break;
                }
                case 122345516: {
                    this.observation = (FxIndexObservation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxResetNotionalExchange build() {
            return new FxResetNotionalExchange(this.notionalAmount, this.paymentDate, this.observation);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("FxResetNotionalExchange.Builder{");
            buf.append("notionalAmount").append('=').append(JodaBeanUtils.toString((Object)this.notionalAmount)).append(',').append(' ');
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyAmount> notionalAmount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notionalAmount", FxResetNotionalExchange.class, CurrencyAmount.class);
        private final MetaProperty<LocalDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", FxResetNotionalExchange.class, LocalDate.class);
        private final MetaProperty<FxIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", FxResetNotionalExchange.class, FxIndexObservation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"notionalAmount", "paymentDate", "observation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -902123592: {
                    return this.notionalAmount;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case 122345516: {
                    return this.observation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxResetNotionalExchange> builder() {
            return new Builder();
        }

        public Class<? extends FxResetNotionalExchange> beanType() {
            return FxResetNotionalExchange.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyAmount> notionalAmount() {
            return this.notionalAmount;
        }

        public MetaProperty<LocalDate> paymentDate() {
            return this.paymentDate;
        }

        public MetaProperty<FxIndexObservation> observation() {
            return this.observation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -902123592: {
                    return ((FxResetNotionalExchange)bean).getNotionalAmount();
                }
                case -1540873516: {
                    return ((FxResetNotionalExchange)bean).getPaymentDate();
                }
                case 122345516: {
                    return ((FxResetNotionalExchange)bean).getObservation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

