/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.product.rate.FixedRateComputation;
import com.opengamma.strata.product.rate.IborAveragedFixing;
import com.opengamma.strata.product.rate.IborAveragedRateComputation;
import com.opengamma.strata.product.rate.IborRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.FixingRelativeTo;
import com.opengamma.strata.product.swap.IborRateResetMethod;
import com.opengamma.strata.product.swap.IborRateStubCalculation;
import com.opengamma.strata.product.swap.NegativeRateMethod;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RateCalculation;
import com.opengamma.strata.product.swap.ResetSchedule;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborRateCalculation
implements RateCalculation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final IborIndex index;
    @PropertyDefinition(get="optional")
    private final ResetSchedule resetPeriods;
    @PropertyDefinition(validate="notNull")
    private final FixingRelativeTo fixingRelativeTo;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment fixingDateOffset;
    @PropertyDefinition(validate="notNull")
    private final NegativeRateMethod negativeRateMethod;
    @PropertyDefinition(get="optional")
    private final Double firstRegularRate;
    @PropertyDefinition(get="optional")
    private final Double firstRate;
    @PropertyDefinition(get="optional")
    private final DaysAdjustment firstFixingDateOffset;
    @PropertyDefinition(get="optional")
    private final IborRateStubCalculation initialStub;
    @PropertyDefinition(get="optional")
    private final IborRateStubCalculation finalStub;
    @PropertyDefinition(get="optional")
    private final ValueSchedule gearing;
    @PropertyDefinition(get="optional")
    private final ValueSchedule spread;
    private static final long serialVersionUID = 1L;

    public static IborRateCalculation of(IborIndex index) {
        return IborRateCalculation.builder().index(index).build();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.fixingRelativeTo(FixingRelativeTo.PERIOD_START);
        builder.negativeRateMethod(NegativeRateMethod.ALLOW_NEGATIVE);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null) {
            if (builder.dayCount == null) {
                builder.dayCount = builder.index.getDayCount();
            }
            if (builder.fixingDateOffset == null) {
                builder.fixingDateOffset = builder.index.getFixingDateOffset();
            }
        }
    }

    @Override
    public SwapLegType getType() {
        return SwapLegType.IBOR;
    }

    @Override
    public void collectCurrencies(ImmutableSet.Builder<Currency> builder) {
        builder.add((Object)this.index.getCurrency());
        this.getInitialStub().ifPresent(stub -> stub.collectCurrencies(builder));
        this.getFinalStub().ifPresent(stub -> stub.collectCurrencies(builder));
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.index);
        this.getInitialStub().ifPresent(stub -> stub.collectIndices(builder));
        this.getFinalStub().ifPresent(stub -> stub.collectIndices(builder));
    }

    @Override
    public ImmutableList<RateAccrualPeriod> createAccrualPeriods(Schedule accrualSchedule, Schedule paymentSchedule, ReferenceData refData) {
        DoubleArray resolvedGearings = ((ValueSchedule)MoreObjects.firstNonNull((Object)this.gearing, (Object)ValueSchedule.ALWAYS_1)).resolveValues(accrualSchedule);
        DoubleArray resolvedSpreads = ((ValueSchedule)MoreObjects.firstNonNull((Object)this.spread, (Object)ValueSchedule.ALWAYS_0)).resolveValues(accrualSchedule);
        DateAdjuster fixingDateAdjuster = this.fixingDateOffset.resolve(refData);
        Function resetScheduleFn = this.getResetPeriods().map(rp -> accrualSchedule.getFrequency().isMonthBased() && rp.getResetFrequency().isWeekBased() ? rp.createSchedule(RollConventions.NONE, refData, true) : rp.createSchedule(accrualSchedule.getRollConvention(), refData, false)).orElse(null);
        Function iborObservationFn = this.index.resolve(refData);
        Pair scheduleStubs = accrualSchedule.getStubs(this.initialStub == null && this.finalStub != null);
        Optional scheduleInitialStub = (Optional)scheduleStubs.getFirst();
        Optional scheduleFinalStub = (Optional)scheduleStubs.getSecond();
        ImmutableList.Builder accrualPeriods = ImmutableList.builder();
        for (int i = 0; i < accrualSchedule.size(); ++i) {
            SchedulePeriod period = accrualSchedule.getPeriod(i);
            RateComputation rateComputation = this.createRateComputation(period, fixingDateAdjuster, resetScheduleFn, iborObservationFn, i, scheduleInitialStub, scheduleFinalStub, refData);
            double yearFraction = period.yearFraction(this.dayCount, accrualSchedule);
            accrualPeriods.add((Object)new RateAccrualPeriod(period, yearFraction, rateComputation, resolvedGearings.get(i), resolvedSpreads.get(i), this.negativeRateMethod));
        }
        return accrualPeriods.build();
    }

    private RateComputation createRateComputation(SchedulePeriod period, DateAdjuster fixingDateAdjuster, Function<SchedulePeriod, Schedule> resetScheduleFn, Function<LocalDate, IborIndexObservation> iborObservationFn, int scheduleIndex, Optional<SchedulePeriod> scheduleInitialStub, Optional<SchedulePeriod> scheduleFinalStub, ReferenceData refData) {
        LocalDate fixingDate = fixingDateAdjuster.adjust(this.fixingRelativeTo.selectBaseDate(period));
        if (scheduleIndex == 0 && this.firstFixingDateOffset != null) {
            fixingDate = this.firstFixingDateOffset.resolve(refData).adjust(this.fixingRelativeTo.selectBaseDate(period));
        }
        if (scheduleInitialStub.isPresent() && scheduleIndex == 0) {
            if (this.firstRate != null && this.firstRegularRate == null && (this.initialStub == null || IborRateStubCalculation.NONE.equals(this.initialStub))) {
                return FixedRateComputation.of(this.firstRate);
            }
            return ((IborRateStubCalculation)MoreObjects.firstNonNull((Object)this.initialStub, (Object)IborRateStubCalculation.NONE)).createRateComputation(fixingDate, this.index, refData);
        }
        if (scheduleFinalStub.isPresent() && scheduleFinalStub.get() == period) {
            return ((IborRateStubCalculation)MoreObjects.firstNonNull((Object)this.finalStub, (Object)IborRateStubCalculation.NONE)).createRateComputation(fixingDate, this.index, refData);
        }
        Double overrideFirstRate = null;
        if (this.firstRegularRate != null) {
            if (this.isFirstRegularPeriod(scheduleIndex, scheduleInitialStub.isPresent())) {
                overrideFirstRate = this.firstRegularRate;
            }
        } else if (this.firstRate != null && scheduleIndex == 0) {
            overrideFirstRate = this.firstRate;
        }
        if (resetScheduleFn != null) {
            return this.createRateComputationWithResetPeriods(resetScheduleFn.apply(period), fixingDateAdjuster, iborObservationFn, scheduleIndex, overrideFirstRate, refData);
        }
        if (overrideFirstRate != null) {
            return FixedRateComputation.of(overrideFirstRate);
        }
        return IborRateComputation.of(iborObservationFn.apply(fixingDate));
    }

    private RateComputation createRateComputationWithResetPeriods(Schedule resetSchedule, DateAdjuster fixingDateAdjuster, Function<LocalDate, IborIndexObservation> iborObservationFn, int scheduleIndex, Double overrideFirstRate, ReferenceData refData) {
        ArrayList<IborAveragedFixing> fixings = new ArrayList<IborAveragedFixing>();
        for (int i = 0; i < resetSchedule.size(); ++i) {
            SchedulePeriod resetPeriod = resetSchedule.getPeriod(i);
            LocalDate fixingDate = fixingDateAdjuster.adjust(this.fixingRelativeTo.selectBaseDate(resetPeriod));
            if (scheduleIndex == 0 && i == 0 && this.firstFixingDateOffset != null) {
                fixingDate = this.firstFixingDateOffset.resolve(refData).adjust(this.fixingRelativeTo.selectBaseDate(resetPeriod));
            }
            fixings.add(IborAveragedFixing.builder().observation(iborObservationFn.apply(fixingDate)).fixedRate(overrideFirstRate != null && i == 0 ? overrideFirstRate : null).weight(this.resetPeriods.getResetMethod() == IborRateResetMethod.UNWEIGHTED ? 1.0 : (double)resetPeriod.lengthInDays()).build());
        }
        return IborAveragedRateComputation.of(fixings);
    }

    private boolean isFirstRegularPeriod(int scheduleIndex, boolean hasInitialStub) {
        if (hasInitialStub) {
            return scheduleIndex == 1;
        }
        return scheduleIndex == 0;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IborRateCalculation(DayCount dayCount, IborIndex index, ResetSchedule resetPeriods, FixingRelativeTo fixingRelativeTo, DaysAdjustment fixingDateOffset, NegativeRateMethod negativeRateMethod, Double firstRegularRate, Double firstRate, DaysAdjustment firstFixingDateOffset, IborRateStubCalculation initialStub, IborRateStubCalculation finalStub, ValueSchedule gearing, ValueSchedule spread) {
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)((Object)fixingRelativeTo), (String)"fixingRelativeTo");
        JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
        JodaBeanUtils.notNull((Object)((Object)negativeRateMethod), (String)"negativeRateMethod");
        this.dayCount = dayCount;
        this.index = index;
        this.resetPeriods = resetPeriods;
        this.fixingRelativeTo = fixingRelativeTo;
        this.fixingDateOffset = fixingDateOffset;
        this.negativeRateMethod = negativeRateMethod;
        this.firstRegularRate = firstRegularRate;
        this.firstRate = firstRate;
        this.firstFixingDateOffset = firstFixingDateOffset;
        this.initialStub = initialStub;
        this.finalStub = finalStub;
        this.gearing = gearing;
        this.spread = spread;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public IborIndex getIndex() {
        return this.index;
    }

    public Optional<ResetSchedule> getResetPeriods() {
        return Optional.ofNullable(this.resetPeriods);
    }

    public FixingRelativeTo getFixingRelativeTo() {
        return this.fixingRelativeTo;
    }

    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset;
    }

    public NegativeRateMethod getNegativeRateMethod() {
        return this.negativeRateMethod;
    }

    public OptionalDouble getFirstRegularRate() {
        return this.firstRegularRate != null ? OptionalDouble.of(this.firstRegularRate) : OptionalDouble.empty();
    }

    public OptionalDouble getFirstRate() {
        return this.firstRate != null ? OptionalDouble.of(this.firstRate) : OptionalDouble.empty();
    }

    public Optional<DaysAdjustment> getFirstFixingDateOffset() {
        return Optional.ofNullable(this.firstFixingDateOffset);
    }

    public Optional<IborRateStubCalculation> getInitialStub() {
        return Optional.ofNullable(this.initialStub);
    }

    public Optional<IborRateStubCalculation> getFinalStub() {
        return Optional.ofNullable(this.finalStub);
    }

    public Optional<ValueSchedule> getGearing() {
        return Optional.ofNullable(this.gearing);
    }

    public Optional<ValueSchedule> getSpread() {
        return Optional.ofNullable(this.spread);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborRateCalculation other = (IborRateCalculation)obj;
            return JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.resetPeriods, (Object)other.resetPeriods) && JodaBeanUtils.equal((Object)((Object)this.fixingRelativeTo), (Object)((Object)other.fixingRelativeTo)) && JodaBeanUtils.equal((Object)this.fixingDateOffset, (Object)other.fixingDateOffset) && JodaBeanUtils.equal((Object)((Object)this.negativeRateMethod), (Object)((Object)other.negativeRateMethod)) && JodaBeanUtils.equal((Object)this.firstRegularRate, (Object)other.firstRegularRate) && JodaBeanUtils.equal((Object)this.firstRate, (Object)other.firstRate) && JodaBeanUtils.equal((Object)this.firstFixingDateOffset, (Object)other.firstFixingDateOffset) && JodaBeanUtils.equal((Object)this.initialStub, (Object)other.initialStub) && JodaBeanUtils.equal((Object)this.finalStub, (Object)other.finalStub) && JodaBeanUtils.equal((Object)this.gearing, (Object)other.gearing) && JodaBeanUtils.equal((Object)this.spread, (Object)other.spread);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.resetPeriods);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.fixingRelativeTo));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.negativeRateMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstRegularRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstFixingDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.initialStub);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.finalStub);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.gearing);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spread);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(448);
        buf.append("IborRateCalculation{");
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("resetPeriods").append('=').append(JodaBeanUtils.toString((Object)this.resetPeriods)).append(',').append(' ');
        buf.append("fixingRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fixingRelativeTo))).append(',').append(' ');
        buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
        buf.append("negativeRateMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.negativeRateMethod))).append(',').append(' ');
        buf.append("firstRegularRate").append('=').append(JodaBeanUtils.toString((Object)this.firstRegularRate)).append(',').append(' ');
        buf.append("firstRate").append('=').append(JodaBeanUtils.toString((Object)this.firstRate)).append(',').append(' ');
        buf.append("firstFixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.firstFixingDateOffset)).append(',').append(' ');
        buf.append("initialStub").append('=').append(JodaBeanUtils.toString((Object)this.initialStub)).append(',').append(' ');
        buf.append("finalStub").append('=').append(JodaBeanUtils.toString((Object)this.finalStub)).append(',').append(' ');
        buf.append("gearing").append('=').append(JodaBeanUtils.toString((Object)this.gearing)).append(',').append(' ');
        buf.append("spread").append('=').append(JodaBeanUtils.toString((Object)this.spread));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborRateCalculation> {
        private DayCount dayCount;
        private IborIndex index;
        private ResetSchedule resetPeriods;
        private FixingRelativeTo fixingRelativeTo;
        private DaysAdjustment fixingDateOffset;
        private NegativeRateMethod negativeRateMethod;
        private Double firstRegularRate;
        private Double firstRate;
        private DaysAdjustment firstFixingDateOffset;
        private IborRateStubCalculation initialStub;
        private IborRateStubCalculation finalStub;
        private ValueSchedule gearing;
        private ValueSchedule spread;

        private Builder() {
            IborRateCalculation.applyDefaults(this);
        }

        private Builder(IborRateCalculation beanToCopy) {
            this.dayCount = beanToCopy.getDayCount();
            this.index = beanToCopy.getIndex();
            this.resetPeriods = beanToCopy.resetPeriods;
            this.fixingRelativeTo = beanToCopy.getFixingRelativeTo();
            this.fixingDateOffset = beanToCopy.getFixingDateOffset();
            this.negativeRateMethod = beanToCopy.getNegativeRateMethod();
            this.firstRegularRate = beanToCopy.firstRegularRate;
            this.firstRate = beanToCopy.firstRate;
            this.firstFixingDateOffset = beanToCopy.firstFixingDateOffset;
            this.initialStub = beanToCopy.initialStub;
            this.finalStub = beanToCopy.finalStub;
            this.gearing = beanToCopy.gearing;
            this.spread = beanToCopy.spread;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return this.dayCount;
                }
                case 100346066: {
                    return this.index;
                }
                case -1272973693: {
                    return this.resetPeriods;
                }
                case 232554996: {
                    return this.fixingRelativeTo;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1969081334: {
                    return this.negativeRateMethod;
                }
                case 570227148: {
                    return this.firstRegularRate;
                }
                case 132955056: {
                    return this.firstRate;
                }
                case 2022439998: {
                    return this.firstFixingDateOffset;
                }
                case 1233359378: {
                    return this.initialStub;
                }
                case 355242820: {
                    return this.finalStub;
                }
                case -91774989: {
                    return this.gearing;
                }
                case -895684237: {
                    return this.spread;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -1272973693: {
                    this.resetPeriods = (ResetSchedule)newValue;
                    break;
                }
                case 232554996: {
                    this.fixingRelativeTo = (FixingRelativeTo)((Object)newValue);
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1969081334: {
                    this.negativeRateMethod = (NegativeRateMethod)((Object)newValue);
                    break;
                }
                case 570227148: {
                    this.firstRegularRate = (Double)newValue;
                    break;
                }
                case 132955056: {
                    this.firstRate = (Double)newValue;
                    break;
                }
                case 2022439998: {
                    this.firstFixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1233359378: {
                    this.initialStub = (IborRateStubCalculation)newValue;
                    break;
                }
                case 355242820: {
                    this.finalStub = (IborRateStubCalculation)newValue;
                    break;
                }
                case -91774989: {
                    this.gearing = (ValueSchedule)newValue;
                    break;
                }
                case -895684237: {
                    this.spread = (ValueSchedule)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborRateCalculation build() {
            IborRateCalculation.preBuild(this);
            return new IborRateCalculation(this.dayCount, this.index, this.resetPeriods, this.fixingRelativeTo, this.fixingDateOffset, this.negativeRateMethod, this.firstRegularRate, this.firstRate, this.firstFixingDateOffset, this.initialStub, this.finalStub, this.gearing, this.spread);
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder resetPeriods(ResetSchedule resetPeriods) {
            this.resetPeriods = resetPeriods;
            return this;
        }

        public Builder fixingRelativeTo(FixingRelativeTo fixingRelativeTo) {
            JodaBeanUtils.notNull((Object)((Object)fixingRelativeTo), (String)"fixingRelativeTo");
            this.fixingRelativeTo = fixingRelativeTo;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public Builder negativeRateMethod(NegativeRateMethod negativeRateMethod) {
            JodaBeanUtils.notNull((Object)((Object)negativeRateMethod), (String)"negativeRateMethod");
            this.negativeRateMethod = negativeRateMethod;
            return this;
        }

        public Builder firstRegularRate(Double firstRegularRate) {
            this.firstRegularRate = firstRegularRate;
            return this;
        }

        public Builder firstRate(Double firstRate) {
            this.firstRate = firstRate;
            return this;
        }

        public Builder firstFixingDateOffset(DaysAdjustment firstFixingDateOffset) {
            this.firstFixingDateOffset = firstFixingDateOffset;
            return this;
        }

        public Builder initialStub(IborRateStubCalculation initialStub) {
            this.initialStub = initialStub;
            return this;
        }

        public Builder finalStub(IborRateStubCalculation finalStub) {
            this.finalStub = finalStub;
            return this;
        }

        public Builder gearing(ValueSchedule gearing) {
            this.gearing = gearing;
            return this;
        }

        public Builder spread(ValueSchedule spread) {
            this.spread = spread;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(448);
            buf.append("IborRateCalculation.Builder{");
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("resetPeriods").append('=').append(JodaBeanUtils.toString((Object)this.resetPeriods)).append(',').append(' ');
            buf.append("fixingRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fixingRelativeTo))).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
            buf.append("negativeRateMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.negativeRateMethod))).append(',').append(' ');
            buf.append("firstRegularRate").append('=').append(JodaBeanUtils.toString((Object)this.firstRegularRate)).append(',').append(' ');
            buf.append("firstRate").append('=').append(JodaBeanUtils.toString((Object)this.firstRate)).append(',').append(' ');
            buf.append("firstFixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.firstFixingDateOffset)).append(',').append(' ');
            buf.append("initialStub").append('=').append(JodaBeanUtils.toString((Object)this.initialStub)).append(',').append(' ');
            buf.append("finalStub").append('=').append(JodaBeanUtils.toString((Object)this.finalStub)).append(',').append(' ');
            buf.append("gearing").append('=').append(JodaBeanUtils.toString((Object)this.gearing)).append(',').append(' ');
            buf.append("spread").append('=').append(JodaBeanUtils.toString((Object)this.spread));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", IborRateCalculation.class, DayCount.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", IborRateCalculation.class, IborIndex.class);
        private final MetaProperty<ResetSchedule> resetPeriods = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"resetPeriods", IborRateCalculation.class, ResetSchedule.class);
        private final MetaProperty<FixingRelativeTo> fixingRelativeTo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingRelativeTo", IborRateCalculation.class, FixingRelativeTo.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", IborRateCalculation.class, DaysAdjustment.class);
        private final MetaProperty<NegativeRateMethod> negativeRateMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"negativeRateMethod", IborRateCalculation.class, NegativeRateMethod.class);
        private final MetaProperty<Double> firstRegularRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstRegularRate", IborRateCalculation.class, Double.class);
        private final MetaProperty<Double> firstRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstRate", IborRateCalculation.class, Double.class);
        private final MetaProperty<DaysAdjustment> firstFixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstFixingDateOffset", IborRateCalculation.class, DaysAdjustment.class);
        private final MetaProperty<IborRateStubCalculation> initialStub = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"initialStub", IborRateCalculation.class, IborRateStubCalculation.class);
        private final MetaProperty<IborRateStubCalculation> finalStub = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"finalStub", IborRateCalculation.class, IborRateStubCalculation.class);
        private final MetaProperty<ValueSchedule> gearing = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"gearing", IborRateCalculation.class, ValueSchedule.class);
        private final MetaProperty<ValueSchedule> spread = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spread", IborRateCalculation.class, ValueSchedule.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"dayCount", "index", "resetPeriods", "fixingRelativeTo", "fixingDateOffset", "negativeRateMethod", "firstRegularRate", "firstRate", "firstFixingDateOffset", "initialStub", "finalStub", "gearing", "spread"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return this.dayCount;
                }
                case 100346066: {
                    return this.index;
                }
                case -1272973693: {
                    return this.resetPeriods;
                }
                case 232554996: {
                    return this.fixingRelativeTo;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1969081334: {
                    return this.negativeRateMethod;
                }
                case 570227148: {
                    return this.firstRegularRate;
                }
                case 132955056: {
                    return this.firstRate;
                }
                case 2022439998: {
                    return this.firstFixingDateOffset;
                }
                case 1233359378: {
                    return this.initialStub;
                }
                case 355242820: {
                    return this.finalStub;
                }
                case -91774989: {
                    return this.gearing;
                }
                case -895684237: {
                    return this.spread;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborRateCalculation> beanType() {
            return IborRateCalculation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<ResetSchedule> resetPeriods() {
            return this.resetPeriods;
        }

        public MetaProperty<FixingRelativeTo> fixingRelativeTo() {
            return this.fixingRelativeTo;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        public MetaProperty<NegativeRateMethod> negativeRateMethod() {
            return this.negativeRateMethod;
        }

        public MetaProperty<Double> firstRegularRate() {
            return this.firstRegularRate;
        }

        public MetaProperty<Double> firstRate() {
            return this.firstRate;
        }

        public MetaProperty<DaysAdjustment> firstFixingDateOffset() {
            return this.firstFixingDateOffset;
        }

        public MetaProperty<IborRateStubCalculation> initialStub() {
            return this.initialStub;
        }

        public MetaProperty<IborRateStubCalculation> finalStub() {
            return this.finalStub;
        }

        public MetaProperty<ValueSchedule> gearing() {
            return this.gearing;
        }

        public MetaProperty<ValueSchedule> spread() {
            return this.spread;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return ((IborRateCalculation)bean).getDayCount();
                }
                case 100346066: {
                    return ((IborRateCalculation)bean).getIndex();
                }
                case -1272973693: {
                    return ((IborRateCalculation)bean).resetPeriods;
                }
                case 232554996: {
                    return ((IborRateCalculation)bean).getFixingRelativeTo();
                }
                case 873743726: {
                    return ((IborRateCalculation)bean).getFixingDateOffset();
                }
                case 1969081334: {
                    return ((IborRateCalculation)bean).getNegativeRateMethod();
                }
                case 570227148: {
                    return ((IborRateCalculation)bean).firstRegularRate;
                }
                case 132955056: {
                    return ((IborRateCalculation)bean).firstRate;
                }
                case 2022439998: {
                    return ((IborRateCalculation)bean).firstFixingDateOffset;
                }
                case 1233359378: {
                    return ((IborRateCalculation)bean).initialStub;
                }
                case 355242820: {
                    return ((IborRateCalculation)bean).finalStub;
                }
                case -91774989: {
                    return ((IborRateCalculation)bean).gearing;
                }
                case -895684237: {
                    return ((IborRateCalculation)bean).spread;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

