/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.rate.FixedRateComputation;
import com.opengamma.strata.product.rate.IborInterpolatedRateComputation;
import com.opengamma.strata.product.rate.IborRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.KnownAmountRateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborRateStubCalculation
implements ImmutableBean,
Serializable {
    public static final IborRateStubCalculation NONE = new IborRateStubCalculation(null, null, null, null);
    @PropertyDefinition(get="optional")
    private final Double fixedRate;
    @PropertyDefinition(get="optional")
    private final CurrencyAmount knownAmount;
    @PropertyDefinition(get="optional")
    private final IborIndex index;
    @PropertyDefinition(get="optional")
    private final IborIndex indexInterpolated;
    private static final long serialVersionUID = 1L;

    public static IborRateStubCalculation ofFixedRate(double fixedRate) {
        return new IborRateStubCalculation(fixedRate, null, null, null);
    }

    public static IborRateStubCalculation ofKnownAmount(CurrencyAmount knownAmount) {
        ArgChecker.notNull((Object)knownAmount, (String)"knownAmount");
        return new IborRateStubCalculation(null, knownAmount, null, null);
    }

    public static IborRateStubCalculation ofIborRate(IborIndex index) {
        ArgChecker.notNull((Object)index, (String)"index");
        return new IborRateStubCalculation(null, null, index, null);
    }

    public static IborRateStubCalculation ofIborInterpolatedRate(IborIndex index1, IborIndex index2) {
        ArgChecker.notNull((Object)index1, (String)"index1");
        ArgChecker.notNull((Object)index2, (String)"index2");
        return new IborRateStubCalculation(null, null, index1, index2);
    }

    @ImmutableValidator
    private void validate() {
        if (this.fixedRate != null && this.knownAmount != null) {
            throw new IllegalArgumentException("Either rate or amount may be specified, not both");
        }
        if (this.fixedRate != null && this.index != null) {
            throw new IllegalArgumentException("Either rate or index may be specified, not both");
        }
        if (this.index != null && this.knownAmount != null) {
            throw new IllegalArgumentException("Either index or amount may be specified, not both");
        }
        if (this.indexInterpolated != null) {
            if (this.index == null) {
                throw new IllegalArgumentException("When indexInterpolated is present, index must also be present");
            }
            if (this.indexInterpolated.equals(this.index)) {
                throw new IllegalArgumentException("Interpolation requires two different indices");
            }
        }
    }

    RateComputation createRateComputation(LocalDate fixingDate, IborIndex defaultIndex, ReferenceData refData) {
        if (this.isInterpolated()) {
            return IborInterpolatedRateComputation.of(this.index, this.indexInterpolated, fixingDate, refData);
        }
        if (this.isFloatingRate()) {
            return IborRateComputation.of(this.index, fixingDate, refData);
        }
        if (this.isFixedRate()) {
            return FixedRateComputation.of(this.fixedRate);
        }
        if (this.isKnownAmount()) {
            return KnownAmountRateComputation.of(this.knownAmount);
        }
        return IborRateComputation.of(defaultIndex, fixingDate, refData);
    }

    public boolean isFixedRate() {
        return this.fixedRate != null;
    }

    public boolean isKnownAmount() {
        return this.knownAmount != null;
    }

    public boolean isFloatingRate() {
        return this.index != null;
    }

    public boolean isInterpolated() {
        return this.index != null && this.indexInterpolated != null;
    }

    void collectCurrencies(ImmutableSet.Builder<Currency> builder) {
        this.getKnownAmount().ifPresent(amt -> builder.add((Object)amt.getCurrency()));
        this.getIndex().ifPresent(idx -> builder.add((Object)idx.getCurrency()));
        this.getIndexInterpolated().ifPresent(idx -> builder.add((Object)idx.getCurrency()));
    }

    void collectIndices(ImmutableSet.Builder<Index> builder) {
        this.getIndex().ifPresent(idx -> builder.add(idx));
        this.getIndexInterpolated().ifPresent(idx -> builder.add(idx));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IborRateStubCalculation(Double fixedRate, CurrencyAmount knownAmount, IborIndex index, IborIndex indexInterpolated) {
        this.fixedRate = fixedRate;
        this.knownAmount = knownAmount;
        this.index = index;
        this.indexInterpolated = indexInterpolated;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public OptionalDouble getFixedRate() {
        return this.fixedRate != null ? OptionalDouble.of(this.fixedRate) : OptionalDouble.empty();
    }

    public Optional<CurrencyAmount> getKnownAmount() {
        return Optional.ofNullable(this.knownAmount);
    }

    public Optional<IborIndex> getIndex() {
        return Optional.ofNullable(this.index);
    }

    public Optional<IborIndex> getIndexInterpolated() {
        return Optional.ofNullable(this.indexInterpolated);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborRateStubCalculation other = (IborRateStubCalculation)obj;
            return JodaBeanUtils.equal((Object)this.fixedRate, (Object)other.fixedRate) && JodaBeanUtils.equal((Object)this.knownAmount, (Object)other.knownAmount) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.indexInterpolated, (Object)other.indexInterpolated);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.knownAmount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.indexInterpolated);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("IborRateStubCalculation{");
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("knownAmount").append('=').append(JodaBeanUtils.toString((Object)this.knownAmount)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("indexInterpolated").append('=').append(JodaBeanUtils.toString((Object)this.indexInterpolated));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborRateStubCalculation> {
        private Double fixedRate;
        private CurrencyAmount knownAmount;
        private IborIndex index;
        private IborIndex indexInterpolated;

        private Builder() {
        }

        private Builder(IborRateStubCalculation beanToCopy) {
            this.fixedRate = beanToCopy.fixedRate;
            this.knownAmount = beanToCopy.knownAmount;
            this.index = beanToCopy.index;
            this.indexInterpolated = beanToCopy.indexInterpolated;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 747425396: {
                    return this.fixedRate;
                }
                case -158727813: {
                    return this.knownAmount;
                }
                case 100346066: {
                    return this.index;
                }
                case -1934091915: {
                    return this.indexInterpolated;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case -158727813: {
                    this.knownAmount = (CurrencyAmount)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -1934091915: {
                    this.indexInterpolated = (IborIndex)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborRateStubCalculation build() {
            return new IborRateStubCalculation(this.fixedRate, this.knownAmount, this.index, this.indexInterpolated);
        }

        public Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder knownAmount(CurrencyAmount knownAmount) {
            this.knownAmount = knownAmount;
            return this;
        }

        public Builder index(IborIndex index) {
            this.index = index;
            return this;
        }

        public Builder indexInterpolated(IborIndex indexInterpolated) {
            this.indexInterpolated = indexInterpolated;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("IborRateStubCalculation.Builder{");
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("knownAmount").append('=').append(JodaBeanUtils.toString((Object)this.knownAmount)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("indexInterpolated").append('=').append(JodaBeanUtils.toString((Object)this.indexInterpolated));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", IborRateStubCalculation.class, Double.class);
        private final MetaProperty<CurrencyAmount> knownAmount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"knownAmount", IborRateStubCalculation.class, CurrencyAmount.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", IborRateStubCalculation.class, IborIndex.class);
        private final MetaProperty<IborIndex> indexInterpolated = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"indexInterpolated", IborRateStubCalculation.class, IborIndex.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"fixedRate", "knownAmount", "index", "indexInterpolated"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 747425396: {
                    return this.fixedRate;
                }
                case -158727813: {
                    return this.knownAmount;
                }
                case 100346066: {
                    return this.index;
                }
                case -1934091915: {
                    return this.indexInterpolated;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborRateStubCalculation> beanType() {
            return IborRateStubCalculation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<CurrencyAmount> knownAmount() {
            return this.knownAmount;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<IborIndex> indexInterpolated() {
            return this.indexInterpolated;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 747425396: {
                    return ((IborRateStubCalculation)bean).fixedRate;
                }
                case -158727813: {
                    return ((IborRateStubCalculation)bean).knownAmount;
                }
                case 100346066: {
                    return ((IborRateStubCalculation)bean).index;
                }
                case -1934091915: {
                    return ((IborRateStubCalculation)bean).indexInterpolated;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

