/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.product.swap.SwapIndex;
import com.opengamma.strata.product.swap.type.FixedFloatSwapTemplate;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableSwapIndex
implements SwapIndex,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String name;
    @PropertyDefinition(overrideGet=true)
    private final boolean active;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalTime fixingTime;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZoneId fixingZone;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FixedFloatSwapTemplate template;
    private static final long serialVersionUID = 1L;

    public static ImmutableSwapIndex of(String name, LocalTime fixingTime, ZoneId fixingZone, FixedFloatSwapTemplate template) {
        return new ImmutableSwapIndex(name, true, fixingTime, fixingZone, template);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.active = true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableSwapIndex) {
            return this.name.equals(((ImmutableSwapIndex)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableSwapIndex(String name, boolean active, LocalTime fixingTime, ZoneId fixingZone, FixedFloatSwapTemplate template) {
        JodaBeanUtils.notEmpty((String)name, (String)"name");
        JodaBeanUtils.notNull((Object)fixingTime, (String)"fixingTime");
        JodaBeanUtils.notNull((Object)fixingZone, (String)"fixingZone");
        JodaBeanUtils.notNull((Object)template, (String)"template");
        this.name = name;
        this.active = active;
        this.fixingTime = fixingTime;
        this.fixingZone = fixingZone;
        this.template = template;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public LocalTime getFixingTime() {
        return this.fixingTime;
    }

    @Override
    public ZoneId getFixingZone() {
        return this.fixingZone;
    }

    @Override
    public FixedFloatSwapTemplate getTemplate() {
        return this.template;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableSwapIndex> {
        private String name;
        private boolean active;
        private LocalTime fixingTime;
        private ZoneId fixingZone;
        private FixedFloatSwapTemplate template;

        private Builder() {
            ImmutableSwapIndex.applyDefaults(this);
        }

        private Builder(ImmutableSwapIndex beanToCopy) {
            this.name = beanToCopy.getName();
            this.active = beanToCopy.isActive();
            this.fixingTime = beanToCopy.getFixingTime();
            this.fixingZone = beanToCopy.getFixingZone();
            this.template = beanToCopy.getTemplate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -1422950650: {
                    return this.active;
                }
                case 1255686170: {
                    return this.fixingTime;
                }
                case 1255870713: {
                    return this.fixingZone;
                }
                case -1321546630: {
                    return this.template;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case -1422950650: {
                    this.active = (Boolean)newValue;
                    break;
                }
                case 1255686170: {
                    this.fixingTime = (LocalTime)newValue;
                    break;
                }
                case 1255870713: {
                    this.fixingZone = (ZoneId)newValue;
                    break;
                }
                case -1321546630: {
                    this.template = (FixedFloatSwapTemplate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableSwapIndex build() {
            return new ImmutableSwapIndex(this.name, this.active, this.fixingTime, this.fixingZone, this.template);
        }

        public Builder name(String name) {
            JodaBeanUtils.notEmpty((String)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder fixingTime(LocalTime fixingTime) {
            JodaBeanUtils.notNull((Object)fixingTime, (String)"fixingTime");
            this.fixingTime = fixingTime;
            return this;
        }

        public Builder fixingZone(ZoneId fixingZone) {
            JodaBeanUtils.notNull((Object)fixingZone, (String)"fixingZone");
            this.fixingZone = fixingZone;
            return this;
        }

        public Builder template(FixedFloatSwapTemplate template) {
            JodaBeanUtils.notNull((Object)template, (String)"template");
            this.template = template;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ImmutableSwapIndex.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("active").append('=').append(JodaBeanUtils.toString((Object)this.active)).append(',').append(' ');
            buf.append("fixingTime").append('=').append(JodaBeanUtils.toString((Object)this.fixingTime)).append(',').append(' ');
            buf.append("fixingZone").append('=').append(JodaBeanUtils.toString((Object)this.fixingZone)).append(',').append(' ');
            buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableSwapIndex.class, String.class);
        private final MetaProperty<Boolean> active = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"active", ImmutableSwapIndex.class, Boolean.TYPE);
        private final MetaProperty<LocalTime> fixingTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingTime", ImmutableSwapIndex.class, LocalTime.class);
        private final MetaProperty<ZoneId> fixingZone = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingZone", ImmutableSwapIndex.class, ZoneId.class);
        private final MetaProperty<FixedFloatSwapTemplate> template = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"template", ImmutableSwapIndex.class, FixedFloatSwapTemplate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "active", "fixingTime", "fixingZone", "template"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -1422950650: {
                    return this.active;
                }
                case 1255686170: {
                    return this.fixingTime;
                }
                case 1255870713: {
                    return this.fixingZone;
                }
                case -1321546630: {
                    return this.template;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableSwapIndex> beanType() {
            return ImmutableSwapIndex.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<Boolean> active() {
            return this.active;
        }

        public MetaProperty<LocalTime> fixingTime() {
            return this.fixingTime;
        }

        public MetaProperty<ZoneId> fixingZone() {
            return this.fixingZone;
        }

        public MetaProperty<FixedFloatSwapTemplate> template() {
            return this.template;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableSwapIndex)bean).getName();
                }
                case -1422950650: {
                    return ((ImmutableSwapIndex)bean).isActive();
                }
                case 1255686170: {
                    return ((ImmutableSwapIndex)bean).getFixingTime();
                }
                case 1255870713: {
                    return ((ImmutableSwapIndex)bean).getFixingZone();
                }
                case -1321546630: {
                    return ((ImmutableSwapIndex)bean).getTemplate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

