/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.product.rate.InflationEndInterpolatedRateComputation;
import com.opengamma.strata.product.rate.InflationEndMonthRateComputation;
import com.opengamma.strata.product.rate.InflationInterpolatedRateComputation;
import com.opengamma.strata.product.rate.InflationMonthlyRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.NegativeRateMethod;
import com.opengamma.strata.product.swap.PriceIndexCalculationMethod;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RateCalculation;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.time.YearMonth;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class InflationRateCalculation
implements RateCalculation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PriceIndex index;
    @PropertyDefinition(validate="notNull")
    private final Period lag;
    @PropertyDefinition(validate="notNull")
    private final PriceIndexCalculationMethod indexCalculationMethod;
    @PropertyDefinition(get="optional")
    private final Double firstIndexValue;
    @PropertyDefinition(get="optional")
    private final ValueSchedule gearing;
    private static final long serialVersionUID = 1L;

    public static InflationRateCalculation of(PriceIndex index, int monthLag, PriceIndexCalculationMethod indexCalculationMethod) {
        return InflationRateCalculation.builder().index(index).lag(Period.ofMonths(monthLag)).indexCalculationMethod(indexCalculationMethod).build();
    }

    public static InflationRateCalculation of(PriceIndex index, int monthLag, PriceIndexCalculationMethod indexCalculationMethod, double firstIndexValue) {
        return InflationRateCalculation.builder().index(index).lag(Period.ofMonths(monthLag)).indexCalculationMethod(indexCalculationMethod).firstIndexValue(firstIndexValue).build();
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isFalse((this.lag.isZero() || this.lag.isNegative() ? 1 : 0) != 0, (String)"Lag must be positive");
    }

    @Override
    public SwapLegType getType() {
        return SwapLegType.INFLATION;
    }

    @Override
    public DayCount getDayCount() {
        return DayCounts.ONE_ONE;
    }

    @Override
    public void collectCurrencies(ImmutableSet.Builder<Currency> builder) {
        builder.add((Object)this.index.getCurrency());
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.index);
    }

    @Override
    public ImmutableList<RateAccrualPeriod> createAccrualPeriods(Schedule accrualSchedule, Schedule paymentSchedule, ReferenceData refData) {
        DoubleArray resolvedGearings = ((ValueSchedule)MoreObjects.firstNonNull((Object)this.gearing, (Object)ValueSchedule.ALWAYS_1)).resolveValues(accrualSchedule);
        ImmutableList.Builder accrualPeriods = ImmutableList.builder();
        for (int i = 0; i < accrualSchedule.size(); ++i) {
            SchedulePeriod period = accrualSchedule.getPeriod(i);
            accrualPeriods.add((Object)new RateAccrualPeriod(period, 1.0, this.createRateComputation(period, i), resolvedGearings.get(i), 0.0, NegativeRateMethod.ALLOW_NEGATIVE));
        }
        return accrualPeriods.build();
    }

    private RateComputation createRateComputation(SchedulePeriod period, int scheduleIndex) {
        LocalDate endDate = period.getEndDate();
        if (this.firstIndexValue != null && scheduleIndex == 0) {
            return this.createRateComputation(endDate);
        }
        YearMonth referenceStartMonth = YearMonth.from(period.getStartDate().minus(this.lag));
        YearMonth referenceEndMonth = YearMonth.from(endDate.minus(this.lag));
        if (this.indexCalculationMethod.equals((Object)PriceIndexCalculationMethod.INTERPOLATED)) {
            double weight = 1.0 - ((double)endDate.getDayOfMonth() - 1.0) / (double)endDate.lengthOfMonth();
            return InflationInterpolatedRateComputation.of(this.index, referenceStartMonth, referenceEndMonth, weight);
        }
        if (this.indexCalculationMethod.equals((Object)PriceIndexCalculationMethod.MONTHLY)) {
            return InflationMonthlyRateComputation.of(this.index, referenceStartMonth, referenceEndMonth);
        }
        throw new IllegalArgumentException("PriceIndexCalculationMethod " + this.indexCalculationMethod.toString() + " is not supported");
    }

    public RateComputation createRateComputation(LocalDate endDate) {
        if (this.firstIndexValue == null) {
            throw new IllegalStateException("First index value must be specified");
        }
        YearMonth referenceEndMonth = YearMonth.from(endDate.minus(this.lag));
        if (this.indexCalculationMethod.equals((Object)PriceIndexCalculationMethod.INTERPOLATED)) {
            double weight = 1.0 - ((double)endDate.getDayOfMonth() - 1.0) / (double)endDate.lengthOfMonth();
            return InflationEndInterpolatedRateComputation.of(this.index, this.firstIndexValue, referenceEndMonth, weight);
        }
        if (this.indexCalculationMethod.equals((Object)PriceIndexCalculationMethod.MONTHLY)) {
            return InflationEndMonthRateComputation.of(this.index, this.firstIndexValue, referenceEndMonth);
        }
        if (this.indexCalculationMethod.equals((Object)PriceIndexCalculationMethod.INTERPOLATED_JAPAN)) {
            double weight = 1.0;
            int dayOfMonth = endDate.getDayOfMonth();
            if (dayOfMonth > 10) {
                weight -= ((double)dayOfMonth - 10.0) / (double)endDate.lengthOfMonth();
            } else if (dayOfMonth < 10) {
                weight -= ((double)(dayOfMonth + endDate.minusMonths(1L).lengthOfMonth()) - 10.0) / (double)endDate.minusMonths(1L).lengthOfMonth();
                referenceEndMonth = referenceEndMonth.minusMonths(1L);
            }
            return InflationEndInterpolatedRateComputation.of(this.index, this.firstIndexValue, referenceEndMonth, weight);
        }
        throw new IllegalArgumentException("PriceIndexCalculationMethod " + this.indexCalculationMethod.toString() + " is not supported");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private InflationRateCalculation(PriceIndex index, Period lag, PriceIndexCalculationMethod indexCalculationMethod, Double firstIndexValue, ValueSchedule gearing) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)lag, (String)"lag");
        JodaBeanUtils.notNull((Object)((Object)indexCalculationMethod), (String)"indexCalculationMethod");
        this.index = index;
        this.lag = lag;
        this.indexCalculationMethod = indexCalculationMethod;
        this.firstIndexValue = firstIndexValue;
        this.gearing = gearing;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PriceIndex getIndex() {
        return this.index;
    }

    public Period getLag() {
        return this.lag;
    }

    public PriceIndexCalculationMethod getIndexCalculationMethod() {
        return this.indexCalculationMethod;
    }

    public OptionalDouble getFirstIndexValue() {
        return this.firstIndexValue != null ? OptionalDouble.of(this.firstIndexValue) : OptionalDouble.empty();
    }

    public Optional<ValueSchedule> getGearing() {
        return Optional.ofNullable(this.gearing);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InflationRateCalculation other = (InflationRateCalculation)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.lag, (Object)other.lag) && JodaBeanUtils.equal((Object)((Object)this.indexCalculationMethod), (Object)((Object)other.indexCalculationMethod)) && JodaBeanUtils.equal((Object)this.firstIndexValue, (Object)other.firstIndexValue) && JodaBeanUtils.equal((Object)this.gearing, (Object)other.gearing);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lag);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.indexCalculationMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstIndexValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.gearing);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("InflationRateCalculation{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("lag").append('=').append(JodaBeanUtils.toString((Object)this.lag)).append(',').append(' ');
        buf.append("indexCalculationMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.indexCalculationMethod))).append(',').append(' ');
        buf.append("firstIndexValue").append('=').append(JodaBeanUtils.toString((Object)this.firstIndexValue)).append(',').append(' ');
        buf.append("gearing").append('=').append(JodaBeanUtils.toString((Object)this.gearing));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<InflationRateCalculation> {
        private PriceIndex index;
        private Period lag;
        private PriceIndexCalculationMethod indexCalculationMethod;
        private Double firstIndexValue;
        private ValueSchedule gearing;

        private Builder() {
        }

        private Builder(InflationRateCalculation beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.lag = beanToCopy.getLag();
            this.indexCalculationMethod = beanToCopy.getIndexCalculationMethod();
            this.firstIndexValue = beanToCopy.firstIndexValue;
            this.gearing = beanToCopy.gearing;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 106898: {
                    return this.lag;
                }
                case -1409010088: {
                    return this.indexCalculationMethod;
                }
                case 922631823: {
                    return this.firstIndexValue;
                }
                case -91774989: {
                    return this.gearing;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (PriceIndex)newValue;
                    break;
                }
                case 106898: {
                    this.lag = (Period)newValue;
                    break;
                }
                case -1409010088: {
                    this.indexCalculationMethod = (PriceIndexCalculationMethod)((Object)newValue);
                    break;
                }
                case 922631823: {
                    this.firstIndexValue = (Double)newValue;
                    break;
                }
                case -91774989: {
                    this.gearing = (ValueSchedule)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public InflationRateCalculation build() {
            return new InflationRateCalculation(this.index, this.lag, this.indexCalculationMethod, this.firstIndexValue, this.gearing);
        }

        public Builder index(PriceIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder lag(Period lag) {
            JodaBeanUtils.notNull((Object)lag, (String)"lag");
            this.lag = lag;
            return this;
        }

        public Builder indexCalculationMethod(PriceIndexCalculationMethod indexCalculationMethod) {
            JodaBeanUtils.notNull((Object)((Object)indexCalculationMethod), (String)"indexCalculationMethod");
            this.indexCalculationMethod = indexCalculationMethod;
            return this;
        }

        public Builder firstIndexValue(Double firstIndexValue) {
            this.firstIndexValue = firstIndexValue;
            return this;
        }

        public Builder gearing(ValueSchedule gearing) {
            this.gearing = gearing;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("InflationRateCalculation.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("lag").append('=').append(JodaBeanUtils.toString((Object)this.lag)).append(',').append(' ');
            buf.append("indexCalculationMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.indexCalculationMethod))).append(',').append(' ');
            buf.append("firstIndexValue").append('=').append(JodaBeanUtils.toString((Object)this.firstIndexValue)).append(',').append(' ');
            buf.append("gearing").append('=').append(JodaBeanUtils.toString((Object)this.gearing));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PriceIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", InflationRateCalculation.class, PriceIndex.class);
        private final MetaProperty<Period> lag = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lag", InflationRateCalculation.class, Period.class);
        private final MetaProperty<PriceIndexCalculationMethod> indexCalculationMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"indexCalculationMethod", InflationRateCalculation.class, PriceIndexCalculationMethod.class);
        private final MetaProperty<Double> firstIndexValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstIndexValue", InflationRateCalculation.class, Double.class);
        private final MetaProperty<ValueSchedule> gearing = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"gearing", InflationRateCalculation.class, ValueSchedule.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "lag", "indexCalculationMethod", "firstIndexValue", "gearing"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 106898: {
                    return this.lag;
                }
                case -1409010088: {
                    return this.indexCalculationMethod;
                }
                case 922631823: {
                    return this.firstIndexValue;
                }
                case -91774989: {
                    return this.gearing;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends InflationRateCalculation> beanType() {
            return InflationRateCalculation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PriceIndex> index() {
            return this.index;
        }

        public MetaProperty<Period> lag() {
            return this.lag;
        }

        public MetaProperty<PriceIndexCalculationMethod> indexCalculationMethod() {
            return this.indexCalculationMethod;
        }

        public MetaProperty<Double> firstIndexValue() {
            return this.firstIndexValue;
        }

        public MetaProperty<ValueSchedule> gearing() {
            return this.gearing;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((InflationRateCalculation)bean).getIndex();
                }
                case 106898: {
                    return ((InflationRateCalculation)bean).getLag();
                }
                case -1409010088: {
                    return ((InflationRateCalculation)bean).getIndexCalculationMethod();
                }
                case 922631823: {
                    return ((InflationRateCalculation)bean).firstIndexValue;
                }
                case -91774989: {
                    return ((InflationRateCalculation)bean).gearing;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

