/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.swap.NotionalPaymentPeriod;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class KnownAmountNotionalSwapPaymentPeriod
implements NotionalPaymentPeriod,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Payment payment;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedEndDate;
    @PropertyDefinition(overrideGet=true)
    private final CurrencyAmount notionalAmount;
    @PropertyDefinition(get="optional", overrideGet=true)
    private final FxIndexObservation fxResetObservation;
    private static final long serialVersionUID = 1L;

    public static KnownAmountNotionalSwapPaymentPeriod of(Payment payment, SchedulePeriod period, CurrencyAmount notional) {
        return KnownAmountNotionalSwapPaymentPeriod.builder().payment(payment).startDate(period.getStartDate()).endDate(period.getEndDate()).unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate()).notionalAmount(notional).build();
    }

    public static KnownAmountNotionalSwapPaymentPeriod of(Payment payment, SchedulePeriod period, CurrencyAmount notional, FxIndexObservation fxResetObservation) {
        return KnownAmountNotionalSwapPaymentPeriod.builder().payment(payment).startDate(period.getStartDate()).endDate(period.getEndDate()).unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate()).notionalAmount(notional).fxResetObservation(fxResetObservation).build();
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.unadjustedStartDate == null && builder.startDate != null) {
            builder.unadjustedStartDate = builder.startDate;
        }
        if (builder.unadjustedEndDate == null && builder.endDate != null) {
            builder.unadjustedEndDate = builder.endDate;
        }
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
        ArgChecker.inOrderNotEqual((Comparable)this.unadjustedStartDate, (Object)this.unadjustedEndDate, (String)"unadjustedStartDate", (String)"unadjustedEndDate");
        Currency payCcy = this.payment.getCurrency();
        Currency notionalCcy = this.notionalAmount.getCurrency();
        if (this.fxResetObservation != null) {
            if (notionalCcy.equals((Object)payCcy)) {
                throw new IllegalArgumentException(Messages.format((String)"Payment currency {} must not equal notional currency {} when FX reset applies", (Object[])new Object[]{payCcy, notionalCcy}));
            }
            if (!this.fxResetObservation.getIndex().getCurrencyPair().contains(payCcy)) {
                throw new IllegalArgumentException(Messages.format((String)"Payment currency {} must be one of those in the FxReset index {}", (Object[])new Object[]{payCcy, this.fxResetObservation.getIndex()}));
            }
            if (!this.fxResetObservation.getIndex().getCurrencyPair().contains(notionalCcy)) {
                throw new IllegalArgumentException(Messages.format((String)"Notional currency {} must be one of those in the FxReset index {}", (Object[])new Object[]{notionalCcy, this.fxResetObservation.getIndex()}));
            }
        } else if (!notionalCcy.equals((Object)payCcy)) {
            throw new IllegalArgumentException(Messages.format((String)"Payment currency {} must equal notional currency {}", (Object[])new Object[]{payCcy, notionalCcy}));
        }
    }

    @Override
    public LocalDate getPaymentDate() {
        return this.payment.getDate();
    }

    @Override
    public Currency getCurrency() {
        return this.payment.getCurrency();
    }

    @Override
    public KnownAmountNotionalSwapPaymentPeriod adjustPaymentDate(TemporalAdjuster adjuster) {
        Payment adjusted = this.payment.adjustDate(adjuster);
        return adjusted == this.payment ? this : this.toBuilder().payment(adjusted).build();
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        this.getFxResetObservation().ifPresent(fxReset -> builder.add((Object)fxReset.getIndex()));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private KnownAmountNotionalSwapPaymentPeriod(Payment payment, LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate, CurrencyAmount notionalAmount, FxIndexObservation fxResetObservation) {
        JodaBeanUtils.notNull((Object)payment, (String)"payment");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
        JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
        this.payment = payment;
        this.startDate = startDate;
        this.endDate = endDate;
        this.unadjustedStartDate = unadjustedStartDate;
        this.unadjustedEndDate = unadjustedEndDate;
        this.notionalAmount = notionalAmount;
        this.fxResetObservation = fxResetObservation;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Payment getPayment() {
        return this.payment;
    }

    @Override
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Override
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalDate getUnadjustedStartDate() {
        return this.unadjustedStartDate;
    }

    public LocalDate getUnadjustedEndDate() {
        return this.unadjustedEndDate;
    }

    @Override
    public CurrencyAmount getNotionalAmount() {
        return this.notionalAmount;
    }

    @Override
    public Optional<FxIndexObservation> getFxResetObservation() {
        return Optional.ofNullable(this.fxResetObservation);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            KnownAmountNotionalSwapPaymentPeriod other = (KnownAmountNotionalSwapPaymentPeriod)obj;
            return JodaBeanUtils.equal((Object)this.payment, (Object)other.payment) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.unadjustedStartDate, (Object)other.unadjustedStartDate) && JodaBeanUtils.equal((Object)this.unadjustedEndDate, (Object)other.unadjustedEndDate) && JodaBeanUtils.equal((Object)this.notionalAmount, (Object)other.notionalAmount) && JodaBeanUtils.equal((Object)this.fxResetObservation, (Object)other.fxResetObservation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.payment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.notionalAmount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxResetObservation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("KnownAmountNotionalSwapPaymentPeriod{");
        buf.append("payment").append('=').append(JodaBeanUtils.toString((Object)this.payment)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
        buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
        buf.append("notionalAmount").append('=').append(JodaBeanUtils.toString((Object)this.notionalAmount)).append(',').append(' ');
        buf.append("fxResetObservation").append('=').append(JodaBeanUtils.toString((Object)this.fxResetObservation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<KnownAmountNotionalSwapPaymentPeriod> {
        private Payment payment;
        private LocalDate startDate;
        private LocalDate endDate;
        private LocalDate unadjustedStartDate;
        private LocalDate unadjustedEndDate;
        private CurrencyAmount notionalAmount;
        private FxIndexObservation fxResetObservation;

        private Builder() {
        }

        private Builder(KnownAmountNotionalSwapPaymentPeriod beanToCopy) {
            this.payment = beanToCopy.getPayment();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.unadjustedStartDate = beanToCopy.getUnadjustedStartDate();
            this.unadjustedEndDate = beanToCopy.getUnadjustedEndDate();
            this.notionalAmount = beanToCopy.getNotionalAmount();
            this.fxResetObservation = beanToCopy.fxResetObservation;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return this.payment;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -902123592: {
                    return this.notionalAmount;
                }
                case 1301329999: {
                    return this.fxResetObservation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    this.payment = (Payment)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 1457691881: {
                    this.unadjustedStartDate = (LocalDate)newValue;
                    break;
                }
                case 31758114: {
                    this.unadjustedEndDate = (LocalDate)newValue;
                    break;
                }
                case -902123592: {
                    this.notionalAmount = (CurrencyAmount)newValue;
                    break;
                }
                case 1301329999: {
                    this.fxResetObservation = (FxIndexObservation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public KnownAmountNotionalSwapPaymentPeriod build() {
            KnownAmountNotionalSwapPaymentPeriod.preBuild(this);
            return new KnownAmountNotionalSwapPaymentPeriod(this.payment, this.startDate, this.endDate, this.unadjustedStartDate, this.unadjustedEndDate, this.notionalAmount, this.fxResetObservation);
        }

        public Builder payment(Payment payment) {
            JodaBeanUtils.notNull((Object)payment, (String)"payment");
            this.payment = payment;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder unadjustedStartDate(LocalDate unadjustedStartDate) {
            JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
            this.unadjustedStartDate = unadjustedStartDate;
            return this;
        }

        public Builder unadjustedEndDate(LocalDate unadjustedEndDate) {
            JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
            this.unadjustedEndDate = unadjustedEndDate;
            return this;
        }

        public Builder notionalAmount(CurrencyAmount notionalAmount) {
            this.notionalAmount = notionalAmount;
            return this;
        }

        public Builder fxResetObservation(FxIndexObservation fxResetObservation) {
            this.fxResetObservation = fxResetObservation;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("KnownAmountNotionalSwapPaymentPeriod.Builder{");
            buf.append("payment").append('=').append(JodaBeanUtils.toString((Object)this.payment)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
            buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
            buf.append("notionalAmount").append('=').append(JodaBeanUtils.toString((Object)this.notionalAmount)).append(',').append(' ');
            buf.append("fxResetObservation").append('=').append(JodaBeanUtils.toString((Object)this.fxResetObservation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Payment> payment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payment", KnownAmountNotionalSwapPaymentPeriod.class, Payment.class);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", KnownAmountNotionalSwapPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", KnownAmountNotionalSwapPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedStartDate", KnownAmountNotionalSwapPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedEndDate", KnownAmountNotionalSwapPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<CurrencyAmount> notionalAmount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notionalAmount", KnownAmountNotionalSwapPaymentPeriod.class, CurrencyAmount.class);
        private final MetaProperty<FxIndexObservation> fxResetObservation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fxResetObservation", KnownAmountNotionalSwapPaymentPeriod.class, FxIndexObservation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payment", "startDate", "endDate", "unadjustedStartDate", "unadjustedEndDate", "notionalAmount", "fxResetObservation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return this.payment;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -902123592: {
                    return this.notionalAmount;
                }
                case 1301329999: {
                    return this.fxResetObservation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends KnownAmountNotionalSwapPaymentPeriod> beanType() {
            return KnownAmountNotionalSwapPaymentPeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Payment> payment() {
            return this.payment;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<LocalDate> unadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        public MetaProperty<LocalDate> unadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        public MetaProperty<CurrencyAmount> notionalAmount() {
            return this.notionalAmount;
        }

        public MetaProperty<FxIndexObservation> fxResetObservation() {
            return this.fxResetObservation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return ((KnownAmountNotionalSwapPaymentPeriod)bean).getPayment();
                }
                case -2129778896: {
                    return ((KnownAmountNotionalSwapPaymentPeriod)bean).getStartDate();
                }
                case -1607727319: {
                    return ((KnownAmountNotionalSwapPaymentPeriod)bean).getEndDate();
                }
                case 1457691881: {
                    return ((KnownAmountNotionalSwapPaymentPeriod)bean).getUnadjustedStartDate();
                }
                case 31758114: {
                    return ((KnownAmountNotionalSwapPaymentPeriod)bean).getUnadjustedEndDate();
                }
                case -902123592: {
                    return ((KnownAmountNotionalSwapPaymentPeriod)bean).getNotionalAmount();
                }
                case 1301329999: {
                    return ((KnownAmountNotionalSwapPaymentPeriod)bean).fxResetObservation;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

