/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.KnownAmountSwapPaymentPeriod;
import com.opengamma.strata.product.swap.PaymentSchedule;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.ScheduledSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class KnownAmountSwapLeg
implements ScheduledSwapLeg,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PeriodicSchedule accrualSchedule;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PaymentSchedule paymentSchedule;
    @PropertyDefinition(validate="notNull")
    private final ValueSchedule amount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    private static final long serialVersionUID = 1L;

    @Override
    @DerivedProperty
    public SwapLegType getType() {
        return SwapLegType.FIXED;
    }

    @Override
    @DerivedProperty
    public AdjustableDate getStartDate() {
        return this.accrualSchedule.calculatedStartDate();
    }

    @Override
    @DerivedProperty
    public AdjustableDate getEndDate() {
        return this.accrualSchedule.calculatedEndDate();
    }

    @Override
    public void collectCurrencies(ImmutableSet.Builder<Currency> builder) {
        builder.add((Object)this.currency);
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
    }

    @Override
    public KnownAmountSwapLeg replaceStartDate(LocalDate adjustedStartDate) {
        return this.toBuilder().accrualSchedule(this.accrualSchedule.replaceStartDate(adjustedStartDate)).build();
    }

    @Override
    public ResolvedSwapLeg resolve(ReferenceData refData) {
        Schedule resolvedAccruals = this.accrualSchedule.createSchedule(refData);
        Schedule resolvedPayments = this.paymentSchedule.createSchedule(resolvedAccruals, refData);
        List<SwapPaymentPeriod> payPeriods = this.createPaymentPeriods(resolvedPayments, refData);
        return new ResolvedSwapLeg(this.getType(), this.payReceive, payPeriods, (List<? extends SwapPaymentEvent>)ImmutableList.of(), this.currency);
    }

    private List<SwapPaymentPeriod> createPaymentPeriods(Schedule resolvedPayments, ReferenceData refData) {
        DoubleArray amounts = this.amount.resolveValues(resolvedPayments);
        DateAdjuster paymentDateAdjuster = this.paymentSchedule.getPaymentDateOffset().resolve(refData);
        ImmutableList.Builder paymentPeriods = ImmutableList.builder();
        for (int index = 0; index < resolvedPayments.size(); ++index) {
            SchedulePeriod paymentPeriod = resolvedPayments.getPeriod(index);
            LocalDate baseDate = this.paymentSchedule.getPaymentRelativeTo().selectBaseDate(paymentPeriod);
            LocalDate paymentDate = paymentDateAdjuster.adjust(baseDate);
            double amount = this.payReceive.normalize(amounts.get(index));
            Payment payment = Payment.of((CurrencyAmount)CurrencyAmount.of((Currency)this.currency, (double)amount), (LocalDate)paymentDate);
            paymentPeriods.add((Object)KnownAmountSwapPaymentPeriod.of(payment, paymentPeriod));
        }
        return paymentPeriods.build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private KnownAmountSwapLeg(PayReceive payReceive, PeriodicSchedule accrualSchedule, PaymentSchedule paymentSchedule, ValueSchedule amount, Currency currency) {
        JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
        JodaBeanUtils.notNull((Object)accrualSchedule, (String)"accrualSchedule");
        JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
        JodaBeanUtils.notNull((Object)amount, (String)"amount");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.payReceive = payReceive;
        this.accrualSchedule = accrualSchedule;
        this.paymentSchedule = paymentSchedule;
        this.amount = amount;
        this.currency = currency;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    @Override
    public PeriodicSchedule getAccrualSchedule() {
        return this.accrualSchedule;
    }

    @Override
    public PaymentSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public ValueSchedule getAmount() {
        return this.amount;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            KnownAmountSwapLeg other = (KnownAmountSwapLeg)obj;
            return JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal((Object)this.accrualSchedule, (Object)other.accrualSchedule) && JodaBeanUtils.equal((Object)this.paymentSchedule, (Object)other.paymentSchedule) && JodaBeanUtils.equal((Object)this.amount, (Object)other.amount) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.amount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("KnownAmountSwapLeg{");
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("accrualSchedule").append('=').append(JodaBeanUtils.toString((Object)this.accrualSchedule)).append(',').append(' ');
        buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
        buf.append("amount").append('=').append(JodaBeanUtils.toString((Object)this.amount)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.getType()))).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.getStartDate())).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.getEndDate()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<KnownAmountSwapLeg> {
        private PayReceive payReceive;
        private PeriodicSchedule accrualSchedule;
        private PaymentSchedule paymentSchedule;
        private ValueSchedule amount;
        private Currency currency;

        private Builder() {
        }

        private Builder(KnownAmountSwapLeg beanToCopy) {
            this.payReceive = beanToCopy.getPayReceive();
            this.accrualSchedule = beanToCopy.getAccrualSchedule();
            this.paymentSchedule = beanToCopy.getPaymentSchedule();
            this.amount = beanToCopy.getAmount();
            this.currency = beanToCopy.getCurrency();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 304659814: {
                    return this.accrualSchedule;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case -1413853096: {
                    return this.amount;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case 304659814: {
                    this.accrualSchedule = (PeriodicSchedule)newValue;
                    break;
                }
                case -1499086147: {
                    this.paymentSchedule = (PaymentSchedule)newValue;
                    break;
                }
                case -1413853096: {
                    this.amount = (ValueSchedule)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public KnownAmountSwapLeg build() {
            return new KnownAmountSwapLeg(this.payReceive, this.accrualSchedule, this.paymentSchedule, this.amount, this.currency);
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder accrualSchedule(PeriodicSchedule accrualSchedule) {
            JodaBeanUtils.notNull((Object)accrualSchedule, (String)"accrualSchedule");
            this.accrualSchedule = accrualSchedule;
            return this;
        }

        public Builder paymentSchedule(PaymentSchedule paymentSchedule) {
            JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
            this.paymentSchedule = paymentSchedule;
            return this;
        }

        public Builder amount(ValueSchedule amount) {
            JodaBeanUtils.notNull((Object)amount, (String)"amount");
            this.amount = amount;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("KnownAmountSwapLeg.Builder{");
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("accrualSchedule").append('=').append(JodaBeanUtils.toString((Object)this.accrualSchedule)).append(',').append(' ');
            buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
            buf.append("amount").append('=').append(JodaBeanUtils.toString((Object)this.amount)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("type").append('=').append(JodaBeanUtils.toString(null)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString(null)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", KnownAmountSwapLeg.class, PayReceive.class);
        private final MetaProperty<PeriodicSchedule> accrualSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualSchedule", KnownAmountSwapLeg.class, PeriodicSchedule.class);
        private final MetaProperty<PaymentSchedule> paymentSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentSchedule", KnownAmountSwapLeg.class, PaymentSchedule.class);
        private final MetaProperty<ValueSchedule> amount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amount", KnownAmountSwapLeg.class, ValueSchedule.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", KnownAmountSwapLeg.class, Currency.class);
        private final MetaProperty<SwapLegType> type = DirectMetaProperty.ofDerived((MetaBean)this, (String)"type", KnownAmountSwapLeg.class, SwapLegType.class);
        private final MetaProperty<AdjustableDate> startDate = DirectMetaProperty.ofDerived((MetaBean)this, (String)"startDate", KnownAmountSwapLeg.class, AdjustableDate.class);
        private final MetaProperty<AdjustableDate> endDate = DirectMetaProperty.ofDerived((MetaBean)this, (String)"endDate", KnownAmountSwapLeg.class, AdjustableDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payReceive", "accrualSchedule", "paymentSchedule", "amount", "currency", "type", "startDate", "endDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 304659814: {
                    return this.accrualSchedule;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case -1413853096: {
                    return this.amount;
                }
                case 575402001: {
                    return this.currency;
                }
                case 3575610: {
                    return this.type;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends KnownAmountSwapLeg> beanType() {
            return KnownAmountSwapLeg.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<PeriodicSchedule> accrualSchedule() {
            return this.accrualSchedule;
        }

        public MetaProperty<PaymentSchedule> paymentSchedule() {
            return this.paymentSchedule;
        }

        public MetaProperty<ValueSchedule> amount() {
            return this.amount;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<SwapLegType> type() {
            return this.type;
        }

        public MetaProperty<AdjustableDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<AdjustableDate> endDate() {
            return this.endDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return ((KnownAmountSwapLeg)bean).getPayReceive();
                }
                case 304659814: {
                    return ((KnownAmountSwapLeg)bean).getAccrualSchedule();
                }
                case -1499086147: {
                    return ((KnownAmountSwapLeg)bean).getPaymentSchedule();
                }
                case -1413853096: {
                    return ((KnownAmountSwapLeg)bean).getAmount();
                }
                case 575402001: {
                    return ((KnownAmountSwapLeg)bean).getCurrency();
                }
                case 3575610: {
                    return ((KnownAmountSwapLeg)bean).getType();
                }
                case -2129778896: {
                    return ((KnownAmountSwapLeg)bean).getStartDate();
                }
                case -1607727319: {
                    return ((KnownAmountSwapLeg)bean).getEndDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

