/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class NotionalExchange
implements SwapPaymentEvent,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Payment payment;
    private static final long serialVersionUID = 1L;

    public static NotionalExchange of(CurrencyAmount paymentAmount, LocalDate paymentDate) {
        return new NotionalExchange(Payment.of((CurrencyAmount)paymentAmount, (LocalDate)paymentDate));
    }

    public static NotionalExchange of(Payment payment) {
        return new NotionalExchange(payment);
    }

    @Override
    public LocalDate getPaymentDate() {
        return this.payment.getDate();
    }

    public CurrencyAmount getPaymentAmount() {
        return this.payment.getValue();
    }

    @Override
    public Currency getCurrency() {
        return this.payment.getCurrency();
    }

    @Override
    public NotionalExchange adjustPaymentDate(TemporalAdjuster adjuster) {
        LocalDate adjusted = this.payment.getDate().with(adjuster);
        return NotionalExchange.of(this.payment.getValue(), adjusted);
    }

    @Override
    public boolean isKnownAmountAt(LocalDate date) {
        return true;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private NotionalExchange(Payment payment) {
        JodaBeanUtils.notNull((Object)payment, (String)"payment");
        this.payment = payment;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Payment getPayment() {
        return this.payment;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            NotionalExchange other = (NotionalExchange)obj;
            return JodaBeanUtils.equal((Object)this.payment, (Object)other.payment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.payment);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("NotionalExchange{");
        buf.append("payment").append('=').append(JodaBeanUtils.toString((Object)this.payment));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<NotionalExchange> {
        private Payment payment;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return this.payment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    this.payment = (Payment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public NotionalExchange build() {
            return new NotionalExchange(this.payment);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("NotionalExchange.Builder{");
            buf.append("payment").append('=').append(JodaBeanUtils.toString((Object)this.payment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Payment> payment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payment", NotionalExchange.class, Payment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return this.payment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends NotionalExchange> builder() {
            return new Builder();
        }

        public Class<? extends NotionalExchange> beanType() {
            return NotionalExchange.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Payment> payment() {
            return this.payment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return ((NotionalExchange)bean).getPayment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

