/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.swap.FxResetCalculation;
import com.opengamma.strata.product.swap.FxResetNotionalExchange;
import com.opengamma.strata.product.swap.NotionalExchange;
import com.opengamma.strata.product.swap.NotionalPaymentPeriod;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class NotionalSchedule
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(get="optional")
    private final FxResetCalculation fxReset;
    @PropertyDefinition(validate="notNull")
    private final ValueSchedule amount;
    @PropertyDefinition
    private final boolean initialExchange;
    @PropertyDefinition
    private final boolean intermediateExchange;
    @PropertyDefinition
    private final boolean finalExchange;
    private static final long serialVersionUID = 1L;

    public static NotionalSchedule of(CurrencyAmount notional) {
        ArgChecker.notNull((Object)notional, (String)"notional");
        return NotionalSchedule.builder().currency(notional.getCurrency()).amount(ValueSchedule.of((double)notional.getAmount())).build();
    }

    public static NotionalSchedule of(Currency currency, double amount) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        return NotionalSchedule.builder().currency(currency).amount(ValueSchedule.of((double)amount)).build();
    }

    public static NotionalSchedule of(Currency currency, ValueSchedule amountSchedule) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        ArgChecker.notNull((Object)amountSchedule, (String)"amountSchedule");
        return NotionalSchedule.builder().currency(currency).amount(amountSchedule).build();
    }

    @ImmutableValidator
    private void validate() {
        if (this.fxReset != null) {
            if (this.fxReset.getReferenceCurrency().equals((Object)this.currency)) {
                throw new IllegalArgumentException(Messages.format((String)"Currency {} must not equal FxResetCalculation reference currency {}", (Object[])new Object[]{this.currency, this.fxReset.getReferenceCurrency()}));
            }
            if (!this.fxReset.getIndex().getCurrencyPair().contains(this.currency)) {
                throw new IllegalArgumentException(Messages.format((String)"Currency {} must be one of those in the FxResetCalculation index {}", (Object[])new Object[]{this.currency, this.fxReset.getIndex()}));
            }
            if (!(this.initialExchange || this.intermediateExchange || this.finalExchange)) {
                throw new IllegalArgumentException(Messages.format((String)"FxResetCalculation index {} was specified but schedule does not include any notional exchanges", (Object)this.fxReset.getIndex()));
            }
        }
    }

    ImmutableList<SwapPaymentEvent> createEvents(List<NotionalPaymentPeriod> payPeriods, LocalDate initialExchangeDate, ReferenceData refData) {
        return NotionalSchedule.createEvents(payPeriods, initialExchangeDate, this.initialExchange, this.intermediateExchange, this.finalExchange, refData);
    }

    static ImmutableList<SwapPaymentEvent> createEvents(List<NotionalPaymentPeriod> payPeriods, LocalDate initialExchangeDate, boolean initialExchange, boolean intermediateExchange, boolean finalExchange, ReferenceData refData) {
        boolean fxResetFound = payPeriods.stream().filter(pp -> pp.getFxResetObservation().isPresent()).findAny().isPresent();
        if (fxResetFound) {
            return NotionalSchedule.createFxResetEvents(payPeriods, initialExchangeDate, initialExchange, intermediateExchange, finalExchange);
        }
        if (initialExchange || intermediateExchange || finalExchange) {
            return NotionalSchedule.createStandardEvents(payPeriods, initialExchangeDate, initialExchange, intermediateExchange, finalExchange);
        }
        return ImmutableList.of();
    }

    private static ImmutableList<SwapPaymentEvent> createFxResetEvents(List<NotionalPaymentPeriod> payPeriods, LocalDate initialExchangeDate, boolean initialExchange, boolean intermediateExchange, boolean finalExchange) {
        ImmutableList.Builder events = ImmutableList.builder();
        for (int i = 0; i < payPeriods.size(); ++i) {
            boolean includeEndPayment;
            NotionalPaymentPeriod period = payPeriods.get(i);
            LocalDate startPaymentDate = i == 0 ? initialExchangeDate : payPeriods.get(i - 1).getPaymentDate();
            boolean includeStartPayment = i == 0 ? initialExchange : intermediateExchange;
            boolean bl = includeEndPayment = i == payPeriods.size() - 1 ? finalExchange : intermediateExchange;
            if (period.getFxResetObservation().isPresent()) {
                FxIndexObservation observation = period.getFxResetObservation().get();
                if (includeStartPayment) {
                    events.add((Object)FxResetNotionalExchange.of(period.getNotionalAmount().negated(), startPaymentDate, observation));
                }
                if (!includeEndPayment) continue;
                events.add((Object)FxResetNotionalExchange.of(period.getNotionalAmount(), period.getPaymentDate(), observation));
                continue;
            }
            if (includeStartPayment) {
                events.add((Object)NotionalExchange.of(CurrencyAmount.of((Currency)period.getCurrency(), (double)(-period.getNotionalAmount().getAmount())), startPaymentDate));
            }
            if (!includeEndPayment) continue;
            events.add((Object)NotionalExchange.of(CurrencyAmount.of((Currency)period.getCurrency(), (double)period.getNotionalAmount().getAmount()), period.getPaymentDate()));
        }
        return events.build();
    }

    private static ImmutableList<SwapPaymentEvent> createStandardEvents(List<NotionalPaymentPeriod> payPeriods, LocalDate initialExchangePaymentDate, boolean initialExchange, boolean intermediateExchange, boolean finalExchange) {
        NotionalPaymentPeriod firstPeriod = payPeriods.get(0);
        ImmutableList.Builder events = ImmutableList.builder();
        if (initialExchange) {
            events.add((Object)NotionalExchange.of(firstPeriod.getNotionalAmount().negated(), initialExchangePaymentDate));
        }
        if (intermediateExchange) {
            for (int i = 0; i < payPeriods.size() - 1; ++i) {
                NotionalPaymentPeriod period1 = payPeriods.get(i);
                NotionalPaymentPeriod period2 = payPeriods.get(i + 1);
                if (period1.getNotionalAmount().getAmount() == period2.getNotionalAmount().getAmount()) continue;
                events.add((Object)NotionalExchange.of(period1.getNotionalAmount().minus(period2.getNotionalAmount()), period1.getPaymentDate()));
            }
        }
        if (finalExchange) {
            NotionalPaymentPeriod lastPeriod = payPeriods.get(payPeriods.size() - 1);
            events.add((Object)NotionalExchange.of(lastPeriod.getNotionalAmount(), lastPeriod.getPaymentDate()));
        }
        return events.build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private NotionalSchedule(Currency currency, FxResetCalculation fxReset, ValueSchedule amount, boolean initialExchange, boolean intermediateExchange, boolean finalExchange) {
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)amount, (String)"amount");
        this.currency = currency;
        this.fxReset = fxReset;
        this.amount = amount;
        this.initialExchange = initialExchange;
        this.intermediateExchange = intermediateExchange;
        this.finalExchange = finalExchange;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Optional<FxResetCalculation> getFxReset() {
        return Optional.ofNullable(this.fxReset);
    }

    public ValueSchedule getAmount() {
        return this.amount;
    }

    public boolean isInitialExchange() {
        return this.initialExchange;
    }

    public boolean isIntermediateExchange() {
        return this.intermediateExchange;
    }

    public boolean isFinalExchange() {
        return this.finalExchange;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            NotionalSchedule other = (NotionalSchedule)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.fxReset, (Object)other.fxReset) && JodaBeanUtils.equal((Object)this.amount, (Object)other.amount) && this.initialExchange == other.initialExchange && this.intermediateExchange == other.intermediateExchange && this.finalExchange == other.finalExchange;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxReset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.amount);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.initialExchange);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.intermediateExchange);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.finalExchange);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("NotionalSchedule{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("fxReset").append('=').append(JodaBeanUtils.toString((Object)this.fxReset)).append(',').append(' ');
        buf.append("amount").append('=').append(JodaBeanUtils.toString((Object)this.amount)).append(',').append(' ');
        buf.append("initialExchange").append('=').append(JodaBeanUtils.toString((Object)this.initialExchange)).append(',').append(' ');
        buf.append("intermediateExchange").append('=').append(JodaBeanUtils.toString((Object)this.intermediateExchange)).append(',').append(' ');
        buf.append("finalExchange").append('=').append(JodaBeanUtils.toString((Object)this.finalExchange));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<NotionalSchedule> {
        private Currency currency;
        private FxResetCalculation fxReset;
        private ValueSchedule amount;
        private boolean initialExchange;
        private boolean intermediateExchange;
        private boolean finalExchange;

        private Builder() {
        }

        private Builder(NotionalSchedule beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.fxReset = beanToCopy.fxReset;
            this.amount = beanToCopy.getAmount();
            this.initialExchange = beanToCopy.isInitialExchange();
            this.intermediateExchange = beanToCopy.isIntermediateExchange();
            this.finalExchange = beanToCopy.isFinalExchange();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case -449555555: {
                    return this.fxReset;
                }
                case -1413853096: {
                    return this.amount;
                }
                case -511982201: {
                    return this.initialExchange;
                }
                case -2147112388: {
                    return this.intermediateExchange;
                }
                case -1048781383: {
                    return this.finalExchange;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -449555555: {
                    this.fxReset = (FxResetCalculation)newValue;
                    break;
                }
                case -1413853096: {
                    this.amount = (ValueSchedule)newValue;
                    break;
                }
                case -511982201: {
                    this.initialExchange = (Boolean)newValue;
                    break;
                }
                case -2147112388: {
                    this.intermediateExchange = (Boolean)newValue;
                    break;
                }
                case -1048781383: {
                    this.finalExchange = (Boolean)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public NotionalSchedule build() {
            return new NotionalSchedule(this.currency, this.fxReset, this.amount, this.initialExchange, this.intermediateExchange, this.finalExchange);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder fxReset(FxResetCalculation fxReset) {
            this.fxReset = fxReset;
            return this;
        }

        public Builder amount(ValueSchedule amount) {
            JodaBeanUtils.notNull((Object)amount, (String)"amount");
            this.amount = amount;
            return this;
        }

        public Builder initialExchange(boolean initialExchange) {
            this.initialExchange = initialExchange;
            return this;
        }

        public Builder intermediateExchange(boolean intermediateExchange) {
            this.intermediateExchange = intermediateExchange;
            return this;
        }

        public Builder finalExchange(boolean finalExchange) {
            this.finalExchange = finalExchange;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("NotionalSchedule.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("fxReset").append('=').append(JodaBeanUtils.toString((Object)this.fxReset)).append(',').append(' ');
            buf.append("amount").append('=').append(JodaBeanUtils.toString((Object)this.amount)).append(',').append(' ');
            buf.append("initialExchange").append('=').append(JodaBeanUtils.toString((Object)this.initialExchange)).append(',').append(' ');
            buf.append("intermediateExchange").append('=').append(JodaBeanUtils.toString((Object)this.intermediateExchange)).append(',').append(' ');
            buf.append("finalExchange").append('=').append(JodaBeanUtils.toString((Object)this.finalExchange));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", NotionalSchedule.class, Currency.class);
        private final MetaProperty<FxResetCalculation> fxReset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fxReset", NotionalSchedule.class, FxResetCalculation.class);
        private final MetaProperty<ValueSchedule> amount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amount", NotionalSchedule.class, ValueSchedule.class);
        private final MetaProperty<Boolean> initialExchange = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"initialExchange", NotionalSchedule.class, Boolean.TYPE);
        private final MetaProperty<Boolean> intermediateExchange = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"intermediateExchange", NotionalSchedule.class, Boolean.TYPE);
        private final MetaProperty<Boolean> finalExchange = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"finalExchange", NotionalSchedule.class, Boolean.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "fxReset", "amount", "initialExchange", "intermediateExchange", "finalExchange"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case -449555555: {
                    return this.fxReset;
                }
                case -1413853096: {
                    return this.amount;
                }
                case -511982201: {
                    return this.initialExchange;
                }
                case -2147112388: {
                    return this.intermediateExchange;
                }
                case -1048781383: {
                    return this.finalExchange;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends NotionalSchedule> beanType() {
            return NotionalSchedule.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<FxResetCalculation> fxReset() {
            return this.fxReset;
        }

        public MetaProperty<ValueSchedule> amount() {
            return this.amount;
        }

        public MetaProperty<Boolean> initialExchange() {
            return this.initialExchange;
        }

        public MetaProperty<Boolean> intermediateExchange() {
            return this.intermediateExchange;
        }

        public MetaProperty<Boolean> finalExchange() {
            return this.finalExchange;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((NotionalSchedule)bean).getCurrency();
                }
                case -449555555: {
                    return ((NotionalSchedule)bean).fxReset;
                }
                case -1413853096: {
                    return ((NotionalSchedule)bean).getAmount();
                }
                case -511982201: {
                    return ((NotionalSchedule)bean).isInitialExchange();
                }
                case -2147112388: {
                    return ((NotionalSchedule)bean).isIntermediateExchange();
                }
                case -1048781383: {
                    return ((NotionalSchedule)bean).isFinalExchange();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

