/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.product.rate.OvernightRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.NegativeRateMethod;
import com.opengamma.strata.product.swap.OvernightAccrualMethod;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RateCalculation;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class OvernightRateCalculation
implements RateCalculation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final OvernightIndex index;
    @PropertyDefinition(validate="notNull")
    private final OvernightAccrualMethod accrualMethod;
    @PropertyDefinition(validate="notNull")
    private final NegativeRateMethod negativeRateMethod;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final int rateCutOffDays;
    @PropertyDefinition(get="optional")
    private final ValueSchedule gearing;
    @PropertyDefinition(get="optional")
    private final ValueSchedule spread;
    private static final long serialVersionUID = 1L;

    public static OvernightRateCalculation of(OvernightIndex index) {
        return OvernightRateCalculation.builder().index(index).build();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.accrualMethod(OvernightAccrualMethod.COMPOUNDED);
        builder.negativeRateMethod(NegativeRateMethod.ALLOW_NEGATIVE);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null && builder.dayCount == null) {
            builder.dayCount = builder.index.getDayCount();
        }
    }

    @Override
    public SwapLegType getType() {
        return SwapLegType.OVERNIGHT;
    }

    @Override
    public void collectCurrencies(ImmutableSet.Builder<Currency> builder) {
        builder.add((Object)this.index.getCurrency());
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        builder.add((Object)this.index);
    }

    @Override
    public ImmutableList<RateAccrualPeriod> createAccrualPeriods(Schedule accrualSchedule, Schedule paymentSchedule, ReferenceData refData) {
        DoubleArray resolvedGearings = ((ValueSchedule)MoreObjects.firstNonNull((Object)this.gearing, (Object)ValueSchedule.ALWAYS_1)).resolveValues(accrualSchedule);
        DoubleArray resolvedSpreads = ((ValueSchedule)MoreObjects.firstNonNull((Object)this.spread, (Object)ValueSchedule.ALWAYS_0)).resolveValues(accrualSchedule);
        ImmutableList.Builder accrualPeriods = ImmutableList.builder();
        for (int i = 0; i < accrualSchedule.size(); ++i) {
            SchedulePeriod period = accrualSchedule.getPeriod(i);
            double yearFraction = period.yearFraction(this.dayCount, accrualSchedule);
            RateComputation rateComputation = this.createRateComputation(period, paymentSchedule, refData);
            accrualPeriods.add((Object)new RateAccrualPeriod(period, yearFraction, rateComputation, resolvedGearings.get(i), resolvedSpreads.get(i), this.negativeRateMethod));
        }
        return accrualPeriods.build();
    }

    private RateComputation createRateComputation(SchedulePeriod period, Schedule paymentSchedule, ReferenceData refData) {
        int effectiveRateCutOffDaysOffset = this.isLastAccrualInPaymentPeriod(period, paymentSchedule) ? this.rateCutOffDays : 0;
        return OvernightRateComputation.of(this.index, period.getStartDate(), period.getEndDate(), effectiveRateCutOffDaysOffset, this.accrualMethod, refData);
    }

    private boolean isLastAccrualInPaymentPeriod(SchedulePeriod period, Schedule paymentSchedule) {
        if (this.rateCutOffDays == 0) {
            return true;
        }
        return paymentSchedule.getPeriods().stream().anyMatch(pp -> pp.getUnadjustedEndDate().equals(period.getUnadjustedEndDate()));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OvernightRateCalculation(DayCount dayCount, OvernightIndex index, OvernightAccrualMethod accrualMethod, NegativeRateMethod negativeRateMethod, int rateCutOffDays, ValueSchedule gearing, ValueSchedule spread) {
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)((Object)accrualMethod), (String)"accrualMethod");
        JodaBeanUtils.notNull((Object)((Object)negativeRateMethod), (String)"negativeRateMethod");
        ArgChecker.notNegative((int)rateCutOffDays, (String)"rateCutOffDays");
        this.dayCount = dayCount;
        this.index = index;
        this.accrualMethod = accrualMethod;
        this.negativeRateMethod = negativeRateMethod;
        this.rateCutOffDays = rateCutOffDays;
        this.gearing = gearing;
        this.spread = spread;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public OvernightIndex getIndex() {
        return this.index;
    }

    public OvernightAccrualMethod getAccrualMethod() {
        return this.accrualMethod;
    }

    public NegativeRateMethod getNegativeRateMethod() {
        return this.negativeRateMethod;
    }

    public int getRateCutOffDays() {
        return this.rateCutOffDays;
    }

    public Optional<ValueSchedule> getGearing() {
        return Optional.ofNullable(this.gearing);
    }

    public Optional<ValueSchedule> getSpread() {
        return Optional.ofNullable(this.spread);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightRateCalculation other = (OvernightRateCalculation)obj;
            return JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)((Object)this.accrualMethod), (Object)((Object)other.accrualMethod)) && JodaBeanUtils.equal((Object)((Object)this.negativeRateMethod), (Object)((Object)other.negativeRateMethod)) && this.rateCutOffDays == other.rateCutOffDays && JodaBeanUtils.equal((Object)this.gearing, (Object)other.gearing) && JodaBeanUtils.equal((Object)this.spread, (Object)other.spread);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.accrualMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.negativeRateMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.rateCutOffDays);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.gearing);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spread);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("OvernightRateCalculation{");
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("accrualMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualMethod))).append(',').append(' ');
        buf.append("negativeRateMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.negativeRateMethod))).append(',').append(' ');
        buf.append("rateCutOffDays").append('=').append(JodaBeanUtils.toString((Object)this.rateCutOffDays)).append(',').append(' ');
        buf.append("gearing").append('=').append(JodaBeanUtils.toString((Object)this.gearing)).append(',').append(' ');
        buf.append("spread").append('=').append(JodaBeanUtils.toString((Object)this.spread));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<OvernightRateCalculation> {
        private DayCount dayCount;
        private OvernightIndex index;
        private OvernightAccrualMethod accrualMethod;
        private NegativeRateMethod negativeRateMethod;
        private int rateCutOffDays;
        private ValueSchedule gearing;
        private ValueSchedule spread;

        private Builder() {
            OvernightRateCalculation.applyDefaults(this);
        }

        private Builder(OvernightRateCalculation beanToCopy) {
            this.dayCount = beanToCopy.getDayCount();
            this.index = beanToCopy.getIndex();
            this.accrualMethod = beanToCopy.getAccrualMethod();
            this.negativeRateMethod = beanToCopy.getNegativeRateMethod();
            this.rateCutOffDays = beanToCopy.getRateCutOffDays();
            this.gearing = beanToCopy.gearing;
            this.spread = beanToCopy.spread;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return this.dayCount;
                }
                case 100346066: {
                    return this.index;
                }
                case -1335729296: {
                    return this.accrualMethod;
                }
                case 1969081334: {
                    return this.negativeRateMethod;
                }
                case -92095804: {
                    return this.rateCutOffDays;
                }
                case -91774989: {
                    return this.gearing;
                }
                case -895684237: {
                    return this.spread;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (OvernightIndex)newValue;
                    break;
                }
                case -1335729296: {
                    this.accrualMethod = (OvernightAccrualMethod)((Object)newValue);
                    break;
                }
                case 1969081334: {
                    this.negativeRateMethod = (NegativeRateMethod)((Object)newValue);
                    break;
                }
                case -92095804: {
                    this.rateCutOffDays = (Integer)newValue;
                    break;
                }
                case -91774989: {
                    this.gearing = (ValueSchedule)newValue;
                    break;
                }
                case -895684237: {
                    this.spread = (ValueSchedule)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public OvernightRateCalculation build() {
            OvernightRateCalculation.preBuild(this);
            return new OvernightRateCalculation(this.dayCount, this.index, this.accrualMethod, this.negativeRateMethod, this.rateCutOffDays, this.gearing, this.spread);
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder index(OvernightIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder accrualMethod(OvernightAccrualMethod accrualMethod) {
            JodaBeanUtils.notNull((Object)((Object)accrualMethod), (String)"accrualMethod");
            this.accrualMethod = accrualMethod;
            return this;
        }

        public Builder negativeRateMethod(NegativeRateMethod negativeRateMethod) {
            JodaBeanUtils.notNull((Object)((Object)negativeRateMethod), (String)"negativeRateMethod");
            this.negativeRateMethod = negativeRateMethod;
            return this;
        }

        public Builder rateCutOffDays(int rateCutOffDays) {
            ArgChecker.notNegative((int)rateCutOffDays, (String)"rateCutOffDays");
            this.rateCutOffDays = rateCutOffDays;
            return this;
        }

        public Builder gearing(ValueSchedule gearing) {
            this.gearing = gearing;
            return this;
        }

        public Builder spread(ValueSchedule spread) {
            this.spread = spread;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("OvernightRateCalculation.Builder{");
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("accrualMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualMethod))).append(',').append(' ');
            buf.append("negativeRateMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.negativeRateMethod))).append(',').append(' ');
            buf.append("rateCutOffDays").append('=').append(JodaBeanUtils.toString((Object)this.rateCutOffDays)).append(',').append(' ');
            buf.append("gearing").append('=').append(JodaBeanUtils.toString((Object)this.gearing)).append(',').append(' ');
            buf.append("spread").append('=').append(JodaBeanUtils.toString((Object)this.spread));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", OvernightRateCalculation.class, DayCount.class);
        private final MetaProperty<OvernightIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", OvernightRateCalculation.class, OvernightIndex.class);
        private final MetaProperty<OvernightAccrualMethod> accrualMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualMethod", OvernightRateCalculation.class, OvernightAccrualMethod.class);
        private final MetaProperty<NegativeRateMethod> negativeRateMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"negativeRateMethod", OvernightRateCalculation.class, NegativeRateMethod.class);
        private final MetaProperty<Integer> rateCutOffDays = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rateCutOffDays", OvernightRateCalculation.class, Integer.TYPE);
        private final MetaProperty<ValueSchedule> gearing = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"gearing", OvernightRateCalculation.class, ValueSchedule.class);
        private final MetaProperty<ValueSchedule> spread = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spread", OvernightRateCalculation.class, ValueSchedule.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"dayCount", "index", "accrualMethod", "negativeRateMethod", "rateCutOffDays", "gearing", "spread"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return this.dayCount;
                }
                case 100346066: {
                    return this.index;
                }
                case -1335729296: {
                    return this.accrualMethod;
                }
                case 1969081334: {
                    return this.negativeRateMethod;
                }
                case -92095804: {
                    return this.rateCutOffDays;
                }
                case -91774989: {
                    return this.gearing;
                }
                case -895684237: {
                    return this.spread;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends OvernightRateCalculation> beanType() {
            return OvernightRateCalculation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<OvernightIndex> index() {
            return this.index;
        }

        public MetaProperty<OvernightAccrualMethod> accrualMethod() {
            return this.accrualMethod;
        }

        public MetaProperty<NegativeRateMethod> negativeRateMethod() {
            return this.negativeRateMethod;
        }

        public MetaProperty<Integer> rateCutOffDays() {
            return this.rateCutOffDays;
        }

        public MetaProperty<ValueSchedule> gearing() {
            return this.gearing;
        }

        public MetaProperty<ValueSchedule> spread() {
            return this.spread;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1905311443: {
                    return ((OvernightRateCalculation)bean).getDayCount();
                }
                case 100346066: {
                    return ((OvernightRateCalculation)bean).getIndex();
                }
                case -1335729296: {
                    return ((OvernightRateCalculation)bean).getAccrualMethod();
                }
                case 1969081334: {
                    return ((OvernightRateCalculation)bean).getNegativeRateMethod();
                }
                case -92095804: {
                    return ((OvernightRateCalculation)bean).getRateCutOffDays();
                }
                case -91774989: {
                    return ((OvernightRateCalculation)bean).gearing;
                }
                case -895684237: {
                    return ((OvernightRateCalculation)bean).spread;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

