/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import java.time.LocalDate;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum PaymentRelativeTo implements NamedEnum
{
    PERIOD_START,
    PERIOD_END;

    private static final EnumNames<PaymentRelativeTo> NAMES;

    @FromString
    public static PaymentRelativeTo of(String name) {
        return (PaymentRelativeTo)NAMES.parse(name);
    }

    LocalDate selectBaseDate(SchedulePeriod period) {
        return this == PERIOD_END ? period.getEndDate() : period.getStartDate();
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(PaymentRelativeTo.class);
    }
}

