/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.ScheduleException;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.CompoundingMethod;
import com.opengamma.strata.product.swap.FxReset;
import com.opengamma.strata.product.swap.FxResetCalculation;
import com.opengamma.strata.product.swap.KnownAmountNotionalSwapPaymentPeriod;
import com.opengamma.strata.product.swap.KnownAmountRateComputation;
import com.opengamma.strata.product.swap.NotionalPaymentPeriod;
import com.opengamma.strata.product.swap.NotionalSchedule;
import com.opengamma.strata.product.swap.PaymentRelativeTo;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class PaymentSchedule
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Frequency paymentFrequency;
    @PropertyDefinition(get="optional")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(validate="notNull")
    private final PaymentRelativeTo paymentRelativeTo;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment paymentDateOffset;
    @PropertyDefinition(validate="notNull")
    private final CompoundingMethod compoundingMethod;
    @PropertyDefinition(get="optional")
    private final LocalDate firstRegularStartDate;
    @PropertyDefinition(get="optional")
    private final LocalDate lastRegularEndDate;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        if (this.firstRegularStartDate != null && this.lastRegularEndDate != null) {
            ArgChecker.inOrderNotEqual((Comparable)this.firstRegularStartDate, (Object)this.lastRegularEndDate, (String)"firstPaymentDate", (String)"lastRegularPaymentDate");
        }
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.paymentRelativeTo(PaymentRelativeTo.PERIOD_END);
        builder.compoundingMethod(CompoundingMethod.NONE);
    }

    public Schedule createSchedule(Schedule accrualSchedule, ReferenceData refData) {
        Schedule paySchedule;
        if (this.paymentFrequency.equals((Object)Frequency.TERM)) {
            if (this.firstRegularStartDate != null && !this.firstRegularStartDate.equals(accrualSchedule.getUnadjustedStartDate()) && !this.firstRegularStartDate.equals(accrualSchedule.getStartDate())) {
                throw new ScheduleException("Unable to create schedule for frequency 'Term' when firstRegularStartDate != startDate", new Object[0]);
            }
            if (this.lastRegularEndDate != null && !this.lastRegularEndDate.equals(accrualSchedule.getUnadjustedEndDate()) && !this.lastRegularEndDate.equals(accrualSchedule.getEndDate())) {
                throw new ScheduleException("Unable to create schedule for frequency 'Term' when lastRegularEndDate != endDate", new Object[0]);
            }
            return accrualSchedule.mergeToTerm();
        }
        int accrualPeriodsPerPayment = this.paymentFrequency.exactDivide(accrualSchedule.getFrequency());
        if (this.firstRegularStartDate != null && this.lastRegularEndDate != null) {
            paySchedule = accrualSchedule.merge(accrualPeriodsPerPayment, this.firstRegularStartDate, this.lastRegularEndDate);
        } else if (this.firstRegularStartDate != null || this.lastRegularEndDate != null) {
            LocalDate firstRegular = this.firstRegularStartDate != null ? this.firstRegularStartDate : accrualSchedule.getInitialStub().map(stub -> stub.getUnadjustedEndDate()).orElse(accrualSchedule.getUnadjustedStartDate());
            LocalDate lastRegular = this.lastRegularEndDate != null ? this.lastRegularEndDate : accrualSchedule.getFinalStub().map(stub -> stub.getUnadjustedStartDate()).orElse(accrualSchedule.getUnadjustedEndDate());
            paySchedule = accrualSchedule.merge(accrualPeriodsPerPayment, firstRegular, lastRegular);
        } else {
            boolean rollForwards = !accrualSchedule.getInitialStub().isPresent();
            paySchedule = accrualSchedule.mergeRegular(accrualPeriodsPerPayment, rollForwards);
        }
        if (this.businessDayAdjustment != null) {
            return paySchedule.toAdjusted(this.businessDayAdjustment.resolve(refData));
        }
        return paySchedule;
    }

    ImmutableList<NotionalPaymentPeriod> createPaymentPeriods(Schedule accrualSchedule, Schedule paymentSchedule, List<RateAccrualPeriod> accrualPeriods, DayCount dayCount, NotionalSchedule notionalSchedule, PayReceive payReceive, ReferenceData refData) {
        DoubleArray notionals = notionalSchedule.getAmount().resolveValues(paymentSchedule);
        DateAdjuster paymentDateAdjuster = this.paymentDateOffset.resolve(refData);
        BiFunction<Integer, SchedulePeriod, Optional<FxReset>> fxResetFn = notionalSchedule.getFxReset().map(calc -> calc.resolve(refData)).orElse((i, p) -> Optional.empty());
        ImmutableList.Builder paymentPeriods = ImmutableList.builder();
        IntFunction<CurrencyAmount> notionalFunction = this.getNotionalSupplierFunction(notionalSchedule, notionals, payReceive);
        if (accrualSchedule == paymentSchedule) {
            for (int index = 0; index < paymentSchedule.size(); ++index) {
                SchedulePeriod period = paymentSchedule.getPeriod(index);
                CurrencyAmount notional = notionalFunction.apply(index);
                ImmutableList paymentAccrualPeriods = ImmutableList.of((Object)accrualPeriods.get(index));
                paymentPeriods.add((Object)this.createPaymentPeriod(index, period, (List<RateAccrualPeriod>)paymentAccrualPeriods, paymentDateAdjuster, fxResetFn, dayCount, notional));
            }
        } else {
            int accrualIndex = 0;
            for (int paymentIndex = 0; paymentIndex < paymentSchedule.size(); ++paymentIndex) {
                SchedulePeriod payPeriod = paymentSchedule.getPeriod(paymentIndex);
                CurrencyAmount notional = notionalFunction.apply(paymentIndex);
                int accrualStartIndex = accrualIndex;
                RateAccrualPeriod accrual = accrualPeriods.get(accrualIndex);
                while (accrual.getUnadjustedEndDate().isBefore(payPeriod.getUnadjustedEndDate())) {
                    accrual = accrualPeriods.get(++accrualIndex);
                }
                List<RateAccrualPeriod> paymentAccrualPeriods = accrualPeriods.subList(accrualStartIndex, accrualIndex + 1);
                paymentPeriods.add((Object)this.createPaymentPeriod(paymentIndex, payPeriod, paymentAccrualPeriods, paymentDateAdjuster, fxResetFn, dayCount, notional));
                ++accrualIndex;
            }
        }
        return paymentPeriods.build();
    }

    private IntFunction<CurrencyAmount> getNotionalSupplierFunction(NotionalSchedule notionalSchedule, DoubleArray notionals, PayReceive payReceive) {
        boolean hasInitialFxNotional = notionalSchedule.getFxReset().isPresent() && notionalSchedule.getFxReset().get().getInitialNotionalValue().isPresent();
        return index -> {
            if (hasInitialFxNotional && index == 0) {
                FxResetCalculation fxReset = notionalSchedule.getFxReset().get();
                double notional = payReceive.normalize(fxReset.getInitialNotionalValue().getAsDouble());
                Currency currency = fxReset.getIndex().getCurrencyPair().other(fxReset.getReferenceCurrency());
                return CurrencyAmount.of((Currency)currency, (double)notional);
            }
            double notional = payReceive.normalize(notionals.get(index));
            return CurrencyAmount.of((Currency)notionalSchedule.getCurrency(), (double)notional);
        };
    }

    private NotionalPaymentPeriod createPaymentPeriod(int paymentPeriodIndex, SchedulePeriod paymentPeriod, List<RateAccrualPeriod> periods, DateAdjuster paymentDateAdjuster, BiFunction<Integer, SchedulePeriod, Optional<FxReset>> fxResetFn, DayCount dayCount, CurrencyAmount notional) {
        LocalDate paymentDate = paymentDateAdjuster.adjust(this.paymentRelativeTo.selectBaseDate(paymentPeriod));
        FxReset fxReset = fxResetFn.apply(paymentPeriodIndex, paymentPeriod).orElse(null);
        if (periods.size() == 1 && periods.get(0).getRateComputation() instanceof KnownAmountRateComputation) {
            CurrencyAmount amount = ((KnownAmountRateComputation)periods.get(0).getRateComputation()).getAmount();
            Payment payment = Payment.of((CurrencyAmount)amount, (LocalDate)paymentDate);
            if (fxReset != null) {
                CurrencyAmount notionalAmount = CurrencyAmount.of((Currency)fxReset.getReferenceCurrency(), (double)amount.getAmount());
                return KnownAmountNotionalSwapPaymentPeriod.of(payment, paymentPeriod, notionalAmount, fxReset.getObservation());
            }
            return KnownAmountNotionalSwapPaymentPeriod.of(payment, paymentPeriod, notional);
        }
        return new RatePaymentPeriod(paymentDate, periods, dayCount, notional.getCurrency(), fxReset, notional.getAmount(), this.compoundingMethod);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private PaymentSchedule(Frequency paymentFrequency, BusinessDayAdjustment businessDayAdjustment, PaymentRelativeTo paymentRelativeTo, DaysAdjustment paymentDateOffset, CompoundingMethod compoundingMethod, LocalDate firstRegularStartDate, LocalDate lastRegularEndDate) {
        JodaBeanUtils.notNull((Object)paymentFrequency, (String)"paymentFrequency");
        JodaBeanUtils.notNull((Object)((Object)paymentRelativeTo), (String)"paymentRelativeTo");
        JodaBeanUtils.notNull((Object)paymentDateOffset, (String)"paymentDateOffset");
        JodaBeanUtils.notNull((Object)((Object)compoundingMethod), (String)"compoundingMethod");
        this.paymentFrequency = paymentFrequency;
        this.businessDayAdjustment = businessDayAdjustment;
        this.paymentRelativeTo = paymentRelativeTo;
        this.paymentDateOffset = paymentDateOffset;
        this.compoundingMethod = compoundingMethod;
        this.firstRegularStartDate = firstRegularStartDate;
        this.lastRegularEndDate = lastRegularEndDate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Frequency getPaymentFrequency() {
        return this.paymentFrequency;
    }

    public Optional<BusinessDayAdjustment> getBusinessDayAdjustment() {
        return Optional.ofNullable(this.businessDayAdjustment);
    }

    public PaymentRelativeTo getPaymentRelativeTo() {
        return this.paymentRelativeTo;
    }

    public DaysAdjustment getPaymentDateOffset() {
        return this.paymentDateOffset;
    }

    public CompoundingMethod getCompoundingMethod() {
        return this.compoundingMethod;
    }

    public Optional<LocalDate> getFirstRegularStartDate() {
        return Optional.ofNullable(this.firstRegularStartDate);
    }

    public Optional<LocalDate> getLastRegularEndDate() {
        return Optional.ofNullable(this.lastRegularEndDate);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PaymentSchedule other = (PaymentSchedule)obj;
            return JodaBeanUtils.equal((Object)this.paymentFrequency, (Object)other.paymentFrequency) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)((Object)this.paymentRelativeTo), (Object)((Object)other.paymentRelativeTo)) && JodaBeanUtils.equal((Object)this.paymentDateOffset, (Object)other.paymentDateOffset) && JodaBeanUtils.equal((Object)((Object)this.compoundingMethod), (Object)((Object)other.compoundingMethod)) && JodaBeanUtils.equal((Object)this.firstRegularStartDate, (Object)other.firstRegularStartDate) && JodaBeanUtils.equal((Object)this.lastRegularEndDate, (Object)other.lastRegularEndDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentFrequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.paymentRelativeTo));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.compoundingMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstRegularStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastRegularEndDate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("PaymentSchedule{");
        buf.append("paymentFrequency").append('=').append(JodaBeanUtils.toString((Object)this.paymentFrequency)).append(',').append(' ');
        buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
        buf.append("paymentRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentRelativeTo))).append(',').append(' ');
        buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
        buf.append("compoundingMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.compoundingMethod))).append(',').append(' ');
        buf.append("firstRegularStartDate").append('=').append(JodaBeanUtils.toString((Object)this.firstRegularStartDate)).append(',').append(' ');
        buf.append("lastRegularEndDate").append('=').append(JodaBeanUtils.toString((Object)this.lastRegularEndDate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<PaymentSchedule> {
        private Frequency paymentFrequency;
        private BusinessDayAdjustment businessDayAdjustment;
        private PaymentRelativeTo paymentRelativeTo;
        private DaysAdjustment paymentDateOffset;
        private CompoundingMethod compoundingMethod;
        private LocalDate firstRegularStartDate;
        private LocalDate lastRegularEndDate;

        private Builder() {
            PaymentSchedule.applyDefaults(this);
        }

        private Builder(PaymentSchedule beanToCopy) {
            this.paymentFrequency = beanToCopy.getPaymentFrequency();
            this.businessDayAdjustment = beanToCopy.businessDayAdjustment;
            this.paymentRelativeTo = beanToCopy.getPaymentRelativeTo();
            this.paymentDateOffset = beanToCopy.getPaymentDateOffset();
            this.compoundingMethod = beanToCopy.getCompoundingMethod();
            this.firstRegularStartDate = beanToCopy.firstRegularStartDate;
            this.lastRegularEndDate = beanToCopy.lastRegularEndDate;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 863656438: {
                    return this.paymentFrequency;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case -1357627123: {
                    return this.paymentRelativeTo;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case -1376171496: {
                    return this.compoundingMethod;
                }
                case 2011803076: {
                    return this.firstRegularStartDate;
                }
                case -1540679645: {
                    return this.lastRegularEndDate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 863656438: {
                    this.paymentFrequency = (Frequency)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -1357627123: {
                    this.paymentRelativeTo = (PaymentRelativeTo)((Object)newValue);
                    break;
                }
                case -716438393: {
                    this.paymentDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -1376171496: {
                    this.compoundingMethod = (CompoundingMethod)((Object)newValue);
                    break;
                }
                case 2011803076: {
                    this.firstRegularStartDate = (LocalDate)newValue;
                    break;
                }
                case -1540679645: {
                    this.lastRegularEndDate = (LocalDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public PaymentSchedule build() {
            return new PaymentSchedule(this.paymentFrequency, this.businessDayAdjustment, this.paymentRelativeTo, this.paymentDateOffset, this.compoundingMethod, this.firstRegularStartDate, this.lastRegularEndDate);
        }

        public Builder paymentFrequency(Frequency paymentFrequency) {
            JodaBeanUtils.notNull((Object)paymentFrequency, (String)"paymentFrequency");
            this.paymentFrequency = paymentFrequency;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder paymentRelativeTo(PaymentRelativeTo paymentRelativeTo) {
            JodaBeanUtils.notNull((Object)((Object)paymentRelativeTo), (String)"paymentRelativeTo");
            this.paymentRelativeTo = paymentRelativeTo;
            return this;
        }

        public Builder paymentDateOffset(DaysAdjustment paymentDateOffset) {
            JodaBeanUtils.notNull((Object)paymentDateOffset, (String)"paymentDateOffset");
            this.paymentDateOffset = paymentDateOffset;
            return this;
        }

        public Builder compoundingMethod(CompoundingMethod compoundingMethod) {
            JodaBeanUtils.notNull((Object)((Object)compoundingMethod), (String)"compoundingMethod");
            this.compoundingMethod = compoundingMethod;
            return this;
        }

        public Builder firstRegularStartDate(LocalDate firstRegularStartDate) {
            this.firstRegularStartDate = firstRegularStartDate;
            return this;
        }

        public Builder lastRegularEndDate(LocalDate lastRegularEndDate) {
            this.lastRegularEndDate = lastRegularEndDate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("PaymentSchedule.Builder{");
            buf.append("paymentFrequency").append('=').append(JodaBeanUtils.toString((Object)this.paymentFrequency)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("paymentRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentRelativeTo))).append(',').append(' ');
            buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
            buf.append("compoundingMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.compoundingMethod))).append(',').append(' ');
            buf.append("firstRegularStartDate").append('=').append(JodaBeanUtils.toString((Object)this.firstRegularStartDate)).append(',').append(' ');
            buf.append("lastRegularEndDate").append('=').append(JodaBeanUtils.toString((Object)this.lastRegularEndDate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Frequency> paymentFrequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentFrequency", PaymentSchedule.class, Frequency.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", PaymentSchedule.class, BusinessDayAdjustment.class);
        private final MetaProperty<PaymentRelativeTo> paymentRelativeTo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentRelativeTo", PaymentSchedule.class, PaymentRelativeTo.class);
        private final MetaProperty<DaysAdjustment> paymentDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDateOffset", PaymentSchedule.class, DaysAdjustment.class);
        private final MetaProperty<CompoundingMethod> compoundingMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"compoundingMethod", PaymentSchedule.class, CompoundingMethod.class);
        private final MetaProperty<LocalDate> firstRegularStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstRegularStartDate", PaymentSchedule.class, LocalDate.class);
        private final MetaProperty<LocalDate> lastRegularEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastRegularEndDate", PaymentSchedule.class, LocalDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"paymentFrequency", "businessDayAdjustment", "paymentRelativeTo", "paymentDateOffset", "compoundingMethod", "firstRegularStartDate", "lastRegularEndDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 863656438: {
                    return this.paymentFrequency;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case -1357627123: {
                    return this.paymentRelativeTo;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case -1376171496: {
                    return this.compoundingMethod;
                }
                case 2011803076: {
                    return this.firstRegularStartDate;
                }
                case -1540679645: {
                    return this.lastRegularEndDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends PaymentSchedule> beanType() {
            return PaymentSchedule.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Frequency> paymentFrequency() {
            return this.paymentFrequency;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<PaymentRelativeTo> paymentRelativeTo() {
            return this.paymentRelativeTo;
        }

        public MetaProperty<DaysAdjustment> paymentDateOffset() {
            return this.paymentDateOffset;
        }

        public MetaProperty<CompoundingMethod> compoundingMethod() {
            return this.compoundingMethod;
        }

        public MetaProperty<LocalDate> firstRegularStartDate() {
            return this.firstRegularStartDate;
        }

        public MetaProperty<LocalDate> lastRegularEndDate() {
            return this.lastRegularEndDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 863656438: {
                    return ((PaymentSchedule)bean).getPaymentFrequency();
                }
                case -1065319863: {
                    return ((PaymentSchedule)bean).businessDayAdjustment;
                }
                case -1357627123: {
                    return ((PaymentSchedule)bean).getPaymentRelativeTo();
                }
                case -716438393: {
                    return ((PaymentSchedule)bean).getPaymentDateOffset();
                }
                case -1376171496: {
                    return ((PaymentSchedule)bean).getCompoundingMethod();
                }
                case 2011803076: {
                    return ((PaymentSchedule)bean).firstRegularStartDate;
                }
                case -1540679645: {
                    return ((PaymentSchedule)bean).lastRegularEndDate;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

