/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.base.MoreObjects;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.NegativeRateMethod;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class RateAccrualPeriod
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedEndDate;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double yearFraction;
    @PropertyDefinition(validate="notNull")
    private final RateComputation rateComputation;
    @PropertyDefinition
    private final double gearing;
    @PropertyDefinition
    private final double spread;
    @PropertyDefinition(validate="notNull")
    private final NegativeRateMethod negativeRateMethod;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.negativeRateMethod(NegativeRateMethod.ALLOW_NEGATIVE);
        builder.gearing(1.0);
    }

    @ImmutableConstructor
    private RateAccrualPeriod(LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate, double yearFraction, RateComputation rateComputation, double gearing, double spread, NegativeRateMethod negativeRateMethod) {
        this.startDate = (LocalDate)ArgChecker.notNull((Object)startDate, (String)"startDate");
        this.endDate = (LocalDate)ArgChecker.notNull((Object)endDate, (String)"endDate");
        this.unadjustedStartDate = (LocalDate)MoreObjects.firstNonNull((Object)unadjustedStartDate, (Object)startDate);
        this.unadjustedEndDate = (LocalDate)MoreObjects.firstNonNull((Object)unadjustedEndDate, (Object)endDate);
        this.yearFraction = ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
        this.rateComputation = (RateComputation)ArgChecker.notNull((Object)rateComputation, (String)"rateComputation");
        this.gearing = gearing;
        this.spread = spread;
        this.negativeRateMethod = (NegativeRateMethod)((Object)ArgChecker.notNull((Object)((Object)negativeRateMethod), (String)"negativeRateMethod"));
        ArgChecker.inOrderNotEqual((Comparable)startDate, (Object)endDate, (String)"startDate", (String)"endDate");
        ArgChecker.inOrderNotEqual((Comparable)this.unadjustedStartDate, (Object)this.unadjustedEndDate, (String)"unadjustedStartDate", (String)"unadjustedEndDate");
    }

    RateAccrualPeriod(SchedulePeriod period, double yearFraction, RateComputation rateComputation) {
        this(period, yearFraction, rateComputation, 1.0, 0.0, NegativeRateMethod.ALLOW_NEGATIVE);
    }

    RateAccrualPeriod(SchedulePeriod period, double yearFraction, RateComputation rateComputation, double gearing, double spread, NegativeRateMethod negativeRateMethod) {
        this.startDate = period.getStartDate();
        this.endDate = period.getEndDate();
        this.unadjustedStartDate = period.getUnadjustedStartDate();
        this.unadjustedEndDate = period.getUnadjustedEndDate();
        this.yearFraction = yearFraction;
        this.rateComputation = rateComputation;
        this.gearing = gearing;
        this.spread = spread;
        this.negativeRateMethod = negativeRateMethod;
    }

    public static Builder builder(SchedulePeriod period) {
        return RateAccrualPeriod.builder().startDate(period.getStartDate()).endDate(period.getEndDate()).unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalDate getUnadjustedStartDate() {
        return this.unadjustedStartDate;
    }

    public LocalDate getUnadjustedEndDate() {
        return this.unadjustedEndDate;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public RateComputation getRateComputation() {
        return this.rateComputation;
    }

    public double getGearing() {
        return this.gearing;
    }

    public double getSpread() {
        return this.spread;
    }

    public NegativeRateMethod getNegativeRateMethod() {
        return this.negativeRateMethod;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RateAccrualPeriod other = (RateAccrualPeriod)obj;
            return JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.unadjustedStartDate, (Object)other.unadjustedStartDate) && JodaBeanUtils.equal((Object)this.unadjustedEndDate, (Object)other.unadjustedEndDate) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((Object)this.rateComputation, (Object)other.rateComputation) && JodaBeanUtils.equal((double)this.gearing, (double)other.gearing) && JodaBeanUtils.equal((double)this.spread, (double)other.spread) && JodaBeanUtils.equal((Object)((Object)this.negativeRateMethod), (Object)((Object)other.negativeRateMethod));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rateComputation);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.gearing);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.spread);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.negativeRateMethod));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(320);
        buf.append("RateAccrualPeriod{");
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
        buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("rateComputation").append('=').append(JodaBeanUtils.toString((Object)this.rateComputation)).append(',').append(' ');
        buf.append("gearing").append('=').append(JodaBeanUtils.toString((Object)this.gearing)).append(',').append(' ');
        buf.append("spread").append('=').append(JodaBeanUtils.toString((Object)this.spread)).append(',').append(' ');
        buf.append("negativeRateMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.negativeRateMethod)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<RateAccrualPeriod> {
        private LocalDate startDate;
        private LocalDate endDate;
        private LocalDate unadjustedStartDate;
        private LocalDate unadjustedEndDate;
        private double yearFraction;
        private RateComputation rateComputation;
        private double gearing;
        private double spread;
        private NegativeRateMethod negativeRateMethod;

        private Builder() {
            RateAccrualPeriod.applyDefaults(this);
        }

        private Builder(RateAccrualPeriod beanToCopy) {
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.unadjustedStartDate = beanToCopy.getUnadjustedStartDate();
            this.unadjustedEndDate = beanToCopy.getUnadjustedEndDate();
            this.yearFraction = beanToCopy.getYearFraction();
            this.rateComputation = beanToCopy.getRateComputation();
            this.gearing = beanToCopy.getGearing();
            this.spread = beanToCopy.getSpread();
            this.negativeRateMethod = beanToCopy.getNegativeRateMethod();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 625350855: {
                    return this.rateComputation;
                }
                case -91774989: {
                    return this.gearing;
                }
                case -895684237: {
                    return this.spread;
                }
                case 1969081334: {
                    return this.negativeRateMethod;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 1457691881: {
                    this.unadjustedStartDate = (LocalDate)newValue;
                    break;
                }
                case 31758114: {
                    this.unadjustedEndDate = (LocalDate)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case 625350855: {
                    this.rateComputation = (RateComputation)newValue;
                    break;
                }
                case -91774989: {
                    this.gearing = (Double)newValue;
                    break;
                }
                case -895684237: {
                    this.spread = (Double)newValue;
                    break;
                }
                case 1969081334: {
                    this.negativeRateMethod = (NegativeRateMethod)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public RateAccrualPeriod build() {
            return new RateAccrualPeriod(this.startDate, this.endDate, this.unadjustedStartDate, this.unadjustedEndDate, this.yearFraction, this.rateComputation, this.gearing, this.spread, this.negativeRateMethod);
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder unadjustedStartDate(LocalDate unadjustedStartDate) {
            JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
            this.unadjustedStartDate = unadjustedStartDate;
            return this;
        }

        public Builder unadjustedEndDate(LocalDate unadjustedEndDate) {
            JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
            this.unadjustedEndDate = unadjustedEndDate;
            return this;
        }

        public Builder yearFraction(double yearFraction) {
            ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
            this.yearFraction = yearFraction;
            return this;
        }

        public Builder rateComputation(RateComputation rateComputation) {
            JodaBeanUtils.notNull((Object)rateComputation, (String)"rateComputation");
            this.rateComputation = rateComputation;
            return this;
        }

        public Builder gearing(double gearing) {
            this.gearing = gearing;
            return this;
        }

        public Builder spread(double spread) {
            this.spread = spread;
            return this;
        }

        public Builder negativeRateMethod(NegativeRateMethod negativeRateMethod) {
            JodaBeanUtils.notNull((Object)((Object)negativeRateMethod), (String)"negativeRateMethod");
            this.negativeRateMethod = negativeRateMethod;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(320);
            buf.append("RateAccrualPeriod.Builder{");
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
            buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("rateComputation").append('=').append(JodaBeanUtils.toString((Object)this.rateComputation)).append(',').append(' ');
            buf.append("gearing").append('=').append(JodaBeanUtils.toString((Object)this.gearing)).append(',').append(' ');
            buf.append("spread").append('=').append(JodaBeanUtils.toString((Object)this.spread)).append(',').append(' ');
            buf.append("negativeRateMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.negativeRateMethod)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", RateAccrualPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", RateAccrualPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedStartDate", RateAccrualPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedEndDate", RateAccrualPeriod.class, LocalDate.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", RateAccrualPeriod.class, Double.TYPE);
        private final MetaProperty<RateComputation> rateComputation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rateComputation", RateAccrualPeriod.class, RateComputation.class);
        private final MetaProperty<Double> gearing = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"gearing", RateAccrualPeriod.class, Double.TYPE);
        private final MetaProperty<Double> spread = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spread", RateAccrualPeriod.class, Double.TYPE);
        private final MetaProperty<NegativeRateMethod> negativeRateMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"negativeRateMethod", RateAccrualPeriod.class, NegativeRateMethod.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"startDate", "endDate", "unadjustedStartDate", "unadjustedEndDate", "yearFraction", "rateComputation", "gearing", "spread", "negativeRateMethod"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 625350855: {
                    return this.rateComputation;
                }
                case -91774989: {
                    return this.gearing;
                }
                case -895684237: {
                    return this.spread;
                }
                case 1969081334: {
                    return this.negativeRateMethod;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends RateAccrualPeriod> beanType() {
            return RateAccrualPeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<LocalDate> unadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        public MetaProperty<LocalDate> unadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<RateComputation> rateComputation() {
            return this.rateComputation;
        }

        public MetaProperty<Double> gearing() {
            return this.gearing;
        }

        public MetaProperty<Double> spread() {
            return this.spread;
        }

        public MetaProperty<NegativeRateMethod> negativeRateMethod() {
            return this.negativeRateMethod;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return ((RateAccrualPeriod)bean).getStartDate();
                }
                case -1607727319: {
                    return ((RateAccrualPeriod)bean).getEndDate();
                }
                case 1457691881: {
                    return ((RateAccrualPeriod)bean).getUnadjustedStartDate();
                }
                case 31758114: {
                    return ((RateAccrualPeriod)bean).getUnadjustedEndDate();
                }
                case -1731780257: {
                    return ((RateAccrualPeriod)bean).getYearFraction();
                }
                case 625350855: {
                    return ((RateAccrualPeriod)bean).getRateComputation();
                }
                case -91774989: {
                    return ((RateAccrualPeriod)bean).getGearing();
                }
                case -895684237: {
                    return ((RateAccrualPeriod)bean).getSpread();
                }
                case 1969081334: {
                    return ((RateAccrualPeriod)bean).getNegativeRateMethod();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

