/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.NotionalPaymentPeriod;
import com.opengamma.strata.product.swap.NotionalSchedule;
import com.opengamma.strata.product.swap.PaymentSchedule;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RateCalculation;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.ScheduledSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class RateCalculationSwapLeg
implements ScheduledSwapLeg,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PeriodicSchedule accrualSchedule;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PaymentSchedule paymentSchedule;
    @PropertyDefinition(validate="notNull")
    private final NotionalSchedule notionalSchedule;
    @PropertyDefinition(validate="notNull")
    private final RateCalculation calculation;
    private static final long serialVersionUID = 1L;

    @Override
    @DerivedProperty
    public SwapLegType getType() {
        return this.calculation.getType();
    }

    @Override
    @DerivedProperty
    public AdjustableDate getStartDate() {
        return this.accrualSchedule.calculatedStartDate();
    }

    @Override
    @DerivedProperty
    public AdjustableDate getEndDate() {
        return this.accrualSchedule.calculatedEndDate();
    }

    @Override
    @DerivedProperty
    public Currency getCurrency() {
        return this.notionalSchedule.getCurrency();
    }

    @Override
    public void collectCurrencies(ImmutableSet.Builder<Currency> builder) {
        builder.add((Object)this.getCurrency());
        this.calculation.collectCurrencies(builder);
        this.notionalSchedule.getFxReset().ifPresent(fxReset -> builder.add((Object)fxReset.getReferenceCurrency()));
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        this.calculation.collectIndices(builder);
        this.notionalSchedule.getFxReset().ifPresent(fxReset -> builder.add((Object)fxReset.getIndex()));
    }

    @Override
    public RateCalculationSwapLeg replaceStartDate(LocalDate adjustedStartDate) {
        return this.toBuilder().accrualSchedule(this.accrualSchedule.replaceStartDate(adjustedStartDate)).build();
    }

    @Override
    public ResolvedSwapLeg resolve(ReferenceData refData) {
        DayCount dayCount = this.calculation.getDayCount();
        Schedule resolvedAccruals = this.accrualSchedule.createSchedule(refData);
        Schedule resolvedPayments = this.paymentSchedule.createSchedule(resolvedAccruals, refData);
        ImmutableList<RateAccrualPeriod> accrualPeriods = this.calculation.createAccrualPeriods(resolvedAccruals, resolvedPayments, refData);
        ImmutableList<NotionalPaymentPeriod> payPeriods = this.paymentSchedule.createPaymentPeriods(resolvedAccruals, resolvedPayments, (List<RateAccrualPeriod>)accrualPeriods, dayCount, this.notionalSchedule, this.payReceive, refData);
        LocalDate startDate = ((RateAccrualPeriod)accrualPeriods.get(0)).getStartDate();
        ImmutableList<SwapPaymentEvent> payEvents = this.notionalSchedule.createEvents((List<NotionalPaymentPeriod>)payPeriods, startDate, refData);
        return new ResolvedSwapLeg(this.getType(), this.payReceive, (List<? extends SwapPaymentPeriod>)payPeriods, (List<? extends SwapPaymentEvent>)payEvents, this.getCurrency());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private RateCalculationSwapLeg(PayReceive payReceive, PeriodicSchedule accrualSchedule, PaymentSchedule paymentSchedule, NotionalSchedule notionalSchedule, RateCalculation calculation) {
        JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
        JodaBeanUtils.notNull((Object)accrualSchedule, (String)"accrualSchedule");
        JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
        JodaBeanUtils.notNull((Object)notionalSchedule, (String)"notionalSchedule");
        JodaBeanUtils.notNull((Object)calculation, (String)"calculation");
        this.payReceive = payReceive;
        this.accrualSchedule = accrualSchedule;
        this.paymentSchedule = paymentSchedule;
        this.notionalSchedule = notionalSchedule;
        this.calculation = calculation;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    @Override
    public PeriodicSchedule getAccrualSchedule() {
        return this.accrualSchedule;
    }

    @Override
    public PaymentSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public NotionalSchedule getNotionalSchedule() {
        return this.notionalSchedule;
    }

    public RateCalculation getCalculation() {
        return this.calculation;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RateCalculationSwapLeg other = (RateCalculationSwapLeg)obj;
            return JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal((Object)this.accrualSchedule, (Object)other.accrualSchedule) && JodaBeanUtils.equal((Object)this.paymentSchedule, (Object)other.paymentSchedule) && JodaBeanUtils.equal((Object)this.notionalSchedule, (Object)other.notionalSchedule) && JodaBeanUtils.equal((Object)this.calculation, (Object)other.calculation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.notionalSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.calculation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(320);
        buf.append("RateCalculationSwapLeg{");
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("accrualSchedule").append('=').append(JodaBeanUtils.toString((Object)this.accrualSchedule)).append(',').append(' ');
        buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
        buf.append("notionalSchedule").append('=').append(JodaBeanUtils.toString((Object)this.notionalSchedule)).append(',').append(' ');
        buf.append("calculation").append('=').append(JodaBeanUtils.toString((Object)this.calculation)).append(',').append(' ');
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.getType()))).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.getStartDate())).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.getEndDate())).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.getCurrency()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<RateCalculationSwapLeg> {
        private PayReceive payReceive;
        private PeriodicSchedule accrualSchedule;
        private PaymentSchedule paymentSchedule;
        private NotionalSchedule notionalSchedule;
        private RateCalculation calculation;

        private Builder() {
        }

        private Builder(RateCalculationSwapLeg beanToCopy) {
            this.payReceive = beanToCopy.getPayReceive();
            this.accrualSchedule = beanToCopy.getAccrualSchedule();
            this.paymentSchedule = beanToCopy.getPaymentSchedule();
            this.notionalSchedule = beanToCopy.getNotionalSchedule();
            this.calculation = beanToCopy.getCalculation();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 304659814: {
                    return this.accrualSchedule;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case 1447860727: {
                    return this.notionalSchedule;
                }
                case -934682935: {
                    return this.calculation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case 304659814: {
                    this.accrualSchedule = (PeriodicSchedule)newValue;
                    break;
                }
                case -1499086147: {
                    this.paymentSchedule = (PaymentSchedule)newValue;
                    break;
                }
                case 1447860727: {
                    this.notionalSchedule = (NotionalSchedule)newValue;
                    break;
                }
                case -934682935: {
                    this.calculation = (RateCalculation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public RateCalculationSwapLeg build() {
            return new RateCalculationSwapLeg(this.payReceive, this.accrualSchedule, this.paymentSchedule, this.notionalSchedule, this.calculation);
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder accrualSchedule(PeriodicSchedule accrualSchedule) {
            JodaBeanUtils.notNull((Object)accrualSchedule, (String)"accrualSchedule");
            this.accrualSchedule = accrualSchedule;
            return this;
        }

        public Builder paymentSchedule(PaymentSchedule paymentSchedule) {
            JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
            this.paymentSchedule = paymentSchedule;
            return this;
        }

        public Builder notionalSchedule(NotionalSchedule notionalSchedule) {
            JodaBeanUtils.notNull((Object)notionalSchedule, (String)"notionalSchedule");
            this.notionalSchedule = notionalSchedule;
            return this;
        }

        public Builder calculation(RateCalculation calculation) {
            JodaBeanUtils.notNull((Object)calculation, (String)"calculation");
            this.calculation = calculation;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(320);
            buf.append("RateCalculationSwapLeg.Builder{");
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("accrualSchedule").append('=').append(JodaBeanUtils.toString((Object)this.accrualSchedule)).append(',').append(' ');
            buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
            buf.append("notionalSchedule").append('=').append(JodaBeanUtils.toString((Object)this.notionalSchedule)).append(',').append(' ');
            buf.append("calculation").append('=').append(JodaBeanUtils.toString((Object)this.calculation)).append(',').append(' ');
            buf.append("type").append('=').append(JodaBeanUtils.toString(null)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString(null)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString(null)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", RateCalculationSwapLeg.class, PayReceive.class);
        private final MetaProperty<PeriodicSchedule> accrualSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualSchedule", RateCalculationSwapLeg.class, PeriodicSchedule.class);
        private final MetaProperty<PaymentSchedule> paymentSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentSchedule", RateCalculationSwapLeg.class, PaymentSchedule.class);
        private final MetaProperty<NotionalSchedule> notionalSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notionalSchedule", RateCalculationSwapLeg.class, NotionalSchedule.class);
        private final MetaProperty<RateCalculation> calculation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"calculation", RateCalculationSwapLeg.class, RateCalculation.class);
        private final MetaProperty<SwapLegType> type = DirectMetaProperty.ofDerived((MetaBean)this, (String)"type", RateCalculationSwapLeg.class, SwapLegType.class);
        private final MetaProperty<AdjustableDate> startDate = DirectMetaProperty.ofDerived((MetaBean)this, (String)"startDate", RateCalculationSwapLeg.class, AdjustableDate.class);
        private final MetaProperty<AdjustableDate> endDate = DirectMetaProperty.ofDerived((MetaBean)this, (String)"endDate", RateCalculationSwapLeg.class, AdjustableDate.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofDerived((MetaBean)this, (String)"currency", RateCalculationSwapLeg.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payReceive", "accrualSchedule", "paymentSchedule", "notionalSchedule", "calculation", "type", "startDate", "endDate", "currency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 304659814: {
                    return this.accrualSchedule;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case 1447860727: {
                    return this.notionalSchedule;
                }
                case -934682935: {
                    return this.calculation;
                }
                case 3575610: {
                    return this.type;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends RateCalculationSwapLeg> beanType() {
            return RateCalculationSwapLeg.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<PeriodicSchedule> accrualSchedule() {
            return this.accrualSchedule;
        }

        public MetaProperty<PaymentSchedule> paymentSchedule() {
            return this.paymentSchedule;
        }

        public MetaProperty<NotionalSchedule> notionalSchedule() {
            return this.notionalSchedule;
        }

        public MetaProperty<RateCalculation> calculation() {
            return this.calculation;
        }

        public MetaProperty<SwapLegType> type() {
            return this.type;
        }

        public MetaProperty<AdjustableDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<AdjustableDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return ((RateCalculationSwapLeg)bean).getPayReceive();
                }
                case 304659814: {
                    return ((RateCalculationSwapLeg)bean).getAccrualSchedule();
                }
                case -1499086147: {
                    return ((RateCalculationSwapLeg)bean).getPaymentSchedule();
                }
                case 1447860727: {
                    return ((RateCalculationSwapLeg)bean).getNotionalSchedule();
                }
                case -934682935: {
                    return ((RateCalculationSwapLeg)bean).getCalculation();
                }
                case 3575610: {
                    return ((RateCalculationSwapLeg)bean).getType();
                }
                case -2129778896: {
                    return ((RateCalculationSwapLeg)bean).getStartDate();
                }
                case -1607727319: {
                    return ((RateCalculationSwapLeg)bean).getEndDate();
                }
                case 575402001: {
                    return ((RateCalculationSwapLeg)bean).getCurrency();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

