/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.swap.CompoundingMethod;
import com.opengamma.strata.product.swap.FxReset;
import com.opengamma.strata.product.swap.NotionalPaymentPeriod;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class RatePaymentPeriod
implements NotionalPaymentPeriod,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate paymentDate;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<RateAccrualPeriod> accrualPeriods;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(get="optional")
    private final FxReset fxReset;
    @PropertyDefinition
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final CompoundingMethod compoundingMethod;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.compoundingMethod(CompoundingMethod.NONE);
    }

    @ImmutableValidator
    private void validate() {
        if (this.fxReset != null) {
            Currency notionalCcy = this.fxReset.getReferenceCurrency();
            if (this.fxReset.getReferenceCurrency().equals((Object)this.currency)) {
                throw new IllegalArgumentException(Messages.format((String)"Payment currency {} must not equal notional currency {} when FX reset applies", (Object[])new Object[]{this.currency, notionalCcy}));
            }
            if (!this.fxReset.getIndex().getCurrencyPair().contains(this.currency)) {
                throw new IllegalArgumentException(Messages.format((String)"Payment currency {} must be one of those in the FxReset index {}", (Object[])new Object[]{this.currency, this.fxReset.getIndex()}));
            }
        }
    }

    @Override
    public LocalDate getStartDate() {
        return ((RateAccrualPeriod)this.accrualPeriods.get(0)).getStartDate();
    }

    @Override
    public LocalDate getEndDate() {
        return ((RateAccrualPeriod)this.accrualPeriods.get(this.accrualPeriods.size() - 1)).getEndDate();
    }

    @Override
    public CurrencyAmount getNotionalAmount() {
        if (this.fxReset != null) {
            return CurrencyAmount.of((Currency)this.fxReset.getReferenceCurrency(), (double)this.notional);
        }
        return CurrencyAmount.of((Currency)this.currency, (double)this.notional);
    }

    @Override
    public Optional<FxIndexObservation> getFxResetObservation() {
        return this.getFxReset().map(fxr -> fxr.getObservation());
    }

    public boolean isCompoundingApplicable() {
        return this.accrualPeriods.size() > 1 && this.compoundingMethod != CompoundingMethod.NONE;
    }

    @Override
    public RatePaymentPeriod adjustPaymentDate(TemporalAdjuster adjuster) {
        LocalDate adjusted = this.paymentDate.with(adjuster);
        return adjusted.equals(this.paymentDate) ? this : this.toBuilder().paymentDate(adjusted).build();
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        this.accrualPeriods.stream().forEach(accrual -> accrual.getRateComputation().collectIndices(builder));
        this.getFxReset().ifPresent(fxReset -> builder.add((Object)fxReset.getIndex()));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    RatePaymentPeriod(LocalDate paymentDate, List<RateAccrualPeriod> accrualPeriods, DayCount dayCount, Currency currency, FxReset fxReset, double notional, CompoundingMethod compoundingMethod) {
        JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
        JodaBeanUtils.notEmpty(accrualPeriods, (String)"accrualPeriods");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)((Object)compoundingMethod), (String)"compoundingMethod");
        this.paymentDate = paymentDate;
        this.accrualPeriods = ImmutableList.copyOf(accrualPeriods);
        this.dayCount = dayCount;
        this.currency = currency;
        this.fxReset = fxReset;
        this.notional = notional;
        this.compoundingMethod = compoundingMethod;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public ImmutableList<RateAccrualPeriod> getAccrualPeriods() {
        return this.accrualPeriods;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public Optional<FxReset> getFxReset() {
        return Optional.ofNullable(this.fxReset);
    }

    public double getNotional() {
        return this.notional;
    }

    public CompoundingMethod getCompoundingMethod() {
        return this.compoundingMethod;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RatePaymentPeriod other = (RatePaymentPeriod)obj;
            return JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate) && JodaBeanUtils.equal(this.accrualPeriods, other.accrualPeriods) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.fxReset, (Object)other.fxReset) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)((Object)this.compoundingMethod), (Object)((Object)other.compoundingMethod));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.accrualPeriods);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxReset);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.compoundingMethod));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("RatePaymentPeriod{");
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
        buf.append("accrualPeriods").append('=').append(JodaBeanUtils.toString(this.accrualPeriods)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("fxReset").append('=').append(JodaBeanUtils.toString((Object)this.fxReset)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("compoundingMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.compoundingMethod)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<RatePaymentPeriod> {
        private LocalDate paymentDate;
        private List<RateAccrualPeriod> accrualPeriods = ImmutableList.of();
        private DayCount dayCount;
        private Currency currency;
        private FxReset fxReset;
        private double notional;
        private CompoundingMethod compoundingMethod;

        private Builder() {
            RatePaymentPeriod.applyDefaults(this);
        }

        private Builder(RatePaymentPeriod beanToCopy) {
            this.paymentDate = beanToCopy.getPaymentDate();
            this.accrualPeriods = beanToCopy.getAccrualPeriods();
            this.dayCount = beanToCopy.getDayCount();
            this.currency = beanToCopy.getCurrency();
            this.fxReset = beanToCopy.fxReset;
            this.notional = beanToCopy.getNotional();
            this.compoundingMethod = beanToCopy.getCompoundingMethod();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1540873516: {
                    return this.paymentDate;
                }
                case -92208605: {
                    return this.accrualPeriods;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 575402001: {
                    return this.currency;
                }
                case -449555555: {
                    return this.fxReset;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1376171496: {
                    return this.compoundingMethod;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1540873516: {
                    this.paymentDate = (LocalDate)newValue;
                    break;
                }
                case -92208605: {
                    this.accrualPeriods = (List)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -449555555: {
                    this.fxReset = (FxReset)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1376171496: {
                    this.compoundingMethod = (CompoundingMethod)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public RatePaymentPeriod build() {
            return new RatePaymentPeriod(this.paymentDate, this.accrualPeriods, this.dayCount, this.currency, this.fxReset, this.notional, this.compoundingMethod);
        }

        public Builder paymentDate(LocalDate paymentDate) {
            JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
            this.paymentDate = paymentDate;
            return this;
        }

        public Builder accrualPeriods(List<RateAccrualPeriod> accrualPeriods) {
            JodaBeanUtils.notEmpty(accrualPeriods, (String)"accrualPeriods");
            this.accrualPeriods = accrualPeriods;
            return this;
        }

        public Builder accrualPeriods(RateAccrualPeriod ... accrualPeriods) {
            return this.accrualPeriods((List<RateAccrualPeriod>)ImmutableList.copyOf((Object[])accrualPeriods));
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder fxReset(FxReset fxReset) {
            this.fxReset = fxReset;
            return this;
        }

        public Builder notional(double notional) {
            this.notional = notional;
            return this;
        }

        public Builder compoundingMethod(CompoundingMethod compoundingMethod) {
            JodaBeanUtils.notNull((Object)((Object)compoundingMethod), (String)"compoundingMethod");
            this.compoundingMethod = compoundingMethod;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("RatePaymentPeriod.Builder{");
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
            buf.append("accrualPeriods").append('=').append(JodaBeanUtils.toString(this.accrualPeriods)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("fxReset").append('=').append(JodaBeanUtils.toString((Object)this.fxReset)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("compoundingMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.compoundingMethod)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", RatePaymentPeriod.class, LocalDate.class);
        private final MetaProperty<ImmutableList<RateAccrualPeriod>> accrualPeriods = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualPeriods", RatePaymentPeriod.class, ImmutableList.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", RatePaymentPeriod.class, DayCount.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", RatePaymentPeriod.class, Currency.class);
        private final MetaProperty<FxReset> fxReset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fxReset", RatePaymentPeriod.class, FxReset.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", RatePaymentPeriod.class, Double.TYPE);
        private final MetaProperty<CompoundingMethod> compoundingMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"compoundingMethod", RatePaymentPeriod.class, CompoundingMethod.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"paymentDate", "accrualPeriods", "dayCount", "currency", "fxReset", "notional", "compoundingMethod"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1540873516: {
                    return this.paymentDate;
                }
                case -92208605: {
                    return this.accrualPeriods;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 575402001: {
                    return this.currency;
                }
                case -449555555: {
                    return this.fxReset;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1376171496: {
                    return this.compoundingMethod;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends RatePaymentPeriod> beanType() {
            return RatePaymentPeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> paymentDate() {
            return this.paymentDate;
        }

        public MetaProperty<ImmutableList<RateAccrualPeriod>> accrualPeriods() {
            return this.accrualPeriods;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<FxReset> fxReset() {
            return this.fxReset;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<CompoundingMethod> compoundingMethod() {
            return this.compoundingMethod;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1540873516: {
                    return ((RatePaymentPeriod)bean).getPaymentDate();
                }
                case -92208605: {
                    return ((RatePaymentPeriod)bean).getAccrualPeriods();
                }
                case 1905311443: {
                    return ((RatePaymentPeriod)bean).getDayCount();
                }
                case 575402001: {
                    return ((RatePaymentPeriod)bean).getCurrency();
                }
                case -449555555: {
                    return ((RatePaymentPeriod)bean).fxReset;
                }
                case 1585636160: {
                    return ((RatePaymentPeriod)bean).getNotional();
                }
                case -1376171496: {
                    return ((RatePaymentPeriod)bean).getCompoundingMethod();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

