/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.NotionalPaymentPeriod;
import com.opengamma.strata.product.swap.NotionalSchedule;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class RatePeriodSwapLeg
implements SwapLeg,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SwapLegType type;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<RatePaymentPeriod> paymentPeriods;
    @PropertyDefinition
    private final boolean initialExchange;
    @PropertyDefinition
    private final boolean intermediateExchange;
    @PropertyDefinition
    private final boolean finalExchange;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<SwapPaymentEvent> paymentEvents;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment paymentBusinessDayAdjustment;
    private final transient Currency currency;
    private static final long serialVersionUID = 1L;

    @ImmutableConstructor
    private RatePeriodSwapLeg(SwapLegType type, PayReceive payReceive, List<RatePaymentPeriod> paymentPeriods, boolean initialExchange, boolean intermediateExchange, boolean finalExchange, List<SwapPaymentEvent> paymentEvents, BusinessDayAdjustment paymentBusinessDayAdjustment) {
        JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
        JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
        JodaBeanUtils.notEmpty(paymentPeriods, (String)"paymentPeriods");
        JodaBeanUtils.notNull(paymentEvents, (String)"paymentEvents");
        this.type = type;
        this.payReceive = payReceive;
        this.paymentPeriods = ImmutableList.copyOf(paymentPeriods);
        this.initialExchange = initialExchange;
        this.intermediateExchange = intermediateExchange;
        this.finalExchange = finalExchange;
        this.paymentBusinessDayAdjustment = (BusinessDayAdjustment)MoreObjects.firstNonNull((Object)paymentBusinessDayAdjustment, (Object)BusinessDayAdjustment.NONE);
        this.paymentEvents = ImmutableList.copyOf(paymentEvents);
        Stream<Currency> periodCurrencies = paymentPeriods.stream().map(SwapPaymentPeriod::getCurrency);
        Stream<Currency> eventCurrencies = paymentEvents.stream().map(SwapPaymentEvent::getCurrency);
        Set currencies = Stream.concat(periodCurrencies, eventCurrencies).collect(Collectors.toSet());
        if (currencies.size() > 1) {
            throw new IllegalArgumentException("Swap leg must have a single currency, found: " + currencies);
        }
        this.currency = (Currency)Iterables.getOnlyElement(currencies);
    }

    private Object readResolve() {
        return new RatePeriodSwapLeg(this.type, this.payReceive, (List<RatePaymentPeriod>)this.paymentPeriods, this.initialExchange, this.intermediateExchange, this.finalExchange, (List<SwapPaymentEvent>)this.paymentEvents, this.paymentBusinessDayAdjustment);
    }

    @Override
    public AdjustableDate getStartDate() {
        return AdjustableDate.of((LocalDate)((RatePaymentPeriod)this.paymentPeriods.get(0)).getStartDate());
    }

    @Override
    public AdjustableDate getEndDate() {
        return AdjustableDate.of((LocalDate)((RatePaymentPeriod)this.paymentPeriods.get(this.paymentPeriods.size() - 1)).getEndDate());
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public void collectCurrencies(ImmutableSet.Builder<Currency> builder) {
        builder.add((Object)this.currency);
        for (RatePaymentPeriod paymentPeriod : this.paymentPeriods) {
            builder.add((Object)paymentPeriod.getCurrency());
            paymentPeriod.getFxReset().ifPresent(fxr -> builder.add((Object)fxr.getReferenceCurrency()));
        }
        this.paymentEvents.forEach(ev -> builder.add((Object)ev.getCurrency()));
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        this.paymentPeriods.stream().forEach(period -> period.collectIndices(builder));
    }

    @Override
    public RatePeriodSwapLeg replaceStartDate(LocalDate adjustedStartDate) {
        if (adjustedStartDate.isAfter(this.getEndDate().getUnadjusted())) {
            throw new IllegalArgumentException("Cannot alter leg to have start date after end date");
        }
        ImmutableList filteredPeriods = (ImmutableList)this.paymentPeriods.stream().filter(period -> !period.getStartDate().isBefore(adjustedStartDate)).collect(Guavate.toImmutableList());
        ImmutableList filteredEvents = (ImmutableList)this.paymentEvents.stream().filter(event -> !event.getPaymentDate().isBefore(adjustedStartDate)).collect(Guavate.toImmutableList());
        RatePeriodSwapLeg result = this.toBuilder().paymentPeriods((List<RatePaymentPeriod>)filteredPeriods).paymentEvents((List<SwapPaymentEvent>)filteredEvents).build();
        if (!result.getStartDate().getUnadjusted().equals(adjustedStartDate)) {
            throw new IllegalArgumentException(Messages.format((String)"Cannot alter leg unless start date {} exactly matches one of the periods: {}", (Object[])new Object[]{adjustedStartDate, this.paymentPeriods}));
        }
        return result;
    }

    @Override
    public ResolvedSwapLeg resolve(ReferenceData refData) {
        DateAdjuster paymentDateAdjuster = this.paymentBusinessDayAdjustment.resolve(refData);
        ImmutableList adjusted = (ImmutableList)this.paymentPeriods.stream().map(pp -> pp.adjustPaymentDate((TemporalAdjuster)paymentDateAdjuster)).collect(Guavate.toImmutableList());
        ImmutableList<SwapPaymentEvent> payEvents = this.createEvents((List<NotionalPaymentPeriod>)adjusted, paymentDateAdjuster, refData);
        return new ResolvedSwapLeg(this.type, this.payReceive, (List<? extends SwapPaymentPeriod>)adjusted, (List<? extends SwapPaymentEvent>)payEvents, this.currency);
    }

    private ImmutableList<SwapPaymentEvent> createEvents(List<NotionalPaymentPeriod> adjPaymentPeriods, DateAdjuster paymentDateAdjuster, ReferenceData refData) {
        ImmutableList.Builder events = ImmutableList.builder();
        LocalDate initialExchangeDate = paymentDateAdjuster.adjust(adjPaymentPeriods.get(0).getStartDate());
        events.addAll(NotionalSchedule.createEvents(adjPaymentPeriods, initialExchangeDate, this.initialExchange, this.intermediateExchange, this.finalExchange, refData));
        this.paymentEvents.forEach(pe -> events.add((Object)pe.adjustPaymentDate((TemporalAdjuster)paymentDateAdjuster)));
        return events.build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SwapLegType getType() {
        return this.type;
    }

    @Override
    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    public ImmutableList<RatePaymentPeriod> getPaymentPeriods() {
        return this.paymentPeriods;
    }

    public boolean isInitialExchange() {
        return this.initialExchange;
    }

    public boolean isIntermediateExchange() {
        return this.intermediateExchange;
    }

    public boolean isFinalExchange() {
        return this.finalExchange;
    }

    public ImmutableList<SwapPaymentEvent> getPaymentEvents() {
        return this.paymentEvents;
    }

    public BusinessDayAdjustment getPaymentBusinessDayAdjustment() {
        return this.paymentBusinessDayAdjustment;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RatePeriodSwapLeg other = (RatePeriodSwapLeg)obj;
            return JodaBeanUtils.equal((Object)((Object)this.type), (Object)((Object)other.type)) && JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal(this.paymentPeriods, other.paymentPeriods) && this.initialExchange == other.initialExchange && this.intermediateExchange == other.intermediateExchange && this.finalExchange == other.finalExchange && JodaBeanUtils.equal(this.paymentEvents, other.paymentEvents) && JodaBeanUtils.equal((Object)this.paymentBusinessDayAdjustment, (Object)other.paymentBusinessDayAdjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.type));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.paymentPeriods);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.initialExchange);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.intermediateExchange);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.finalExchange);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.paymentEvents);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentBusinessDayAdjustment);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("RatePeriodSwapLeg{");
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("paymentPeriods").append('=').append(JodaBeanUtils.toString(this.paymentPeriods)).append(',').append(' ');
        buf.append("initialExchange").append('=').append(JodaBeanUtils.toString((Object)this.initialExchange)).append(',').append(' ');
        buf.append("intermediateExchange").append('=').append(JodaBeanUtils.toString((Object)this.intermediateExchange)).append(',').append(' ');
        buf.append("finalExchange").append('=').append(JodaBeanUtils.toString((Object)this.finalExchange)).append(',').append(' ');
        buf.append("paymentEvents").append('=').append(JodaBeanUtils.toString(this.paymentEvents)).append(',').append(' ');
        buf.append("paymentBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.paymentBusinessDayAdjustment));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<RatePeriodSwapLeg> {
        private SwapLegType type;
        private PayReceive payReceive;
        private List<RatePaymentPeriod> paymentPeriods = ImmutableList.of();
        private boolean initialExchange;
        private boolean intermediateExchange;
        private boolean finalExchange;
        private List<SwapPaymentEvent> paymentEvents = ImmutableList.of();
        private BusinessDayAdjustment paymentBusinessDayAdjustment;

        private Builder() {
        }

        private Builder(RatePeriodSwapLeg beanToCopy) {
            this.type = beanToCopy.getType();
            this.payReceive = beanToCopy.getPayReceive();
            this.paymentPeriods = beanToCopy.getPaymentPeriods();
            this.initialExchange = beanToCopy.isInitialExchange();
            this.intermediateExchange = beanToCopy.isIntermediateExchange();
            this.finalExchange = beanToCopy.isFinalExchange();
            this.paymentEvents = beanToCopy.getPaymentEvents();
            this.paymentBusinessDayAdjustment = beanToCopy.getPaymentBusinessDayAdjustment();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case -885469925: {
                    return this.payReceive;
                }
                case -1674414612: {
                    return this.paymentPeriods;
                }
                case -511982201: {
                    return this.initialExchange;
                }
                case -2147112388: {
                    return this.intermediateExchange;
                }
                case -1048781383: {
                    return this.finalExchange;
                }
                case 1031856831: {
                    return this.paymentEvents;
                }
                case -1420083229: {
                    return this.paymentBusinessDayAdjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    this.type = (SwapLegType)((Object)newValue);
                    break;
                }
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case -1674414612: {
                    this.paymentPeriods = (List)newValue;
                    break;
                }
                case -511982201: {
                    this.initialExchange = (Boolean)newValue;
                    break;
                }
                case -2147112388: {
                    this.intermediateExchange = (Boolean)newValue;
                    break;
                }
                case -1048781383: {
                    this.finalExchange = (Boolean)newValue;
                    break;
                }
                case 1031856831: {
                    this.paymentEvents = (List)newValue;
                    break;
                }
                case -1420083229: {
                    this.paymentBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public RatePeriodSwapLeg build() {
            return new RatePeriodSwapLeg(this.type, this.payReceive, this.paymentPeriods, this.initialExchange, this.intermediateExchange, this.finalExchange, this.paymentEvents, this.paymentBusinessDayAdjustment);
        }

        public Builder type(SwapLegType type) {
            JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
            this.type = type;
            return this;
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder paymentPeriods(List<RatePaymentPeriod> paymentPeriods) {
            JodaBeanUtils.notEmpty(paymentPeriods, (String)"paymentPeriods");
            this.paymentPeriods = paymentPeriods;
            return this;
        }

        public Builder paymentPeriods(RatePaymentPeriod ... paymentPeriods) {
            return this.paymentPeriods((List<RatePaymentPeriod>)ImmutableList.copyOf((Object[])paymentPeriods));
        }

        public Builder initialExchange(boolean initialExchange) {
            this.initialExchange = initialExchange;
            return this;
        }

        public Builder intermediateExchange(boolean intermediateExchange) {
            this.intermediateExchange = intermediateExchange;
            return this;
        }

        public Builder finalExchange(boolean finalExchange) {
            this.finalExchange = finalExchange;
            return this;
        }

        public Builder paymentEvents(List<SwapPaymentEvent> paymentEvents) {
            JodaBeanUtils.notNull(paymentEvents, (String)"paymentEvents");
            this.paymentEvents = paymentEvents;
            return this;
        }

        public Builder paymentEvents(SwapPaymentEvent ... paymentEvents) {
            return this.paymentEvents((List<SwapPaymentEvent>)ImmutableList.copyOf((Object[])paymentEvents));
        }

        public Builder paymentBusinessDayAdjustment(BusinessDayAdjustment paymentBusinessDayAdjustment) {
            JodaBeanUtils.notNull((Object)paymentBusinessDayAdjustment, (String)"paymentBusinessDayAdjustment");
            this.paymentBusinessDayAdjustment = paymentBusinessDayAdjustment;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("RatePeriodSwapLeg.Builder{");
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("paymentPeriods").append('=').append(JodaBeanUtils.toString(this.paymentPeriods)).append(',').append(' ');
            buf.append("initialExchange").append('=').append(JodaBeanUtils.toString((Object)this.initialExchange)).append(',').append(' ');
            buf.append("intermediateExchange").append('=').append(JodaBeanUtils.toString((Object)this.intermediateExchange)).append(',').append(' ');
            buf.append("finalExchange").append('=').append(JodaBeanUtils.toString((Object)this.finalExchange)).append(',').append(' ');
            buf.append("paymentEvents").append('=').append(JodaBeanUtils.toString(this.paymentEvents)).append(',').append(' ');
            buf.append("paymentBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.paymentBusinessDayAdjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SwapLegType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", RatePeriodSwapLeg.class, SwapLegType.class);
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", RatePeriodSwapLeg.class, PayReceive.class);
        private final MetaProperty<ImmutableList<RatePaymentPeriod>> paymentPeriods = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentPeriods", RatePeriodSwapLeg.class, ImmutableList.class);
        private final MetaProperty<Boolean> initialExchange = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"initialExchange", RatePeriodSwapLeg.class, Boolean.TYPE);
        private final MetaProperty<Boolean> intermediateExchange = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"intermediateExchange", RatePeriodSwapLeg.class, Boolean.TYPE);
        private final MetaProperty<Boolean> finalExchange = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"finalExchange", RatePeriodSwapLeg.class, Boolean.TYPE);
        private final MetaProperty<ImmutableList<SwapPaymentEvent>> paymentEvents = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentEvents", RatePeriodSwapLeg.class, ImmutableList.class);
        private final MetaProperty<BusinessDayAdjustment> paymentBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentBusinessDayAdjustment", RatePeriodSwapLeg.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"type", "payReceive", "paymentPeriods", "initialExchange", "intermediateExchange", "finalExchange", "paymentEvents", "paymentBusinessDayAdjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case -885469925: {
                    return this.payReceive;
                }
                case -1674414612: {
                    return this.paymentPeriods;
                }
                case -511982201: {
                    return this.initialExchange;
                }
                case -2147112388: {
                    return this.intermediateExchange;
                }
                case -1048781383: {
                    return this.finalExchange;
                }
                case 1031856831: {
                    return this.paymentEvents;
                }
                case -1420083229: {
                    return this.paymentBusinessDayAdjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends RatePeriodSwapLeg> beanType() {
            return RatePeriodSwapLeg.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SwapLegType> type() {
            return this.type;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<ImmutableList<RatePaymentPeriod>> paymentPeriods() {
            return this.paymentPeriods;
        }

        public MetaProperty<Boolean> initialExchange() {
            return this.initialExchange;
        }

        public MetaProperty<Boolean> intermediateExchange() {
            return this.intermediateExchange;
        }

        public MetaProperty<Boolean> finalExchange() {
            return this.finalExchange;
        }

        public MetaProperty<ImmutableList<SwapPaymentEvent>> paymentEvents() {
            return this.paymentEvents;
        }

        public MetaProperty<BusinessDayAdjustment> paymentBusinessDayAdjustment() {
            return this.paymentBusinessDayAdjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return ((RatePeriodSwapLeg)bean).getType();
                }
                case -885469925: {
                    return ((RatePeriodSwapLeg)bean).getPayReceive();
                }
                case -1674414612: {
                    return ((RatePeriodSwapLeg)bean).getPaymentPeriods();
                }
                case -511982201: {
                    return ((RatePeriodSwapLeg)bean).isInitialExchange();
                }
                case -2147112388: {
                    return ((RatePeriodSwapLeg)bean).isIntermediateExchange();
                }
                case -1048781383: {
                    return ((RatePeriodSwapLeg)bean).isFinalExchange();
                }
                case 1031856831: {
                    return ((RatePeriodSwapLeg)bean).getPaymentEvents();
                }
                case -1420083229: {
                    return ((RatePeriodSwapLeg)bean).getPaymentBusinessDayAdjustment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

