/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.product.swap.IborRateResetMethod;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResetSchedule
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Frequency resetFrequency;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(validate="notNull")
    private final IborRateResetMethod resetMethod;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.resetMethod(IborRateResetMethod.UNWEIGHTED);
    }

    Function<SchedulePeriod, Schedule> createSchedule(RollConvention rollConvention, ReferenceData refData) {
        return accrualPeriod -> accrualPeriod.subSchedule(this.resetFrequency, rollConvention, StubConvention.SHORT_FINAL, this.businessDayAdjustment).createSchedule(refData, false);
    }

    Function<SchedulePeriod, Schedule> createSchedule(RollConvention rollConvention, ReferenceData refData, boolean combinePeriodsIfNecessary) {
        return accrualPeriod -> accrualPeriod.subSchedule(this.resetFrequency, rollConvention, StubConvention.SHORT_FINAL, this.businessDayAdjustment).createSchedule(refData, combinePeriodsIfNecessary);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResetSchedule(Frequency resetFrequency, BusinessDayAdjustment businessDayAdjustment, IborRateResetMethod resetMethod) {
        JodaBeanUtils.notNull((Object)resetFrequency, (String)"resetFrequency");
        JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        JodaBeanUtils.notNull((Object)((Object)resetMethod), (String)"resetMethod");
        this.resetFrequency = resetFrequency;
        this.businessDayAdjustment = businessDayAdjustment;
        this.resetMethod = resetMethod;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Frequency getResetFrequency() {
        return this.resetFrequency;
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment;
    }

    public IborRateResetMethod getResetMethod() {
        return this.resetMethod;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResetSchedule other = (ResetSchedule)obj;
            return JodaBeanUtils.equal((Object)this.resetFrequency, (Object)other.resetFrequency) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)((Object)this.resetMethod), (Object)((Object)other.resetMethod));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.resetFrequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.resetMethod));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ResetSchedule{");
        buf.append("resetFrequency").append('=').append(JodaBeanUtils.toString((Object)this.resetFrequency)).append(',').append(' ');
        buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
        buf.append("resetMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.resetMethod)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResetSchedule> {
        private Frequency resetFrequency;
        private BusinessDayAdjustment businessDayAdjustment;
        private IborRateResetMethod resetMethod;

        private Builder() {
            ResetSchedule.applyDefaults(this);
        }

        private Builder(ResetSchedule beanToCopy) {
            this.resetFrequency = beanToCopy.getResetFrequency();
            this.businessDayAdjustment = beanToCopy.getBusinessDayAdjustment();
            this.resetMethod = beanToCopy.getResetMethod();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 101322957: {
                    return this.resetFrequency;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case -958176496: {
                    return this.resetMethod;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 101322957: {
                    this.resetFrequency = (Frequency)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -958176496: {
                    this.resetMethod = (IborRateResetMethod)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResetSchedule build() {
            return new ResetSchedule(this.resetFrequency, this.businessDayAdjustment, this.resetMethod);
        }

        public Builder resetFrequency(Frequency resetFrequency) {
            JodaBeanUtils.notNull((Object)resetFrequency, (String)"resetFrequency");
            this.resetFrequency = resetFrequency;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder resetMethod(IborRateResetMethod resetMethod) {
            JodaBeanUtils.notNull((Object)((Object)resetMethod), (String)"resetMethod");
            this.resetMethod = resetMethod;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ResetSchedule.Builder{");
            buf.append("resetFrequency").append('=').append(JodaBeanUtils.toString((Object)this.resetFrequency)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("resetMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.resetMethod)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Frequency> resetFrequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"resetFrequency", ResetSchedule.class, Frequency.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", ResetSchedule.class, BusinessDayAdjustment.class);
        private final MetaProperty<IborRateResetMethod> resetMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"resetMethod", ResetSchedule.class, IborRateResetMethod.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"resetFrequency", "businessDayAdjustment", "resetMethod"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 101322957: {
                    return this.resetFrequency;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case -958176496: {
                    return this.resetMethod;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResetSchedule> beanType() {
            return ResetSchedule.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Frequency> resetFrequency() {
            return this.resetFrequency;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<IborRateResetMethod> resetMethod() {
            return this.resetMethod;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 101322957: {
                    return ((ResetSchedule)bean).getResetFrequency();
                }
                case -1065319863: {
                    return ((ResetSchedule)bean).getBusinessDayAdjustment();
                }
                case -958176496: {
                    return ((ResetSchedule)bean).getResetMethod();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

