/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedSwap
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<ResolvedSwapLeg> legs;
    private final transient ImmutableSet<Currency> currencies;
    private final transient ImmutableSet<Index> indices;
    private static final long serialVersionUID = 1L;

    public static ResolvedSwap of(ResolvedSwapLeg ... legs) {
        ArgChecker.notEmpty((Object[])legs, (String)"legs");
        return new ResolvedSwap((List<ResolvedSwapLeg>)ImmutableList.copyOf((Object[])legs));
    }

    @ImmutableConstructor
    private ResolvedSwap(List<ResolvedSwapLeg> legs) {
        JodaBeanUtils.notEmpty(legs, (String)"legs");
        this.legs = ImmutableList.copyOf(legs);
        this.currencies = ResolvedSwap.buildCurrencies(legs);
        this.indices = ResolvedSwap.buildIndices(legs);
    }

    ResolvedSwap(ImmutableList<ResolvedSwapLeg> legs, ImmutableSet<Currency> currencies, ImmutableSet<Index> indices) {
        this.legs = legs;
        this.currencies = currencies;
        this.indices = indices;
    }

    private static ImmutableSet<Currency> buildCurrencies(List<ResolvedSwapLeg> legs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ResolvedSwapLeg leg : legs) {
            builder.add((Object)leg.getCurrency());
        }
        return builder.build();
    }

    private static ImmutableSet<Index> buildIndices(List<ResolvedSwapLeg> legs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ResolvedSwapLeg leg : legs) {
            leg.collectIndices((ImmutableSet.Builder<Index>)builder);
        }
        return builder.build();
    }

    private Object readResolve() {
        return new ResolvedSwap((List<ResolvedSwapLeg>)this.legs);
    }

    public ImmutableList<ResolvedSwapLeg> getLegs(SwapLegType type) {
        return (ImmutableList)this.legs.stream().filter(leg -> leg.getType() == type).collect(Guavate.toImmutableList());
    }

    public Optional<ResolvedSwapLeg> getLeg(PayReceive payReceive) {
        return this.legs.stream().filter(leg -> leg.getPayReceive() == payReceive).findFirst();
    }

    public Optional<ResolvedSwapLeg> getPayLeg() {
        return this.getLeg(PayReceive.PAY);
    }

    public Optional<ResolvedSwapLeg> getReceiveLeg() {
        return this.getLeg(PayReceive.RECEIVE);
    }

    @DerivedProperty
    public LocalDate getStartDate() {
        return this.legs.stream().map(ResolvedSwapLeg::getStartDate).min(Comparator.naturalOrder()).get();
    }

    @DerivedProperty
    public LocalDate getEndDate() {
        return this.legs.stream().map(ResolvedSwapLeg::getEndDate).max(Comparator.naturalOrder()).get();
    }

    public boolean isCrossCurrency() {
        return this.currencies.size() > 1;
    }

    public ImmutableSet<Currency> allPaymentCurrencies() {
        return this.currencies;
    }

    public ImmutableSet<Index> allIndices() {
        return this.indices;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<ResolvedSwapLeg> getLegs() {
        return this.legs;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedSwap other = (ResolvedSwap)obj;
            return JodaBeanUtils.equal(this.legs, other.legs);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.legs);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ResolvedSwap{");
        buf.append("legs").append('=').append(JodaBeanUtils.toString(this.legs)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.getStartDate())).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.getEndDate()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedSwap> {
        private List<ResolvedSwapLeg> legs = ImmutableList.of();

        private Builder() {
        }

        private Builder(ResolvedSwap beanToCopy) {
            this.legs = beanToCopy.getLegs();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3317797: {
                    return this.legs;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3317797: {
                    this.legs = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedSwap build() {
            return new ResolvedSwap(this.legs);
        }

        public Builder legs(List<ResolvedSwapLeg> legs) {
            JodaBeanUtils.notEmpty(legs, (String)"legs");
            this.legs = legs;
            return this;
        }

        public Builder legs(ResolvedSwapLeg ... legs) {
            return this.legs((List<ResolvedSwapLeg>)ImmutableList.copyOf((Object[])legs));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ResolvedSwap.Builder{");
            buf.append("legs").append('=').append(JodaBeanUtils.toString(this.legs)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString(null)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<ResolvedSwapLeg>> legs = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legs", ResolvedSwap.class, ImmutableList.class);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofDerived((MetaBean)this, (String)"startDate", ResolvedSwap.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofDerived((MetaBean)this, (String)"endDate", ResolvedSwap.class, LocalDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"legs", "startDate", "endDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3317797: {
                    return this.legs;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedSwap> beanType() {
            return ResolvedSwap.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<ResolvedSwapLeg>> legs() {
            return this.legs;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3317797: {
                    return ((ResolvedSwap)bean).getLegs();
                }
                case -2129778896: {
                    return ((ResolvedSwap)bean).getStartDate();
                }
                case -1607727319: {
                    return ((ResolvedSwap)bean).getEndDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

