/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.NotionalPaymentPeriod;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedSwapLeg
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SwapLegType type;
    @PropertyDefinition(validate="notNull")
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notEmpty", builderType="List<? extends SwapPaymentPeriod>")
    private final ImmutableList<SwapPaymentPeriod> paymentPeriods;
    @PropertyDefinition(validate="notNull", builderType="List<? extends SwapPaymentEvent>")
    private final ImmutableList<SwapPaymentEvent> paymentEvents;
    private final transient Currency currency;
    private static final long serialVersionUID = 1L;

    @ImmutableConstructor
    private ResolvedSwapLeg(SwapLegType type, PayReceive payReceive, List<? extends SwapPaymentPeriod> paymentPeriods, List<? extends SwapPaymentEvent> paymentEvents) {
        this.type = (SwapLegType)((Object)ArgChecker.notNull((Object)((Object)type), (String)"type"));
        this.payReceive = (PayReceive)((Object)ArgChecker.notNull((Object)((Object)payReceive), (String)"payReceive"));
        this.paymentPeriods = ImmutableList.copyOf(paymentPeriods);
        this.paymentEvents = ImmutableList.copyOf(paymentEvents);
        Stream<Currency> periodCurrencies = paymentPeriods.stream().map(SwapPaymentPeriod::getCurrency);
        Stream<Currency> eventCurrencies = paymentEvents.stream().map(SwapPaymentEvent::getCurrency);
        Set currencies = Stream.concat(periodCurrencies, eventCurrencies).collect(Collectors.toSet());
        if (currencies.size() > 1) {
            throw new IllegalArgumentException("Swap leg must have a single currency, found: " + currencies);
        }
        this.currency = (Currency)Iterables.getOnlyElement(currencies);
    }

    ResolvedSwapLeg(SwapLegType type, PayReceive payReceive, List<? extends SwapPaymentPeriod> paymentPeriods, List<? extends SwapPaymentEvent> paymentEvents, Currency currency) {
        this.type = type;
        this.payReceive = payReceive;
        this.paymentPeriods = ImmutableList.copyOf(paymentPeriods);
        this.paymentEvents = ImmutableList.copyOf(paymentEvents);
        this.currency = currency;
    }

    private Object readResolve() {
        return new ResolvedSwapLeg(this.type, this.payReceive, (List<? extends SwapPaymentPeriod>)this.paymentPeriods, (List<? extends SwapPaymentEvent>)this.paymentEvents);
    }

    public LocalDate getStartDate() {
        return ((SwapPaymentPeriod)this.paymentPeriods.get(0)).getStartDate();
    }

    public LocalDate getEndDate() {
        return ((SwapPaymentPeriod)this.paymentPeriods.get(this.paymentPeriods.size() - 1)).getEndDate();
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Optional<SwapPaymentPeriod> findPaymentPeriod(LocalDate date) {
        return this.paymentPeriods.stream().filter(period -> period.getStartDate().compareTo(date) < 0 && date.compareTo(period.getEndDate()) <= 0).findFirst();
    }

    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        this.paymentPeriods.stream().forEach(period -> period.collectIndices(builder));
    }

    public Optional<CurrencyAmount> findNotional(LocalDate date) {
        SwapPaymentPeriod paymentPeriod = !date.isAfter(((SwapPaymentPeriod)this.paymentPeriods.get(0)).getStartDate()) ? (SwapPaymentPeriod)this.paymentPeriods.get(0) : (date.isAfter(((SwapPaymentPeriod)this.paymentPeriods.get(this.paymentPeriods.size() - 1)).getEndDate()) ? (SwapPaymentPeriod)this.paymentPeriods.get(this.paymentPeriods.size() - 1) : this.findPaymentPeriod(date).get());
        if (!(paymentPeriod instanceof NotionalPaymentPeriod)) {
            return Optional.empty();
        }
        return Optional.of(((NotionalPaymentPeriod)paymentPeriod).getNotionalAmount());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public SwapLegType getType() {
        return this.type;
    }

    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    public ImmutableList<SwapPaymentPeriod> getPaymentPeriods() {
        return this.paymentPeriods;
    }

    public ImmutableList<SwapPaymentEvent> getPaymentEvents() {
        return this.paymentEvents;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedSwapLeg other = (ResolvedSwapLeg)obj;
            return JodaBeanUtils.equal((Object)((Object)this.type), (Object)((Object)other.type)) && JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal(this.paymentPeriods, other.paymentPeriods) && JodaBeanUtils.equal(this.paymentEvents, other.paymentEvents);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.type));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.paymentPeriods);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.paymentEvents);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("ResolvedSwapLeg{");
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("paymentPeriods").append('=').append(JodaBeanUtils.toString(this.paymentPeriods)).append(',').append(' ');
        buf.append("paymentEvents").append('=').append(JodaBeanUtils.toString(this.paymentEvents));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedSwapLeg> {
        private SwapLegType type;
        private PayReceive payReceive;
        private List<? extends SwapPaymentPeriod> paymentPeriods = ImmutableList.of();
        private List<? extends SwapPaymentEvent> paymentEvents = ImmutableList.of();

        private Builder() {
        }

        private Builder(ResolvedSwapLeg beanToCopy) {
            this.type = beanToCopy.getType();
            this.payReceive = beanToCopy.getPayReceive();
            this.paymentPeriods = beanToCopy.getPaymentPeriods();
            this.paymentEvents = beanToCopy.getPaymentEvents();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case -885469925: {
                    return this.payReceive;
                }
                case -1674414612: {
                    return this.paymentPeriods;
                }
                case 1031856831: {
                    return this.paymentEvents;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    this.type = (SwapLegType)((Object)newValue);
                    break;
                }
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case -1674414612: {
                    this.paymentPeriods = (List)newValue;
                    break;
                }
                case 1031856831: {
                    this.paymentEvents = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedSwapLeg build() {
            return new ResolvedSwapLeg(this.type, this.payReceive, (List)this.paymentPeriods, (List)this.paymentEvents);
        }

        public Builder type(SwapLegType type) {
            JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
            this.type = type;
            return this;
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder paymentPeriods(List<? extends SwapPaymentPeriod> paymentPeriods) {
            JodaBeanUtils.notEmpty(paymentPeriods, (String)"paymentPeriods");
            this.paymentPeriods = paymentPeriods;
            return this;
        }

        public Builder paymentPeriods(SwapPaymentPeriod ... paymentPeriods) {
            return this.paymentPeriods((List<? extends SwapPaymentPeriod>)ImmutableList.copyOf((Object[])paymentPeriods));
        }

        public Builder paymentEvents(List<? extends SwapPaymentEvent> paymentEvents) {
            JodaBeanUtils.notNull(paymentEvents, (String)"paymentEvents");
            this.paymentEvents = paymentEvents;
            return this;
        }

        public Builder paymentEvents(SwapPaymentEvent ... paymentEvents) {
            return this.paymentEvents((List<? extends SwapPaymentEvent>)ImmutableList.copyOf((Object[])paymentEvents));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ResolvedSwapLeg.Builder{");
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("paymentPeriods").append('=').append(JodaBeanUtils.toString(this.paymentPeriods)).append(',').append(' ');
            buf.append("paymentEvents").append('=').append(JodaBeanUtils.toString(this.paymentEvents));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SwapLegType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", ResolvedSwapLeg.class, SwapLegType.class);
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", ResolvedSwapLeg.class, PayReceive.class);
        private final MetaProperty<ImmutableList<SwapPaymentPeriod>> paymentPeriods = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentPeriods", ResolvedSwapLeg.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<SwapPaymentEvent>> paymentEvents = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentEvents", ResolvedSwapLeg.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"type", "payReceive", "paymentPeriods", "paymentEvents"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case -885469925: {
                    return this.payReceive;
                }
                case -1674414612: {
                    return this.paymentPeriods;
                }
                case 1031856831: {
                    return this.paymentEvents;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedSwapLeg> beanType() {
            return ResolvedSwapLeg.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SwapLegType> type() {
            return this.type;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<ImmutableList<SwapPaymentPeriod>> paymentPeriods() {
            return this.paymentPeriods;
        }

        public MetaProperty<ImmutableList<SwapPaymentEvent>> paymentEvents() {
            return this.paymentEvents;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return ((ResolvedSwapLeg)bean).getType();
                }
                case -885469925: {
                    return ((ResolvedSwapLeg)bean).getPayReceive();
                }
                case -1674414612: {
                    return ((ResolvedSwapLeg)bean).getPaymentPeriods();
                }
                case 1031856831: {
                    return ((ResolvedSwapLeg)bean).getPaymentEvents();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

