/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.common.SummarizerUtils;
import com.opengamma.strata.product.swap.FixedRateCalculation;
import com.opengamma.strata.product.swap.IborRateCalculation;
import com.opengamma.strata.product.swap.InflationRateCalculation;
import com.opengamma.strata.product.swap.KnownAmountSwapLeg;
import com.opengamma.strata.product.swap.NotionalSchedule;
import com.opengamma.strata.product.swap.OvernightAccrualMethod;
import com.opengamma.strata.product.swap.OvernightRateCalculation;
import com.opengamma.strata.product.swap.RateCalculation;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.RatePeriodSwapLeg;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class Swap
implements Product,
Resolvable<ResolvedSwap>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notEmpty", builderType="List<? extends SwapLeg>")
    private final ImmutableList<SwapLeg> legs;
    private static final long serialVersionUID = 1L;

    public static Swap of(SwapLeg ... legs) {
        ArgChecker.notEmpty((Object[])legs, (String)"legs");
        return new Swap((List<? extends SwapLeg>)ImmutableList.copyOf((Object[])legs));
    }

    public static Swap of(List<? extends SwapLeg> legs) {
        ArgChecker.notEmpty(legs, (String)"legs");
        return new Swap((List<? extends SwapLeg>)ImmutableList.copyOf(legs));
    }

    public ImmutableList<SwapLeg> getLegs(SwapLegType type) {
        return (ImmutableList)this.legs.stream().filter(leg -> leg.getType() == type).collect(Guavate.toImmutableList());
    }

    public Optional<SwapLeg> getLeg(PayReceive payReceive) {
        return this.legs.stream().filter(leg -> leg.getPayReceive() == payReceive).findFirst();
    }

    public Optional<SwapLeg> getPayLeg() {
        return this.getLeg(PayReceive.PAY);
    }

    public Optional<SwapLeg> getReceiveLeg() {
        return this.getLeg(PayReceive.RECEIVE);
    }

    @DerivedProperty
    public AdjustableDate getStartDate() {
        return this.legs.stream().map(SwapLeg::getStartDate).min(Comparator.comparing(adjDate -> adjDate.getUnadjusted())).get();
    }

    @DerivedProperty
    public AdjustableDate getEndDate() {
        return this.legs.stream().map(SwapLeg::getEndDate).max(Comparator.comparing(adjDate -> adjDate.getUnadjusted())).get();
    }

    @Override
    public ImmutableSet<Currency> allPaymentCurrencies() {
        return (ImmutableSet)this.legs.stream().map(leg -> leg.getCurrency()).collect(Guavate.toImmutableSet());
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.legs.stream().forEach(leg -> leg.collectCurrencies((ImmutableSet.Builder<Currency>)builder));
        return builder.build();
    }

    public ImmutableSet<Index> allIndices() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.legs.stream().forEach(leg -> leg.collectIndices((ImmutableSet.Builder<Index>)builder));
        return builder.build();
    }

    public String summaryDescription() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(SummarizerUtils.datePeriod(this.getStartDate().getUnadjusted(), this.getEndDate().getUnadjusted()));
        buf.append(' ');
        if (this.getLegs().size() == 2 && this.getPayLeg().isPresent() && this.getReceiveLeg().isPresent() && this.getLegs().stream().allMatch(leg -> leg instanceof RateCalculationSwapLeg)) {
            String recNotional;
            SwapLeg payLeg = this.getPayLeg().get();
            SwapLeg recLeg = this.getReceiveLeg().get();
            String payNotional = this.notional(payLeg);
            if (payNotional.equals(recNotional = this.notional(recLeg))) {
                buf.append(recNotional);
                buf.append(" Rec ");
                buf.append(this.legSummary(recLeg));
                buf.append(" / Pay ");
                buf.append(this.legSummary(payLeg));
            } else {
                buf.append("Rec ");
                buf.append(this.legSummary(recLeg));
                buf.append(' ');
                buf.append(recNotional);
                buf.append(" / Pay ");
                buf.append(this.legSummary(payLeg));
                buf.append(' ');
                buf.append(payNotional);
            }
        } else {
            buf.append(this.getLegs().stream().map(leg -> (SummarizerUtils.payReceive(leg.getPayReceive()) + " " + this.legSummary((SwapLeg)leg) + " " + this.notional((SwapLeg)leg)).trim()).collect(Collectors.joining(" / ")));
        }
        buf.append(" : ");
        buf.append(SummarizerUtils.dateRange(this.getStartDate().getUnadjusted(), this.getEndDate().getUnadjusted()));
        return buf.toString();
    }

    private String notional(SwapLeg leg) {
        if (leg instanceof RateCalculationSwapLeg) {
            RateCalculationSwapLeg rcLeg = (RateCalculationSwapLeg)leg;
            NotionalSchedule notionalSchedule = rcLeg.getNotionalSchedule();
            ValueSchedule amount = notionalSchedule.getAmount();
            double notional = amount.getInitialValue();
            String vary = !amount.getSteps().isEmpty() || amount.getStepSequence().isPresent() ? " variable" : "";
            Currency currency = notionalSchedule.getFxReset().map(fxr -> fxr.getReferenceCurrency()).orElse(rcLeg.getCurrency());
            return SummarizerUtils.amount(currency, notional) + vary;
        }
        if (leg instanceof RatePeriodSwapLeg) {
            RatePeriodSwapLeg rpLeg = (RatePeriodSwapLeg)leg;
            return SummarizerUtils.amount(((RatePaymentPeriod)rpLeg.getPaymentPeriods().get(0)).getNotionalAmount());
        }
        return "";
    }

    private String legSummary(SwapLeg leg) {
        if (leg instanceof RateCalculationSwapLeg) {
            RateCalculationSwapLeg rcLeg = (RateCalculationSwapLeg)leg;
            RateCalculation calculation = rcLeg.getCalculation();
            if (calculation instanceof FixedRateCalculation) {
                FixedRateCalculation calc = (FixedRateCalculation)calculation;
                String vary = !calc.getRate().getSteps().isEmpty() || calc.getRate().getStepSequence().isPresent() ? " variable" : "";
                return SummarizerUtils.percent(calc.getRate().getInitialValue()) + vary;
            }
            if (calculation instanceof IborRateCalculation) {
                IborRateCalculation calc = (IborRateCalculation)calculation;
                String gearing = calc.getGearing().map(g -> " * " + SummarizerUtils.value(g.getInitialValue())).orElse("");
                String spread = calc.getSpread().map(s -> " + " + SummarizerUtils.percent(s.getInitialValue())).orElse("");
                return calc.getIndex().getName() + gearing + spread;
            }
            if (calculation instanceof OvernightRateCalculation) {
                OvernightRateCalculation calc = (OvernightRateCalculation)calculation;
                String avg = calc.getAccrualMethod() == OvernightAccrualMethod.AVERAGED ? " avg" : "";
                String gearing = calc.getGearing().map(g -> " * " + SummarizerUtils.value(g.getInitialValue())).orElse("");
                String spread = calc.getSpread().map(s -> " + " + SummarizerUtils.percent(s.getInitialValue())).orElse("");
                return calc.getIndex().getName() + avg + gearing + spread;
            }
            if (calculation instanceof InflationRateCalculation) {
                InflationRateCalculation calc = (InflationRateCalculation)calculation;
                String gearing = calc.getGearing().map(g -> " * " + SummarizerUtils.value(g.getInitialValue())).orElse("");
                return calc.getIndex().getName() + gearing;
            }
        }
        if (leg instanceof KnownAmountSwapLeg) {
            KnownAmountSwapLeg kaLeg = (KnownAmountSwapLeg)leg;
            String vary = !kaLeg.getAmount().getSteps().isEmpty() || kaLeg.getAmount().getStepSequence().isPresent() ? " variable" : "";
            return SummarizerUtils.amount(kaLeg.getCurrency(), kaLeg.getAmount().getInitialValue()) + vary;
        }
        ImmutableSet<Index> allIndices = leg.allIndices();
        return allIndices.isEmpty() ? "Fixed" : allIndices.toString();
    }

    public Swap replaceStartDate(LocalDate adjustedStartDate) {
        return new Swap((List)this.legs.stream().map(leg -> leg.replaceStartDate(adjustedStartDate)).collect(Guavate.toImmutableList()));
    }

    public ResolvedSwap resolve(ReferenceData refData) {
        ImmutableList.Builder resolvedLegs = ImmutableList.builder();
        ImmutableSet.Builder currencies = ImmutableSet.builder();
        ImmutableSet.Builder indices = ImmutableSet.builder();
        for (SwapLeg leg : this.legs) {
            ResolvedSwapLeg resolvedLeg = leg.resolve(refData);
            resolvedLegs.add((Object)resolvedLeg);
            currencies.add((Object)resolvedLeg.getCurrency());
            leg.collectIndices((ImmutableSet.Builder<Index>)indices);
        }
        return new ResolvedSwap((ImmutableList<ResolvedSwapLeg>)resolvedLegs.build(), (ImmutableSet<Currency>)currencies.build(), (ImmutableSet<Index>)indices.build());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Swap(List<? extends SwapLeg> legs) {
        JodaBeanUtils.notEmpty(legs, (String)"legs");
        this.legs = ImmutableList.copyOf(legs);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<SwapLeg> getLegs() {
        return this.legs;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Swap other = (Swap)obj;
            return JodaBeanUtils.equal(this.legs, other.legs);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.legs);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("Swap{");
        buf.append("legs").append('=').append(JodaBeanUtils.toString(this.legs)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.getStartDate())).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.getEndDate()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<Swap> {
        private List<? extends SwapLeg> legs = ImmutableList.of();

        private Builder() {
        }

        private Builder(Swap beanToCopy) {
            this.legs = beanToCopy.getLegs();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3317797: {
                    return this.legs;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3317797: {
                    this.legs = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public Swap build() {
            return new Swap(this.legs);
        }

        public Builder legs(List<? extends SwapLeg> legs) {
            JodaBeanUtils.notEmpty(legs, (String)"legs");
            this.legs = legs;
            return this;
        }

        public Builder legs(SwapLeg ... legs) {
            return this.legs((List<? extends SwapLeg>)ImmutableList.copyOf((Object[])legs));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Swap.Builder{");
            buf.append("legs").append('=').append(JodaBeanUtils.toString(this.legs)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString(null)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<SwapLeg>> legs = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legs", Swap.class, ImmutableList.class);
        private final MetaProperty<AdjustableDate> startDate = DirectMetaProperty.ofDerived((MetaBean)this, (String)"startDate", Swap.class, AdjustableDate.class);
        private final MetaProperty<AdjustableDate> endDate = DirectMetaProperty.ofDerived((MetaBean)this, (String)"endDate", Swap.class, AdjustableDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"legs", "startDate", "endDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3317797: {
                    return this.legs;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends Swap> beanType() {
            return Swap.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<SwapLeg>> legs() {
            return this.legs;
        }

        public MetaProperty<AdjustableDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<AdjustableDate> endDate() {
            return this.endDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3317797: {
                    return ((Swap)bean).getLegs();
                }
                case -2129778896: {
                    return ((Swap)bean).getStartDate();
                }
                case -1607727319: {
                    return ((Swap)bean).getEndDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

