/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.swap.SwapIndices;
import com.opengamma.strata.product.swap.type.FixedFloatSwapTemplate;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface SwapIndex
extends Index,
Named {
    @FromString
    public static SwapIndex of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (SwapIndex)SwapIndex.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<SwapIndex> extendedEnum() {
        return SwapIndices.ENUM_LOOKUP;
    }

    public boolean isActive();

    public LocalTime getFixingTime();

    public ZoneId getFixingZone();

    public FixedFloatSwapTemplate getTemplate();

    default public ZonedDateTime calculateFixingDateTime(LocalDate fixingDate) {
        return fixingDate.atTime(this.getFixingTime()).atZone(this.getFixingZone());
    }

    @ToString
    public String getName();
}

