/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.io.CsvFile;
import com.opengamma.strata.collect.io.CsvRow;
import com.opengamma.strata.collect.io.ResourceConfig;
import com.opengamma.strata.collect.io.ResourceLocator;
import com.opengamma.strata.collect.named.NamedLookup;
import com.opengamma.strata.product.swap.ImmutableSwapIndex;
import com.opengamma.strata.product.swap.SwapIndex;
import com.opengamma.strata.product.swap.type.FixedFloatSwapConvention;
import com.opengamma.strata.product.swap.type.FixedFloatSwapTemplate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SwapIndexCsvLookup
implements NamedLookup<SwapIndex> {
    private static final Logger log = Logger.getLogger(SwapIndexCsvLookup.class.getName());
    public static final SwapIndexCsvLookup INSTANCE = new SwapIndexCsvLookup();
    private static final String NAME_FIELD = "Name";
    private static final String ACTIVE_FIELD = "Active";
    private static final String CONVENTION_FIELD = "Convention";
    private static final String TENOR_FIELD = "Tenor";
    private static final String FIXING_TIME_FIELD = "FixingTime";
    private static final String FIXING_ZONE_FIELD = "FixingZone";
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH[:mm]", Locale.ENGLISH);
    private static final ImmutableMap<String, SwapIndex> BY_NAME = SwapIndexCsvLookup.loadFromCsv();

    private SwapIndexCsvLookup() {
    }

    public Map<String, SwapIndex> lookupAll() {
        return BY_NAME;
    }

    private static ImmutableMap<String, SwapIndex> loadFromCsv() {
        List resources = ResourceConfig.orderedResources((String)"SwapIndexData.csv");
        HashMap<String, SwapIndex> map = new HashMap<String, SwapIndex>();
        for (ResourceLocator resource : resources) {
            try {
                CsvFile csv = CsvFile.of((CharSource)resource.getCharSource(), (boolean)true);
                for (CsvRow row : csv.rows()) {
                    SwapIndex parsed = SwapIndexCsvLookup.parseSwapIndex(row);
                    map.put(parsed.getName(), parsed);
                    map.putIfAbsent(parsed.getName().toUpperCase(Locale.ENGLISH), parsed);
                }
            }
            catch (RuntimeException ex) {
                log.log(Level.SEVERE, "Error processing resource as Swap Index CSV file: " + resource, ex);
                return ImmutableMap.of();
            }
        }
        return ImmutableMap.copyOf(map);
    }

    private static SwapIndex parseSwapIndex(CsvRow row) {
        String name = row.getField(NAME_FIELD);
        boolean active = Boolean.parseBoolean(row.getField(ACTIVE_FIELD));
        FixedFloatSwapConvention convention = FixedFloatSwapConvention.of(row.getField(CONVENTION_FIELD));
        Tenor tenor = Tenor.parse((String)row.getField(TENOR_FIELD));
        LocalTime time = LocalTime.parse(row.getField(FIXING_TIME_FIELD), TIME_FORMAT);
        ZoneId zoneId = ZoneId.of(row.getField(FIXING_ZONE_FIELD));
        FixedFloatSwapTemplate template = convention.toTemplate(tenor);
        return ImmutableSwapIndex.builder().name(name).active(active).fixingTime(time).fixingZone(zoneId).template(template).build();
    }
}

